/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.helpers.FileMovingUtil;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalConstants;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalWriter;

class JournalOutputFile
implements MultiFileJournalConstants {
    public static final JournalOutputFile DUMMY_FILE = new JournalOutputFile();
    private final MultiFileJournalWriter parent;
    private final File file;
    private final File tempFile;
    private final FileWriter fileWriter;
    private final XMLEventWriter xmlWriter;
    private final long sizeLimit;
    private final Timer timer;
    private boolean open = true;

    private JournalOutputFile() {
        this.sizeLimit = 0L;
        this.file = null;
        this.tempFile = null;
        this.fileWriter = null;
        this.xmlWriter = null;
        this.parent = null;
        this.timer = null;
        this.open = false;
    }

    JournalOutputFile(MultiFileJournalWriter parent, String filenamePrefix, File journalDirectory, long sizeLimit, long ageLimit) throws JournalException {
        try {
            this.parent = parent;
            this.sizeLimit = sizeLimit;
            this.file = this.createFilename(filenamePrefix, journalDirectory);
            this.tempFile = this.createTempFilename(this.file, journalDirectory);
            this.fileWriter = this.createTempFile(this.tempFile);
            this.xmlWriter = this.createXmlEventWriter(this.fileWriter);
            this.parent.getDocumentHeader(this.xmlWriter);
            this.timer = this.createTimer(ageLimit);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    private File createFilename(String filenamePrefix, File journalDirectory) throws JournalException {
        String filename = JournalHelper.createTimestampedFilename(filenamePrefix, new Date());
        File theFile = new File(journalDirectory, filename);
        if (theFile.exists()) {
            throw new JournalException("File '" + theFile.getPath() + "' already exists.");
        }
        return theFile;
    }

    private File createTempFilename(File permanentFile, File journalDirectory) {
        String tempFilename = "_" + permanentFile.getName();
        File file2 = new File(journalDirectory, tempFilename);
        return file2;
    }

    private FileWriter createTempFile(File tempfile) throws IOException, JournalException {
        boolean created = tempfile.createNewFile();
        if (!created) {
            throw new JournalException("Unable to create file '" + tempfile.getPath() + "'.");
        }
        return new FileWriter(tempfile);
    }

    private XMLEventWriter createXmlEventWriter(FileWriter fileWriter) throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        return new IndentingXMLEventWriter(factory.createXMLEventWriter(fileWriter));
    }

    private Timer createTimer(long ageLimit) {
        Timer fileTimer = new Timer();
        if (ageLimit >= 0L) {
            fileTimer.schedule((TimerTask)new CloseFileTimerTask(), ageLimit);
        }
        return fileTimer;
    }

    public XMLEventWriter getXmlWriter() {
        return this.xmlWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIfAppropriate() throws JournalException {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            long currentSize = this.tempFile.length();
            if (this.sizeLimit > 0L && currentSize > this.sizeLimit) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JournalException {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            try {
                this.parent.getDocumentTrailer(this.xmlWriter);
                this.xmlWriter.close();
                this.fileWriter.close();
                this.timer.cancel();
                try {
                    FileMovingUtil.move(this.tempFile, this.file);
                }
                catch (IOException e) {
                    throw new JournalException("Failed to rename file from '" + this.tempFile.getPath() + "' to '" + this.file.getPath() + "'", e);
                }
                this.open = false;
            }
            catch (XMLStreamException e) {
                throw new JournalException(e);
            }
            catch (IOException e) {
                throw new JournalException(e);
            }
        }
    }

    private final class CloseFileTimerTask
    extends TimerTask {
        private CloseFileTimerTask() {
        }

        @Override
        public void run() {
            try {
                JournalOutputFile.this.close();
            }
            catch (JournalException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
    }
}

