/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.helpers.ParameterHelper;
import org.fcrepo.server.journal.readerwriter.multifile.JournalInputFile;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalHelper;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalReader;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;

public class LockingFollowingJournalReader
extends MultiFileJournalReader {
    private final long pollingIntervalMillis;
    private final File lockRequestedFile;
    private final File lockAcceptedFile;
    private final boolean pauseBeforePolling;
    private boolean wasLocked = false;

    public LockingFollowingJournalReader(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws JournalException {
        super(parameters, role, recoveryLog, server);
        this.pollingIntervalMillis = MultiFileJournalHelper.parseParametersForPollingInterval(parameters);
        this.lockRequestedFile = new File(MultiFileJournalHelper.getRequiredParameter(parameters, "lockRequestedFilename"));
        this.lockAcceptedFile = new File(MultiFileJournalHelper.getRequiredParameter(parameters, "lockAcceptedFilename"));
        this.pauseBeforePolling = ParameterHelper.getOptionalBooleanParameter(parameters, "pauseBeforePolling", false);
    }

    @Override
    protected synchronized JournalInputFile openNextFile() throws JournalException {
        while (this.open) {
            JournalInputFile nextFile;
            boolean locked = this.processLockingMechanism();
            if (this.pauseBeforePolling) {
                try {
                    this.wait(this.pollingIntervalMillis);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!locked && (nextFile = super.openNextFile()) != null) {
                return nextFile;
            }
            try {
                this.wait(this.pollingIntervalMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    @Override
    public synchronized void shutdown() throws JournalException {
        super.shutdown();
        this.notifyAll();
    }

    private boolean processLockingMechanism() throws JournalException {
        boolean locked;
        if (this.lockRequestedFile.exists()) {
            try {
                if (!this.lockAcceptedFile.exists()) {
                    this.lockAcceptedFile.createNewFile();
                }
            }
            catch (IOException e) {
                throw new JournalException("Unable to create 'Lock Accepted' file at '" + this.lockAcceptedFile.getPath() + "'");
            }
            locked = true;
        } else {
            if (this.lockAcceptedFile.exists()) {
                this.lockAcceptedFile.delete();
            }
            locked = false;
        }
        if (locked && !this.wasLocked) {
            this.recoveryLog.log("Lock request detected: " + this.lockRequestedFile.getPath() + ", Lock accepted: " + this.lockAcceptedFile.getPath());
        } else if (this.wasLocked && !locked) {
            this.recoveryLog.log("Lock request removed: " + this.lockRequestedFile.getPath());
        }
        this.wasLocked = locked;
        return locked;
    }
}

