/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalConstants;

public class MultiFileJournalHelper
implements JournalConstants,
MultiFileJournalConstants {
    static String getRequiredParameter(Map<String, String> parameters, String parameterName) throws JournalException {
        String value = parameters.get(parameterName);
        if (value == null) {
            throw new JournalException("'" + parameterName + "' is required.");
        }
        return value;
    }

    static long parseParametersForPollingInterval(Map<String, String> parameters) throws JournalException {
        Pattern p;
        Matcher m;
        String intervalString = parameters.get("followPollingInterval");
        if (intervalString == null) {
            intervalString = "3";
        }
        if (!(m = (p = Pattern.compile("([0-9]+)([HM]?)")).matcher(intervalString)).matches()) {
            throw new JournalException("Parameter 'followPollingInterval' must be an positive integer number of seconds, optionally followed by 'H'(hours), or 'M'(minutes)");
        }
        long interval = Long.parseLong(m.group(1)) * 1000L;
        String factor = m.group(2);
        if ("H".equals(factor)) {
            interval *= 3600L;
        } else if ("M".equals(factor)) {
            interval *= 60L;
        }
        return interval;
    }

    static File[] getSortedArrayOfJournalFiles(File journalDirectory, String filenamePrefix) {
        JournalFileFilter filter = new JournalFileFilter(filenamePrefix);
        File[] journalFiles = journalDirectory.listFiles(filter);
        Arrays.sort(journalFiles, new FilenameComparator());
        return journalFiles;
    }

    private static class FilenameComparator
    implements Comparator<File> {
        private FilenameComparator() {
        }

        @Override
        public int compare(File first, File second) {
            return first.getName().compareTo(second.getName());
        }
    }

    private static class JournalFileFilter
    implements FileFilter {
        private final String filenamePrefix;

        JournalFileFilter(String filenamePrefix) {
            this.filenamePrefix = filenamePrefix;
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.startsWith(this.filenamePrefix);
        }
    }
}

