/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalReader;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.ConsumerJournalEntry;
import org.fcrepo.server.journal.helpers.ParameterHelper;
import org.fcrepo.server.journal.readerwriter.multifile.JournalInputFile;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalConstants;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalHelper;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;

public class MultiFileJournalReader
extends JournalReader
implements MultiFileJournalConstants {
    private final File journalDirectory;
    private final File archiveDirectory;
    private final String filenamePrefix;
    protected JournalInputFile currentFile;
    protected boolean open = true;

    public MultiFileJournalReader(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws JournalException {
        super(parameters, role, recoveryLog, server);
        this.journalDirectory = ParameterHelper.parseParametersForWritableDirectory(parameters, "journalDirectory");
        this.archiveDirectory = ParameterHelper.parseParametersForWritableDirectory(parameters, "archiveDirectory");
        this.filenamePrefix = ParameterHelper.parseParametersForFilenamePrefix(parameters);
        this.checkDirectoriesAreDifferent();
    }

    private void checkDirectoriesAreDifferent() throws JournalException {
        if (this.archiveDirectory.equals(this.journalDirectory)) {
            throw new JournalException("Archive directory and Journal directory are identical: '" + this.archiveDirectory.getPath() + "'");
        }
    }

    @Override
    public synchronized void shutdown() throws JournalException {
        if (this.open) {
            this.recoveryLog.log("Shutdown requested by server.");
            this.closeCurrentFile();
            this.open = false;
        }
    }

    @Override
    public synchronized ConsumerJournalEntry readJournalEntry() throws JournalException, XMLStreamException {
        if (!this.open) {
            return null;
        }
        this.scanThroughFilesForNextJournalEntry();
        if (this.currentFile == null) {
            return null;
        }
        String identifier = this.peekAtJournalEntryIdentifier(this.currentFile);
        ConsumerJournalEntry journalEntry = super.readJournalEntry(this.currentFile.getReader());
        journalEntry.setIdentifier(identifier);
        return journalEntry;
    }

    private String peekAtJournalEntryIdentifier(JournalInputFile file) throws XMLStreamException {
        StartElement start;
        Attribute timeStamp;
        String fileName = file.getFilename();
        XMLEvent event = file.getReader().peek();
        String timeString = "unknown";
        if (event.isStartElement() && (timeStamp = (start = event.asStartElement()).getAttributeByName(QNAME_ATTR_TIMESTAMP)) != null) {
            timeString = timeStamp.getValue();
        }
        return "file='" + fileName + "', entry='" + timeString + "'";
    }

    private void scanThroughFilesForNextJournalEntry() throws JournalException {
        try {
            while (true) {
                if (this.currentFile != null) {
                    this.advancePastWhitespace(this.currentFile.getReader());
                    XMLEvent next = this.currentFile.getReader().peek();
                    if (this.isStartTagEvent(next, QNAME_TAG_JOURNAL_ENTRY)) {
                        return;
                    }
                    if (this.isEndTagEvent(next, QNAME_TAG_JOURNAL)) {
                        this.closeCurrentFile();
                    } else {
                        throw this.getNotNextMemberOrEndOfGroupException(QNAME_TAG_JOURNAL, QNAME_TAG_JOURNAL_ENTRY, next);
                    }
                }
                if (this.currentFile == null) {
                    this.currentFile = this.openNextFile();
                }
                if (this.currentFile == null) {
                    return;
                }
                this.advanceIntoFile(this.currentFile.getReader());
            }
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    protected JournalInputFile openNextFile() throws JournalException {
        File[] journalFiles = MultiFileJournalHelper.getSortedArrayOfJournalFiles(this.journalDirectory, this.filenamePrefix);
        if (journalFiles.length == 0) {
            return null;
        }
        JournalInputFile nextFile = new JournalInputFile(journalFiles[0]);
        this.recoveryLog.log("Opening journal file: '" + nextFile.getFilename() + "'");
        return nextFile;
    }

    private void advanceIntoFile(XMLEventReader reader) throws XMLStreamException, JournalException {
        XMLEvent event = reader.nextEvent();
        if (!event.isStartDocument()) {
            throw new JournalException("Expecting XML document header, but event was '" + event + "'");
        }
        event = reader.nextTag();
        if (!this.isStartTagEvent(event, QNAME_TAG_JOURNAL)) {
            throw new JournalException("Expecting FedoraJournal start tag, but event was '" + event + "'");
        }
        String hash = this.getOptionalAttributeValue(event.asStartElement(), QNAME_ATTR_REPOSITORY_HASH);
        this.checkRepositoryHash(hash);
    }

    private void closeCurrentFile() throws JournalException {
        if (this.currentFile != null) {
            this.recoveryLog.log("Closing journal file: '" + this.currentFile.getFilename() + "'");
            this.currentFile.closeAndRename(this.archiveDirectory);
            this.currentFile = null;
        }
    }

    public String toString() {
        return super.toString() + ", journalDirectory='" + this.journalDirectory + "', archiveDirectory='" + this.archiveDirectory + "', filenamePrefix='" + this.filenamePrefix + "'";
    }
}

