/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.helpers.ParameterHelper;
import org.fcrepo.server.journal.readerwriter.multifile.JournalOutputFile;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalConstants;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalHelper;

public class MultiFileJournalWriter
extends JournalWriter
implements MultiFileJournalConstants {
    private final File journalDirectory;
    private final String filenamePrefix;
    private final long sizeLimit;
    private final long ageLimit;
    private JournalOutputFile currentJournal = JournalOutputFile.DUMMY_FILE;
    private boolean open = true;

    public MultiFileJournalWriter(Map<String, String> parameters, String role, ServerInterface server) throws JournalException {
        super(parameters, role, server);
        this.journalDirectory = ParameterHelper.parseParametersForWritableDirectory(parameters, "journalDirectory");
        this.filenamePrefix = ParameterHelper.parseParametersForFilenamePrefix(parameters);
        this.sizeLimit = ParameterHelper.parseParametersForSizeLimit(parameters);
        this.ageLimit = ParameterHelper.parseParametersForAgeLimit(parameters);
        this.checkForPotentialFilenameConflict();
    }

    private void checkForPotentialFilenameConflict() throws JournalException {
        String potentialFilename;
        File[] journalFiles = MultiFileJournalHelper.getSortedArrayOfJournalFiles(this.journalDirectory, this.filenamePrefix);
        if (journalFiles.length == 0) {
            return;
        }
        String newestFilename = journalFiles[journalFiles.length - 1].getName();
        if (newestFilename.compareTo(potentialFilename = JournalHelper.createTimestampedFilename(this.filenamePrefix, new Date())) > 0) {
            throw new JournalException("The name of one or more existing files in the journal directory (e.g. '" + newestFilename + "') may conflict with new Journal " + "files. Has the system clock changed?");
        }
    }

    @Override
    public void prepareToWriteJournalEntry() throws JournalException {
        if (this.open) {
            this.currentJournal.closeIfAppropriate();
            if (!this.currentJournal.isOpen()) {
                this.currentJournal = new JournalOutputFile(this, this.filenamePrefix, this.journalDirectory, this.sizeLimit, this.ageLimit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeJournalEntry(CreatorJournalEntry journalEntry) throws JournalException {
        if (this.open) {
            try {
                Object object = JournalWriter.SYNCHRONIZER;
                synchronized (object) {
                    XMLEventWriter xmlWriter = this.currentJournal.getXmlWriter();
                    super.writeJournalEntry(journalEntry, xmlWriter);
                    xmlWriter.flush();
                    this.currentJournal.closeIfAppropriate();
                }
            }
            catch (XMLStreamException e) {
                throw new JournalException(e);
            }
        }
    }

    @Override
    public void shutdown() throws JournalException {
        if (this.open) {
            this.currentJournal.close();
            this.open = false;
        }
    }

    void getDocumentHeader(XMLEventWriter xmlWriter) throws JournalException {
        super.writeDocumentHeader(xmlWriter);
    }

    void getDocumentTrailer(XMLEventWriter xmlWriter) throws JournalException {
        super.writeDocumentTrailer(xmlWriter);
    }

    public String toString() {
        return super.toString() + ", journalDirectory='" + this.journalDirectory + "', filenamePrefix='" + this.filenamePrefix + "', sizeLimit=" + this.sizeLimit + "(bytes), ageLimit=" + this.ageLimit + "(msec)";
    }
}

