/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.singlefile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalReader;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.ConsumerJournalEntry;
import org.fcrepo.server.journal.readerwriter.singlefile.SingleFileJournalConstants;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;

public class SingleFileJournalReader
extends JournalReader
implements SingleFileJournalConstants {
    private final File journalFile;
    private final XMLEventReader reader;
    private boolean open = true;
    private boolean advancedPastHeader = false;

    public SingleFileJournalReader(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws ModuleInitializationException, JournalException {
        super(parameters, role, recoveryLog, server);
        recoveryLog.log("Using a SingleFileJournalReader");
        if (!parameters.containsKey("journalFilename")) {
            throw new ModuleInitializationException("Parameter 'journalFilename' not set.", role);
        }
        String filename = parameters.get("journalFilename");
        this.journalFile = new File(filename);
        if (!this.journalFile.exists()) {
            throw new ModuleInitializationException("Journal file '" + this.journalFile.getPath() + "' does not exist.", role);
        }
        if (!this.journalFile.isFile()) {
            throw new ModuleInitializationException("Journal file '" + this.journalFile.getPath() + "' is not a file.", role);
        }
        if (!this.journalFile.canRead()) {
            throw new ModuleInitializationException("Journal file '" + this.journalFile.getPath() + "' is not readable.", role);
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.reader = factory.createXMLEventReader(new FileReader(this.journalFile));
        }
        catch (FileNotFoundException e) {
            throw new ModuleInitializationException("Problem dumping file", role);
        }
        catch (XMLStreamException e) {
            throw new ModuleInitializationException("Error opening XML Event reader on Journal file '" + this.journalFile.getPath() + "'", role, e);
        }
    }

    private void advanceIntoFile() throws XMLStreamException, JournalException {
        XMLEvent event = this.reader.nextEvent();
        if (!event.isStartDocument()) {
            throw new JournalException("Expecting XML document header, but event was '" + event + "'");
        }
        event = this.reader.nextTag();
        if (!this.isStartTagEvent(event, QNAME_TAG_JOURNAL)) {
            throw new JournalException("Expecting FedoraJournal start tag, but event was '" + event + "'");
        }
        String hash = this.getOptionalAttributeValue(event.asStartElement(), QNAME_ATTR_REPOSITORY_HASH);
        this.checkRepositoryHash(hash);
    }

    @Override
    public synchronized ConsumerJournalEntry readJournalEntry() throws JournalException, XMLStreamException {
        if (!this.open) {
            return null;
        }
        if (!this.advancedPastHeader) {
            this.advanceIntoFile();
            this.advancedPastHeader = true;
        }
        XMLEvent next = this.reader.peek();
        while (next.isCharacters() && next.asCharacters().isWhiteSpace()) {
            this.reader.nextEvent();
            next = this.reader.peek();
        }
        if (this.isStartTagEvent(next, QNAME_TAG_JOURNAL_ENTRY)) {
            String identifier = this.peekAtJournalEntryIdentifier();
            ConsumerJournalEntry journalEntry = super.readJournalEntry(this.reader);
            journalEntry.setIdentifier(identifier);
            return journalEntry;
        }
        if (this.isEndTagEvent(next, QNAME_TAG_JOURNAL)) {
            return null;
        }
        throw this.getNotNextMemberOrEndOfGroupException(QNAME_TAG_JOURNAL, QNAME_TAG_JOURNAL_ENTRY, next);
    }

    private String peekAtJournalEntryIdentifier() throws XMLStreamException {
        StartElement start;
        Attribute timeStamp;
        XMLEvent event = this.reader.peek();
        String timeString = "unknown";
        if (event.isStartElement() && (timeStamp = (start = event.asStartElement()).getAttributeByName(QNAME_ATTR_TIMESTAMP)) != null) {
            timeString = timeStamp.getValue();
        }
        return "entry='" + timeString + "'";
    }

    @Override
    public synchronized void shutdown() throws JournalException {
        try {
            if (this.open) {
                this.reader.close();
                this.open = false;
            }
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    public String toString() {
        return super.toString() + ", journalFile='" + this.journalFile.getPath() + "'";
    }
}

