/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.singlefile;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.journal.readerwriter.singlefile.SingleFileJournalConstants;

public class SingleFileJournalWriter
extends JournalWriter
implements SingleFileJournalConstants {
    private final FileWriter out;
    private final XMLEventWriter writer;
    private boolean fileHasHeader = false;

    public SingleFileJournalWriter(Map<String, String> parameters, String role, ServerInterface server) throws JournalException {
        super(parameters, role, server);
        if (!parameters.containsKey("journalFilename")) {
            throw new JournalException("Parameter 'journalFilename' not set.");
        }
        try {
            this.out = new FileWriter(parameters.get("journalFilename"));
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = new IndentingXMLEventWriter(factory.createXMLEventWriter(this.out));
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    @Override
    public void prepareToWriteJournalEntry() throws JournalException {
        if (!this.fileHasHeader) {
            super.writeDocumentHeader(this.writer);
            this.fileHasHeader = true;
        }
    }

    @Override
    public void writeJournalEntry(CreatorJournalEntry journalEntry) throws JournalException {
        try {
            super.writeJournalEntry(journalEntry, this.writer);
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    @Override
    public void shutdown() throws JournalException {
        try {
            if (this.fileHasHeader) {
                super.writeDocumentTrailer(this.writer);
            }
            this.writer.close();
            this.out.close();
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
    }
}

