/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.recoverylog;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedJournalRecoveryLog
extends JournalRecoveryLog {
    private static final Logger logger = LoggerFactory.getLogger(BufferedJournalRecoveryLog.class);
    private final File logFile;
    private final StringWriter buffer = new StringWriter();
    private boolean open = true;

    public BufferedJournalRecoveryLog(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        super(parameters, role, server);
        if (!parameters.containsKey("recoveryLogFilename")) {
            throw new ModuleInitializationException("Parameter 'recoveryLogFilename' is not set.", role);
        }
        String fileName = parameters.get("recoveryLogFilename");
        this.logFile = new File(fileName);
        super.logHeaderInfo(parameters);
    }

    @Override
    public synchronized void log(String message) {
        if (this.open) {
            this.log(message, this.buffer);
        }
    }

    @Override
    public synchronized void shutdown() {
        try {
            if (this.open) {
                this.open = false;
                FileWriter logWriter = new FileWriter(this.logFile);
                logWriter.write(this.buffer.toString());
                logWriter.close();
            }
        }
        catch (IOException e) {
            logger.error("Error shutting down", (Throwable)e);
        }
    }

    public String toString() {
        return super.toString() + ", logFile='" + this.logFile.getPath() + "'";
    }
}

