/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.recoverylog;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.ConsumerJournalEntry;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JournalRecoveryLog
implements JournalConstants {
    private static final Logger logger = LoggerFactory.getLogger(JournalRecoveryLog.class);
    private static final int LEVEL_LOW = 0;
    private static final int LEVEL_MEDIUM = 1;
    private static final int LEVEL_HIGH = 2;
    protected final ServerInterface server;
    private final int logLevel;

    public static JournalRecoveryLog getInstance(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        try {
            Object recoveryLog = JournalHelper.createInstanceAccordingToParameter("journalRecoveryLogClassname", new Class[]{Map.class, String.class, ServerInterface.class}, new Object[]{parameters, role, server}, parameters);
            logger.info("JournalRecoveryLog is " + recoveryLog.toString());
            return (JournalRecoveryLog)recoveryLog;
        }
        catch (JournalException e) {
            throw new ModuleInitializationException("Can't create JournalRecoveryLog", role, e);
        }
    }

    protected JournalRecoveryLog(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        this.server = server;
        String level = parameters.get("recoveryLogLevel");
        if (level == null) {
            this.logLevel = 0;
        } else if ("high".equals(level)) {
            this.logLevel = 2;
        } else if ("medium".equals(level)) {
            this.logLevel = 1;
        } else if ("low".equals(level)) {
            this.logLevel = 0;
        } else {
            throw new ModuleInitializationException("'recoveryLogLevel' parameter must be 'low'(default), 'medium' or 'high'", role);
        }
    }

    public abstract void log(String var1);

    public abstract void shutdown();

    public void shutdown(String message) {
        this.log(message);
        this.shutdown();
    }

    public void logHeaderInfo(Map<String, String> parameters) {
        StringBuffer buffer = new StringBuffer("Recovery parameters:");
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            buffer.append("\n    ").append((Object)key).append("=").append((Object)value);
        }
        this.log(buffer.toString());
    }

    public void log(ConsumerJournalEntry journalEntry) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Event: method='").append(journalEntry.getMethodName()).append("', ").append(journalEntry.getIdentifier()).append("\n");
        if (this.logLevel == 2) {
            JournalEntryContext context = journalEntry.getContext();
            buffer.append("    context=").append(context.getClass().getName()).append("\n");
            buffer.append(this.writeMapValues("environmentAttributes", context.getEnvironmentAttributes()));
            buffer.append(this.writeMapValues("subjectAttributes", context.getSubjectAttributes()));
            buffer.append(this.writeMapValues("actionAttributes", context.getActionAttributes()));
            buffer.append(this.writeMapValues("resourceAttributes", context.getResourceAttributes()));
            buffer.append(this.writeMapValues("recoveryAttributes", context.getRecoveryAttributes()));
            buffer.append("        password='*********'\n");
            buffer.append("        noOp=").append(context.getNoOp()).append("\n");
        }
        if (this.logLevel == 2 || this.logLevel == 1) {
            buffer.append("        now=" + journalEntry.getContext().getNoOp() + "\n");
            buffer.append("    arguments\n");
            Map<String, Object> argumentsMap = journalEntry.getArgumentsMap();
            for (String name : argumentsMap.keySet()) {
                Object value = argumentsMap.get(name);
                if (value instanceof String[]) {
                    buffer.append(this.writeStringArray(name, (String[])value));
                    continue;
                }
                buffer.append("        " + name + "='" + value + "'\n");
            }
        }
        this.log(buffer.toString());
    }

    private String writeStringArray(String name, String[] values) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("        ").append(name).append("=[");
        for (int i = 0; i < values.length; ++i) {
            buffer.append("'").append(values[i]).append("'");
            if (i >= values.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]\n");
        return buffer.toString();
    }

    private String writeMapValues(String mapName, MultiValueMap map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("        " + mapName + "\n");
        Iterator<String> names = map.names();
        while (names.hasNext()) {
            String[] values;
            String name = names.next();
            buffer.append("            ").append(name).append("\n");
            for (String element : values = map.getStringArray(name)) {
                buffer.append("                ").append(element).append("\n");
            }
        }
        return buffer.toString();
    }

    protected void log(String message, Writer writer) {
        try {
            writer.write(JournalHelper.formatDate(new Date()) + ": " + message + "\n");
        }
        catch (IOException e) {
            logger.error("Error writing journal log entry", (Throwable)e);
        }
    }
}

