/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.recoverylog;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnbufferedJournalRecoveryLog
extends JournalRecoveryLog {
    private static final Logger logger = LoggerFactory.getLogger(UnbufferedJournalRecoveryLog.class);
    private final File logFile;
    private final FileWriter writer;
    private boolean open = true;

    public UnbufferedJournalRecoveryLog(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        super(parameters, role, server);
        try {
            if (!parameters.containsKey("recoveryLogFilename")) {
                throw new ModuleInitializationException("Parameter 'recoveryLogFilename' is not set.", role);
            }
            String fileName = parameters.get("recoveryLogFilename");
            this.logFile = new File(fileName);
            this.writer = new FileWriter(this.logFile);
            super.logHeaderInfo(parameters);
        }
        catch (IOException e) {
            throw new ModuleInitializationException("Problem writing to the recovery log", role, e);
        }
    }

    @Override
    public synchronized void log(String message) {
        try {
            if (this.open) {
                this.log(message, this.writer);
                this.writer.flush();
            }
        }
        catch (IOException e) {
            logger.error("Error writing journal log entry", (Throwable)e);
        }
    }

    @Override
    public synchronized void shutdown() {
        try {
            if (this.open) {
                this.open = false;
                this.writer.close();
            }
        }
        catch (IOException e) {
            logger.error("Error shutting down journal log", (Throwable)e);
        }
    }

    public String toString() {
        return super.toString() + ", logFile='" + this.logFile.getPath() + "'";
    }
}

