/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.xmlhelpers;

import java.util.ArrayList;
import java.util.Date;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.helpers.PasswordCipher;
import org.fcrepo.server.journal.xmlhelpers.AbstractXmlReader;

public class ContextXmlReader
extends AbstractXmlReader {
    private String passwordType;

    public JournalEntryContext readContext(XMLEventReader reader) throws JournalException, XMLStreamException {
        JournalEntryContext context = new JournalEntryContext();
        XMLEvent event = reader.nextTag();
        if (!this.isStartTagEvent(event, QNAME_TAG_CONTEXT)) {
            throw this.getNotStartTagException(QNAME_TAG_CONTEXT, event);
        }
        context.setPassword(this.readContextPassword(reader));
        context.setNoOp(this.readContextNoOp(reader));
        context.setNow(this.readContextNow(reader));
        context.setEnvironmentAttributes(this.readMultiMap(reader, "environment"));
        context.setSubjectAttributes(this.readMultiMap(reader, "subject"));
        context.setActionAttributes(this.readMultiMap(reader, "action"));
        context.setResourceAttributes(this.readMultiMap(reader, "resource"));
        context.setRecoveryAttributes(this.readMultiMap(reader, "recovery"));
        event = reader.nextTag();
        if (!this.isEndTagEvent(event, QNAME_TAG_CONTEXT)) {
            throw this.getNotEndTagException(QNAME_TAG_CONTEXT, event);
        }
        this.decipherPassword(context);
        return context;
    }

    private String readContextPassword(XMLEventReader reader) throws JournalException, XMLStreamException {
        XMLEvent startTag = this.readStartTag(reader, QNAME_TAG_PASSWORD);
        this.passwordType = this.getOptionalAttributeValue(startTag.asStartElement(), QNAME_ATTR_PASSWORD_TYPE);
        return this.readCharactersUntilEndTag(reader, QNAME_TAG_PASSWORD);
    }

    private boolean readContextNoOp(XMLEventReader reader) throws XMLStreamException, JournalException {
        this.readStartTag(reader, QNAME_TAG_NOOP);
        String value = this.readCharactersUntilEndTag(reader, QNAME_TAG_NOOP);
        return Boolean.valueOf(value);
    }

    private Date readContextNow(XMLEventReader reader) throws XMLStreamException, JournalException {
        this.readStartTag(reader, QNAME_TAG_NOW);
        String value = this.readCharactersUntilEndTag(reader, QNAME_TAG_NOW);
        return JournalHelper.parseDate(value);
    }

    private MultiValueMap readMultiMap(XMLEventReader reader, String mapName) throws JournalException, XMLStreamException {
        MultiValueMap map = new MultiValueMap();
        XMLEvent event = reader.nextTag();
        if (!this.isStartTagEvent(event, QNAME_TAG_MULTI_VALUE_MAP)) {
            throw this.getNotStartTagException(QNAME_TAG_MULTI_VALUE_MAP, event);
        }
        String value = this.getRequiredAttributeValue(event.asStartElement(), QNAME_ATTR_NAME);
        if (!mapName.equals(value)) {
            throw new JournalException("Expecting a '" + mapName + "' multi-map, but found a '" + value + "' multi-map instead");
        }
        this.readMultiMapKeys(reader, map);
        return map;
    }

    private void readMultiMapKeys(XMLEventReader reader, MultiValueMap map) throws XMLStreamException, JournalException {
        XMLEvent event2;
        while (this.isStartTagEvent(event2 = reader.nextTag(), QNAME_TAG_MULTI_VALUE_MAP_KEY)) {
            String key = this.getRequiredAttributeValue(event2.asStartElement(), QNAME_ATTR_NAME);
            String[] values = this.readMultiMapValuesForKey(reader);
            this.storeInMultiMap(map, key, values);
        }
        if (!this.isEndTagEvent(event2, QNAME_TAG_MULTI_VALUE_MAP)) {
            throw this.getNotNextMemberOrEndOfGroupException(QNAME_TAG_MULTI_VALUE_MAP, QNAME_TAG_MULTI_VALUE_MAP_KEY, event2);
        }
    }

    private String[] readMultiMapValuesForKey(XMLEventReader reader) throws XMLStreamException, JournalException {
        XMLEvent event;
        ArrayList<String> values = new ArrayList<String>();
        while (this.isStartTagEvent(event = reader.nextTag(), QNAME_TAG_MULTI_VALUE_MAP_VALUE)) {
            values.add(this.readCharactersUntilEndTag(reader, QNAME_TAG_MULTI_VALUE_MAP_VALUE));
        }
        if (this.isEndTagEvent(event, QNAME_TAG_MULTI_VALUE_MAP_KEY)) {
            return values.toArray(new String[values.size()]);
        }
        throw this.getNotNextMemberOrEndOfGroupException(QNAME_TAG_MULTI_VALUE_MAP_KEY, QNAME_TAG_MULTI_VALUE_MAP_VALUE, event);
    }

    private void storeInMultiMap(MultiValueMap map, String key, String[] values) throws JournalException {
        try {
            map.set(key, values);
        }
        catch (Exception e) {
            throw new JournalException(e);
        }
    }

    private void decipherPassword(JournalEntryContext context) {
        String key = JournalHelper.formatDate(context.now());
        String passwordCipher = context.getPassword();
        String clearPassword = PasswordCipher.decipher(key, passwordCipher, this.passwordType);
        context.setPassword(clearPassword);
    }
}

