/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.binding.soap.SoapFault;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.StorageDeviceException;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.types.gen.ArrayOfString;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.types.gen.RelationshipTuple;
import org.fcrepo.server.types.gen.Validation;
import org.fcrepo.server.utilities.CXFUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraAPIMImpl
implements FedoraAPIM {
    private static final Logger LOG = LoggerFactory.getLogger(FedoraAPIMImpl.class);
    @Resource
    private WebServiceContext context;
    private final Server m_server;
    private final Management m_management;

    public FedoraAPIMImpl(Server server) {
        this.m_server = server;
        this.m_management = (Management)((Object)this.m_server.getModule("org.fcrepo.server.management.Management"));
    }

    public String ingest(byte[] objectXML, String format, String logMessage) {
        LOG.debug("start: ingest");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            String string = this.m_management.ingest(ReadOnlyContext.getSoapContext(ctx), new ByteArrayInputStream(objectXML), logMessage, format, "UTF-8", "new");
            return string;
        }
        catch (Throwable th) {
            LOG.error("Error ingesting", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: ingest");
        }
    }

    public String modifyObject(String pid, String state, String label, String ownerId, String logMessage) {
        LOG.debug("start: modifyObject, " + pid);
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            String string = DateUtility.convertDateToString((Date)this.m_management.modifyObject(ReadOnlyContext.getSoapContext(ctx), pid, state, label, ownerId, logMessage, null));
            return string;
        }
        catch (Throwable th) {
            LOG.error("Error modifying object", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: modifyObject, " + pid);
        }
    }

    public byte[] getObjectXML(String pid) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            InputStream in = this.m_management.getObjectXML(ReadOnlyContext.getSoapContext(ctx), pid, "UTF-8");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.pipeStream(in, out);
            return out.toByteArray();
        }
        catch (Throwable th) {
            LOG.error("Error getting object XML", th);
            throw CXFUtility.getFault(th);
        }
    }

    public byte[] export(String pid, String format, String context) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            InputStream in = this.m_management.export(ReadOnlyContext.getSoapContext(ctx), pid, format, context, "UTF-8");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.pipeStream(in, out);
            return out.toByteArray();
        }
        catch (Throwable th) {
            LOG.error("Error exporting object", th);
            throw CXFUtility.getFault(th);
        }
    }

    public String purgeObject(String pid, String logMessage, boolean force) {
        LOG.debug("start: purgeObject, " + pid);
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            String string = DateUtility.convertDateToString((Date)this.m_management.purgeObject(ReadOnlyContext.getSoapContext(ctx), pid, logMessage));
            return string;
        }
        catch (Throwable th) {
            LOG.error("Error purging object", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: purgeObject, " + pid);
        }
    }

    public String addDatastream(String pid, String dsID, ArrayOfString altIDs, String dsLabel, boolean versionable, String mimeType, String formatURI, String dsLocation, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) {
        LOG.debug("start: addDatastream, " + pid + ", " + dsID);
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            String[] altIDsArray = null;
            if (altIDs != null && altIDs.getItem() != null) {
                altIDsArray = altIDs.getItem().toArray(new String[0]);
            }
            String string = this.m_management.addDatastream(ReadOnlyContext.getSoapContext(ctx), pid, dsID, altIDsArray, dsLabel, versionable, mimeType, formatURI, dsLocation, controlGroup, dsState, checksumType, checksum, logMessage);
            return string;
        }
        catch (Throwable th) {
            LOG.error("Error adding datastream", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: addDatastream, " + pid + ", " + dsID);
        }
    }

    public String modifyDatastreamByReference(String pid, String dsID, ArrayOfString altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, boolean force) {
        LOG.debug("start: modifyDatastreamByReference, " + pid + ", " + dsID);
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            String[] altIDsArray = null;
            if (altIDs != null && altIDs.getItem() != null) {
                altIDsArray = altIDs.getItem().toArray(new String[0]);
            }
            String string = DateUtility.convertDateToString((Date)this.m_management.modifyDatastreamByReference(ReadOnlyContext.getSoapContext(ctx), pid, dsID, altIDsArray, dsLabel, mimeType, formatURI, dsLocation, checksumType, checksum, logMessage, null));
            return string;
        }
        catch (Throwable th) {
            LOG.error("Error modifying datastream by reference", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: modifyDatastreamByReference, " + pid + ", " + dsID);
        }
    }

    public String modifyDatastreamByValue(String pid, String dsID, ArrayOfString altIDs, String dsLabel, String mimeType, String formatURI, byte[] dsContent, String checksumType, String checksum, String logMessage, boolean force) {
        LOG.debug("start: modifyDatastreamByValue, " + pid + ", " + dsID);
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            String[] altIDsArray = null;
            if (altIDs != null && altIDs.getItem() != null) {
                altIDsArray = altIDs.getItem().toArray(new String[0]);
            }
            String string = DateUtility.convertDateToString((Date)this.m_management.modifyDatastreamByValue(ReadOnlyContext.getSoapContext(ctx), pid, dsID, altIDsArray, dsLabel, mimeType, formatURI, new ByteArrayInputStream(dsContent), checksumType, checksum, logMessage, null));
            return string;
        }
        catch (Throwable th) {
            LOG.error("Error modifying datastream by value", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: modifyDatastreamByValue, " + pid + ", " + dsID);
        }
    }

    public String setDatastreamState(String pid, String dsID, String dsState, String logMessage) {
        LOG.info("Executing operation setDatastreamState");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            return DateUtility.convertDateToString((Date)this.m_management.setDatastreamState(ReadOnlyContext.getSoapContext(ctx), pid, dsID, dsState, logMessage));
        }
        catch (Throwable th) {
            LOG.error("Error setting datastream state", th);
            throw CXFUtility.getFault(th);
        }
    }

    public String setDatastreamVersionable(String pid, String dsID, boolean versionable, String logMessage) {
        LOG.info("Executing operation setDatastreamVersionable");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            return DateUtility.convertDateToString((Date)this.m_management.setDatastreamVersionable(ReadOnlyContext.getSoapContext(ctx), pid, dsID, versionable, logMessage));
        }
        catch (Throwable th) {
            LOG.error("Error setting datastream state", th);
            throw CXFUtility.getFault(th);
        }
    }

    public String compareDatastreamChecksum(String pid, String dsID, String versionDate) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            return this.m_management.compareDatastreamChecksum(ReadOnlyContext.getSoapContext(ctx), pid, dsID, DateUtility.parseDateOrNull((String)versionDate));
        }
        catch (Throwable th) {
            LOG.error("Error comparing datastream checksum", th);
            throw CXFUtility.getFault(th);
        }
    }

    public Datastream getDatastream(String pid, String dsID, String asOfDateTime) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            org.fcrepo.server.storage.types.Datastream ds = this.m_management.getDatastream(ReadOnlyContext.getSoapContext(ctx), pid, dsID, DateUtility.parseDateOrNull((String)asOfDateTime));
            return TypeUtility.convertDatastreamToGenDatastream(ds);
        }
        catch (Throwable th) {
            LOG.error("Error getting datastream", th);
            throw CXFUtility.getFault(th);
        }
    }

    public List<Datastream> getDatastreams(String pid, String asOfDateTime, String dsState) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            org.fcrepo.server.storage.types.Datastream[] intDatastreams = this.m_management.getDatastreams(ReadOnlyContext.getSoapContext(ctx), pid, DateUtility.parseDateOrNull((String)asOfDateTime), dsState);
            return this.getGenDatastreams(intDatastreams);
        }
        catch (Throwable th) {
            LOG.error("Error getting datastreams", th);
            throw CXFUtility.getFault(th);
        }
    }

    public List<Datastream> getDatastreamHistory(String pid, String dsID) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            org.fcrepo.server.storage.types.Datastream[] intDatastreams = this.m_management.getDatastreamHistory(ReadOnlyContext.getSoapContext(ctx), pid, dsID);
            return this.getGenDatastreams(intDatastreams);
        }
        catch (Throwable th) {
            LOG.error("Error getting datastream history", th);
            throw CXFUtility.getFault(th);
        }
    }

    public List<String> purgeDatastream(String pid, String dsID, String startDT, String endDT, String logMessage, boolean force) {
        LOG.debug("start: purgeDatastream, " + pid + ", " + dsID);
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            List<String> list = this.toStringList(this.m_management.purgeDatastream(ReadOnlyContext.getSoapContext(ctx), pid, dsID, DateUtility.parseDateOrNull((String)startDT), DateUtility.parseDateOrNull((String)endDT), logMessage));
            return list;
        }
        catch (Throwable th) {
            LOG.error("Error purging datastream", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: purgeDatastream, " + pid + ", " + dsID);
        }
    }

    public List<String> getNextPID(BigInteger numPIDs, String pidNamespace) {
        LOG.debug("start: getNextPID");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            if (numPIDs == null) {
                numPIDs = new BigInteger("1");
            }
            String[] aux = this.m_management.getNextPID(ReadOnlyContext.getSoapContext(ctx), numPIDs.intValue(), pidNamespace);
            List<String> auxList = null;
            if (aux != null) {
                auxList = Arrays.asList(aux);
            }
            List<String> list = auxList;
            return list;
        }
        catch (Throwable th) {
            LOG.error("Error getting next PID", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: getNextPID");
        }
    }

    public List<RelationshipTuple> getRelationships(String pid, String relationship) {
        LOG.debug("start: getRelationships");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            org.fcrepo.server.storage.types.RelationshipTuple[] intRelationshipTuples = null;
            intRelationshipTuples = this.m_management.getRelationships(ReadOnlyContext.getSoapContext(ctx), pid, relationship);
            List<RelationshipTuple> list = this.getGenRelsTuples(intRelationshipTuples);
            return list;
        }
        catch (Throwable th) {
            LOG.error("Error getting relationships", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: getRelationships");
        }
    }

    public boolean addRelationship(String pid, String relationship, String object, boolean isLiteral, String datatype) {
        LOG.debug("start: addRelationship");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            boolean bl = this.m_management.addRelationship(ReadOnlyContext.getSoapContext(ctx), pid, relationship, object, isLiteral, datatype);
            return bl;
        }
        catch (Throwable th) {
            LOG.error("Error adding relationships", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: addRelationship");
        }
    }

    public boolean purgeRelationship(String pid, String relationship, String object, boolean isLiteral, String datatype) {
        LOG.debug("start: purgeRelationship");
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            boolean bl = this.m_management.purgeRelationship(ReadOnlyContext.getSoapContext(ctx), pid, relationship, object, isLiteral, datatype);
            return bl;
        }
        catch (Throwable th) {
            LOG.error("Error purging relationships", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: purgeRelationship");
        }
    }

    public Validation validate(String pid, String asOfDateTime) {
        this.assertInitialized();
        try {
            MessageContext ctx = this.context.getMessageContext();
            Validation validation = TypeUtility.convertValidationToGenValidation(this.m_management.validate(ReadOnlyContext.getSoapContext(ctx), pid, DateUtility.parseDateOrNull((String)asOfDateTime)));
            return validation;
        }
        catch (Throwable th) {
            LOG.error("Error purging relationships", th);
            throw CXFUtility.getFault(th);
        }
        finally {
            LOG.debug("end: purgeRelationship");
        }
    }

    private void assertInitialized() throws SoapFault {
        if (this.m_server == null) {
            CXFUtility.throwFault(new ModuleInitializationException("Null was injected for Server to WS implementor", "org.fcrepo.server.management.FedoraAPIM"));
        }
        if (this.m_management == null) {
            CXFUtility.throwFault(new ModuleInitializationException("No Management module found for WS implementor", "org.fcrepo.server.management.FedoraAPIM"));
        }
    }

    private void pipeStream(InputStream in, OutputStream out) throws StorageDeviceException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new StorageDeviceException("Error writing to stream");
        }
        finally {
            try {
                out.close();
                in.close();
            }
            catch (IOException closeProb) {}
        }
    }

    private List<RelationshipTuple> getGenRelsTuples(org.fcrepo.server.storage.types.RelationshipTuple[] intRelsTuples) {
        ArrayList<RelationshipTuple> genRelsTuples = new ArrayList<RelationshipTuple>(intRelsTuples.length);
        for (org.fcrepo.server.storage.types.RelationshipTuple tuple : intRelsTuples) {
            genRelsTuples.add(TypeUtility.convertRelsTupleToGenRelsTuple(tuple));
        }
        return genRelsTuples;
    }

    private List<String> toStringList(Date[] dates) throws Exception {
        ArrayList<String> out = new ArrayList<String>(dates.length);
        for (Date date : dates) {
            out.add(DateUtility.convertDateToString((Date)date));
        }
        return out;
    }

    private List<Datastream> getGenDatastreams(org.fcrepo.server.storage.types.Datastream[] intDatastreams) {
        ArrayList<Datastream> genDatastreams = new ArrayList<Datastream>(intDatastreams.length);
        for (org.fcrepo.server.storage.types.Datastream datastream : intDatastreams) {
            genDatastreams.add(TypeUtility.convertDatastreamToGenDatastream(datastream));
        }
        return genDatastreams;
    }
}

