/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.management.SpringManagementServlet;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNextPIDServlet
extends SpringManagementServlet
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(GetNextPIDServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    public static final String ACTION_LABEL = "Get Pid";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean xml = false;
        int numPIDs = 1;
        String namespace = null;
        ReadOnlyContext context = ReadOnlyContext.getContext(GetNextPIDServlet.HTTP_REQUEST.REST.uri, request);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = URLDecoder.decode((String)e.nextElement(), "UTF-8");
            if (name.equalsIgnoreCase("xml")) {
                xml = new Boolean(request.getParameter(name));
            }
            if (name.equalsIgnoreCase("numPIDs")) {
                numPIDs = new Integer(URLDecoder.decode(request.getParameter(name), "UTF-8"));
            }
            if (!name.equalsIgnoreCase("namespace")) continue;
            namespace = URLDecoder.decode(request.getParameter(name), "UTF-8");
        }
        try {
            this.getNextPID(context, numPIDs, namespace, xml, response);
        }
        catch (AuthzException ae) {
            throw RootException.getServletException(ae, request, ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            String msg = "Unexpected error getting next PID";
            logger.error("Unexpected error getting next PID", th);
            throw new InternalError500Exception("Unexpected error getting next PID", th, request, ACTION_LABEL, "Internal Error", new String[0]);
        }
    }

    public void getNextPID(Context context, int numPIDs, String namespace, boolean xml, HttpServletResponse response) throws ServerException {
        OutputStreamWriter out = null;
        PipedWriter pw = null;
        PipedReader pr = null;
        try {
            pw = new PipedWriter();
            pr = new PipedReader(pw);
            String[] pidList = this.m_management.getNextPID(context, numPIDs, namespace);
            if (pidList.length > 0) {
                new GetNextPIDSerializerThread(context, pidList, pw).start();
                if (xml) {
                    response.setContentType(CONTENT_TYPE_XML);
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    int bufSize = 4096;
                    char[] buf = new char[bufSize];
                    int len = 0;
                    while ((len = pr.read(buf, 0, bufSize)) != -1) {
                        out.write(buf, 0, len);
                    }
                    out.flush();
                } else {
                    response.setContentType(CONTENT_TYPE_HTML);
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    File xslFile = new File(this.m_server.getHomeDir(), "management/getNextPIDInfo.xslt");
                    TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                    Templates template = factory.newTemplates(new StreamSource(xslFile));
                    Transformer transformer = template.newTransformer();
                    transformer.transform(new StreamSource(pr), new StreamResult(out));
                }
                out.flush();
            } else {
                String message = "[GetNextPIDServlet] No PIDs returned.";
                logger.error(message);
            }
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new GeneralException("Error while getting next PID", th);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable th) {
                String message = "[GetNextPIDServlet] An error has occured.  The error was a \" " + th.getClass().getName() + " \". Reason: " + th.getMessage();
                throw new StreamIOException(message);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public class GetNextPIDSerializerThread
    extends Thread {
        private PipedWriter pw = null;
        private String[] pidList = null;

        public GetNextPIDSerializerThread(Context context, String[] pidList, PipedWriter pw) {
            this.pw = pw;
            this.pidList = pidList;
            if (Constants.HTTP_REQUEST.SECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri)) || Constants.HTTP_REQUEST.INSECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pw != null) {
                try {
                    this.pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    this.pw.write("<pidList  xmlns=\"" + Constants.PID_LIST1_0.namespace.uri + "\" " + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"" + Constants.PID_LIST1_0.namespace.uri + " " + Constants.PID_LIST1_0.xsdLocation + "\">");
                    for (String element : this.pidList) {
                        this.pw.write("  <pid>" + element + "</pid>\n");
                    }
                    this.pw.write("</pidList>\n");
                    this.pw.flush();
                    this.pw.close();
                }
                catch (IOException ioe) {
                    logger.error("WriteThread error", (Throwable)ioe);
                }
                finally {
                    try {
                        if (this.pw != null) {
                            this.pw.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.warn("WriteThread error", (Throwable)ioe);
                    }
                }
            }
        }
    }
}

