/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.fcrepo.common.Constants;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.management.SpringManagementServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServlet
extends SpringManagementServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadServlet.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
        try {
            ServletFileUpload upload = new ServletFileUpload();
            InputStream in = null;
            FileItemIterator iter = upload.getItemIterator(request);
            while (in == null && iter.hasNext()) {
                FileItemStream item = iter.next();
                logger.info("Got next item: isFormField=" + item.isFormField() + " fieldName=" + item.getFieldName());
                if (item.isFormField() || !item.getFieldName().equals("file")) continue;
                in = item.openStream();
            }
            if (in == null) {
                this.sendResponse(400, "No data sent.", response);
            } else {
                this.sendResponse(201, this.m_management.putTempStream(context, in), response);
            }
        }
        catch (AuthzException ae) {
            throw RootException.getServletException(ae, request, "Upload", new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendResponse(500, e.getClass().getName() + ": " + e.getMessage(), response);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.sendResponse(200, "Client must use HTTP Multipart POST", response);
    }

    public void sendResponse(int status, String message, HttpServletResponse response) {
        try {
            if (status == 201) {
                logger.info("Successful upload, id=" + message);
            } else {
                logger.error("Failed upload: " + message);
            }
            response.setStatus(status);
            response.setContentType("text/plain");
            PrintWriter w = response.getWriter();
            w.println(message);
        }
        catch (Exception e) {
            logger.error("Unable to send response", (Throwable)e);
        }
    }
}

