/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.fcrepo.server.errors.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSManager {
    private static final Logger logger = LoggerFactory.getLogger(JMSManager.class);
    public static final String CONNECTION_FACTORY_NAME = "connection.factory.name";
    private final String defaultConnectionFactoryName = "ConnectionFactory";
    protected Context jndi = null;
    protected Connection connection = null;
    protected boolean connected = false;
    protected Hashtable<String, JMSDestination> jmsDestinations = new Hashtable();
    protected Map<String, MessageConsumer> durableSubscriptions = new HashMap<String, MessageConsumer>();
    private final Properties jndiProps;
    private DestinationType defaultDestinationType = DestinationType.Topic;

    public JMSManager(Properties jndiProps) throws MessagingException {
        this(jndiProps, null);
    }

    public JMSManager(Properties jndiProps, String clientId) throws MessagingException {
        this.jndiProps = jndiProps;
        if (jndiProps == null) {
            String providerUrl = null;
            try {
                providerUrl = (String)this.jndiLookup("java.naming.provider.url");
            }
            catch (MessagingException me) {
                providerUrl = null;
            }
            if (providerUrl == null) {
                throw new MessagingException("JMS connection properties must either be provided by the container or by a non-null properties file containing, at minimum, a value for java.naming.factory.initial and java.naming.provider.url.");
            }
        } else {
            String icf = jndiProps.getProperty("java.naming.factory.initial");
            if (icf == null) {
                throw new MessagingException("A value for java.naming.factory.initial must be included in the JNDI properties.");
            }
            String pUrl = jndiProps.getProperty("java.naming.provider.url");
            if (pUrl == null) {
                throw new MessagingException("A value for java.naming.provider.urlmust be included in the JNDI properties.");
            }
        }
        this.connectToJMS(clientId);
    }

    public Destination createDestination(String name, DestinationType type) throws MessagingException {
        return this.createDestination(name, type, false, 1);
    }

    public Destination createDestination(String name, DestinationType type, boolean fTransacted, int ackMode) throws MessagingException {
        Session session;
        JMSDestination jmsDest = this.jmsDestinations.get(name);
        if (jmsDest != null) {
            return jmsDest.destination;
        }
        try {
            session = this.connection.createSession(fTransacted, ackMode);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        Destination destination = null;
        try {
            destination = (Destination)this.jndiLookup(name);
        }
        catch (MessagingException me) {
            logger.debug("JNDI lookup for destination " + name + " failed. " + "Destination must be created.");
            destination = null;
        }
        if (destination == null) {
            try {
                if (type.equals((Object)DestinationType.Queue)) {
                    logger.debug("setupDestination() - creating Queue" + name);
                    destination = session.createQueue(name);
                } else {
                    logger.debug("setupDestination() - creating Topic " + name);
                    destination = session.createTopic(name);
                }
            }
            catch (JMSException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
        jmsDest = new JMSDestination(destination, session, null, null);
        this.jmsDestinations.put(name, jmsDest);
        return destination;
    }

    public Message listen(String destName) throws MessagingException {
        return this.listen(destName, "");
    }

    public Message listen(String destName, String messageSelector) throws MessagingException {
        if (logger.isDebugEnabled()) {
            logger.debug("listen() - Synchronous listen on destination " + destName);
        }
        JMSDestination jmsDest = this.getJMSDestination(destName);
        return this.setupSynchConsumer(jmsDest, messageSelector, 0);
    }

    public Message listen(Destination dest) throws MessagingException {
        return this.listen(dest, "");
    }

    public Message listen(Destination dest, String messageSelector) throws MessagingException {
        if (logger.isDebugEnabled()) {
            logger.debug("listen() - Synchronous listen on destination " + dest);
        }
        try {
            Session s = this.connection.createSession(false, 1);
            MessageConsumer c = s.createConsumer(dest, messageSelector);
            Message msg = c.receive();
            s.close();
            return msg;
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public Message listen(String destName, int timeout) throws MessagingException {
        return this.listen(destName, "", timeout);
    }

    public Message listen(String destName, String messageSelector, int timeout) throws MessagingException {
        if (logger.isDebugEnabled()) {
            logger.debug("listen() - Synchronous listen on destination " + destName + " with timeout " + timeout);
        }
        JMSDestination jmsDest = this.getJMSDestination(destName);
        return this.setupSynchConsumer(jmsDest, messageSelector, timeout);
    }

    public void listen(String destName, MessageListener callback) throws MessagingException {
        this.listen(destName, "", callback);
    }

    public void listen(String destName, String messageSelector, MessageListener callback) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        this.setupAsynchConsumer(jmsDest, messageSelector, callback);
        if (logger.isDebugEnabled()) {
            logger.debug("listen() - Asynchronous listen on destination " + destName);
        }
    }

    public void listen(Destination dest, MessageListener callback) throws MessagingException {
        this.listen(dest, "", callback);
    }

    public void listen(Destination dest, String messageSelector, MessageListener callback) throws MessagingException {
        try {
            Session s = this.connection.createSession(false, 1);
            MessageConsumer c = s.createConsumer(dest, messageSelector);
            c.setMessageListener(callback);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listen() - Asynchronous listen on destination " + dest);
        }
    }

    public String listenDurable(String topic, MessageListener callback) throws MessagingException {
        return this.listenDurable(topic, callback, null);
    }

    public String listenDurable(String topicName, MessageListener callback, String subscriptionName) throws MessagingException {
        this.createDestination(topicName, DestinationType.Topic);
        Topic topic = (Topic)this.getDestination(topicName);
        return this.listenDurable(topic, "", callback, subscriptionName);
    }

    public String listenDurable(Topic topic, MessageListener callback) throws MessagingException {
        return this.listenDurable(topic, "", callback, null);
    }

    public String listenDurable(Topic topic, String messageSelector, MessageListener callback, String subscriptionName) throws MessagingException {
        try {
            String clientId = this.connection.getClientID();
            if (clientId == null) {
                throw new MessagingException("A non-null client ID must be provided upon creation of a JMSManager in order to create a JMS connection capable of creating durable subscriptions.");
            }
            if (subscriptionName == null) {
                subscriptionName = topic.getTopicName();
            }
            Session s = this.connection.createSession(false, 1);
            TopicSubscriber c = s.createDurableSubscriber(topic, subscriptionName, messageSelector, false);
            c.setMessageListener(callback);
            this.durableSubscriptions.put(subscriptionName, (MessageConsumer)c);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listen() - Asynchronous durable listen on topic " + topic);
        }
        return subscriptionName;
    }

    public void send(String destName, Message msg) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        this.setupProducer(jmsDest);
        try {
            jmsDest.producer.send(msg);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send() - message sent to destination " + destName);
        }
    }

    public void send(Destination dest, Message msg) throws MessagingException {
        try {
            Session s = this.connection.createSession(false, 1);
            MessageProducer p = s.createProducer(dest);
            p.send(msg);
            s.close();
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send() - message sent to destination " + dest);
        }
    }

    public void send(String destName, Serializable obj) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        this.setupProducer(jmsDest);
        try {
            Message msg = this.createJMSMessage(obj, jmsDest.session);
            jmsDest.producer.send(msg);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send() - message sent to destination " + destName);
        }
    }

    public void send(String destName, String messageText) throws MessagingException {
        this.send(destName, (Serializable)((Object)messageText));
    }

    public void stop(String destName) throws MessagingException {
        try {
            JMSDestination jmsDest = this.jmsDestinations.get(destName);
            if (jmsDest != null) {
                if (jmsDest.producer != null) {
                    jmsDest.producer.close();
                    logger.debug("Closed producer for " + destName);
                }
                if (jmsDest.consumer != null) {
                    jmsDest.consumer.close();
                    logger.debug("Closed consumer for " + destName);
                }
                if (jmsDest.session != null) {
                    jmsDest.session.close();
                    logger.debug("Closed session for " + destName);
                }
                jmsDest.destination = null;
                jmsDest.session = null;
                jmsDest.producer = null;
                jmsDest.consumer = null;
                this.jmsDestinations.remove(destName);
                jmsDest = null;
            }
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public void stopDurable(String subscriptionName) throws MessagingException {
        try {
            MessageConsumer durableSubscriber = this.durableSubscriptions.get(subscriptionName);
            if (durableSubscriber != null) {
                durableSubscriber.close();
            }
        }
        catch (JMSException jmse) {
            throw new MessagingException("Exception encountered attempting to stop durable subscription with name: " + subscriptionName + ". Exception message: " + jmse.getMessage(), jmse);
        }
    }

    public void unsubscribeDurable(String subscriptionName) throws MessagingException {
        try {
            Session session = this.connection.createSession(false, 1);
            MessageConsumer consumer = this.durableSubscriptions.get(subscriptionName);
            if (consumer != null) {
                consumer.close();
            }
            session.unsubscribe(subscriptionName);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to unsubscribe from subscription with name: " + subscriptionName + " due to exception: " + jmse.getMessage();
            logger.debug(errMsg, (Throwable)jmse);
            throw new MessagingException(errMsg, jmse);
        }
    }

    public void unsubscribeAllDurable() throws MessagingException {
        for (String name : this.durableSubscriptions.keySet()) {
            this.unsubscribeDurable(name);
        }
    }

    public void close() throws MessagingException {
        try {
            this.connection.stop();
            this.connection.close();
            this.connected = false;
            logger.debug("Connection closed.");
        }
        catch (JMSException e) {
            logger.debug("Error closing Connection.");
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public MapMessage createMapMessage(String destName) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        try {
            return jmsDest.session.createMapMessage();
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public TextMessage createTextMessage(String destName, String text) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        try {
            TextMessage message = jmsDest.session.createTextMessage();
            message.setText(text);
            return message;
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public ObjectMessage createObjectMessage(String destName, Serializable object) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        try {
            ObjectMessage message = jmsDest.session.createObjectMessage();
            message.setObject(object);
            return message;
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public BytesMessage createBytesMessage(String destName) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        try {
            return jmsDest.session.createBytesMessage();
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public Session getSession(String destName) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        return jmsDest.session;
    }

    public Destination getDestination(String destName) throws MessagingException {
        Destination destination = null;
        JMSDestination jmsDest = this.getJMSDestination(destName);
        if (jmsDest != null) {
            destination = jmsDest.destination;
        }
        return destination;
    }

    public List<Destination> getDestinations() {
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        Iterator<JMSDestination> destinationIterator = this.jmsDestinations.values().iterator();
        while (destinationIterator.hasNext()) {
            destinations.add(destinationIterator.next().destination);
        }
        return destinations;
    }

    public MessageProducer getProducer(String destName) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        return jmsDest.producer;
    }

    public MessageConsumer getConsumer(String destName) throws MessagingException {
        JMSDestination jmsDest = this.getJMSDestination(destName);
        return jmsDest.consumer;
    }

    public DestinationType getDefaultDestinationType() {
        return this.defaultDestinationType;
    }

    public void setDefaultDestinationType(DestinationType defaultDestinationType) {
        this.defaultDestinationType = defaultDestinationType;
    }

    protected void connectToJMS(String clientId) throws MessagingException {
        if (this.connected) {
            return;
        }
        try {
            this.connection = this.getConnection();
            if (clientId != null) {
                this.connection.setClientID(clientId);
            }
            this.connection.start();
            this.connected = true;
            logger.debug("connectToJMS - connected");
        }
        catch (JMSException e) {
            this.connected = false;
            logger.error("JMSManager.connectToJMS - Exception occurred:");
            throw new MessagingException(e.getMessage(), e);
        }
    }

    protected JMSDestination getJMSDestination(String name) throws MessagingException {
        JMSDestination jmsDest = this.jmsDestinations.get(name);
        if (jmsDest == null) {
            this.createDestination(name, this.defaultDestinationType);
            jmsDest = this.jmsDestinations.get(name);
        }
        return jmsDest;
    }

    protected void setupProducer(JMSDestination jmsDest) throws MessagingException {
        if (jmsDest.producer != null) {
            return;
        }
        try {
            jmsDest.producer = jmsDest.session.createProducer(jmsDest.destination);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    protected void setupAsynchConsumer(JMSDestination jmsDest, String messageSelector, MessageListener callback) throws MessagingException {
        try {
            if (jmsDest.consumer == null) {
                jmsDest.consumer = jmsDest.session.createConsumer(jmsDest.destination, messageSelector);
            }
            jmsDest.consumer.setMessageListener(callback);
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    protected Message setupSynchConsumer(JMSDestination jmsDest, String messageSelector, int timeout) throws MessagingException {
        try {
            if (jmsDest.consumer == null) {
                jmsDest.consumer = jmsDest.session.createConsumer(jmsDest.destination, messageSelector);
            }
            if (timeout > 0) {
                return jmsDest.consumer.receive((long)timeout);
            }
            return jmsDest.consumer.receive();
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    protected Message createJMSMessage(Serializable obj, Session session) throws JMSException {
        if (obj instanceof String) {
            TextMessage textMsg = session.createTextMessage();
            textMsg.setText((String)((Object)obj));
            return textMsg;
        }
        ObjectMessage objMsg = session.createObjectMessage();
        objMsg.setObject(obj);
        return objMsg;
    }

    protected Connection getConnection() throws MessagingException {
        String connectionFactoryName;
        if (this.jndiProps != null) {
            connectionFactoryName = this.jndiProps.getProperty(CONNECTION_FACTORY_NAME);
            if (connectionFactoryName == null || connectionFactoryName.equals("")) {
                connectionFactoryName = "ConnectionFactory";
            }
        } else {
            throw new MessagingException("Unable to create JMS connection because JNDI properties were not initialized.");
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)this.jndiLookup(connectionFactoryName);
        try {
            this.connection = connectionFactory.createConnection();
        }
        catch (JMSException e) {
            throw new MessagingException(e.getMessage(), e);
        }
        return this.connection;
    }

    protected Object jndiLookup(String name) throws MessagingException {
        if (this.jndi == null) {
            this.jndi = this.getContext();
        }
        try {
            return this.jndi.lookup(name);
        }
        catch (NamingException e) {
            throw new MessagingException("jndiLookup(" + name + ") failed: " + e.getMessage(), e);
        }
    }

    protected Context getContext() throws MessagingException {
        try {
            if (this.jndiProps != null) {
                return new InitialContext(this.jndiProps);
            }
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            if (logger.isDebugEnabled()) {
                logger.debug("InitalContext properties:");
                logger.debug("----------------");
                Hashtable<?, ?> props = initCtx.getEnvironment();
                Set<?> keys = props.keySet();
                for (Object key : keys) {
                    logger.debug(key.toString() + "=" + props.get(key));
                }
                logger.debug("java:comp/env context properties:");
                logger.debug("----------------");
                props = envCtx.getEnvironment();
                keys = props.keySet();
                for (Object key : keys) {
                    logger.debug(key.toString() + "=" + props.get(key));
                }
                logger.debug("----------------");
            }
            return envCtx;
        }
        catch (Exception e) {
            logger.error("getContext() failed with: " + e.getMessage());
            throw new MessagingException(e.getMessage(), e);
        }
    }

    class JMSDestination {
        Destination destination = null;
        Session session = null;
        MessageProducer producer = null;
        MessageConsumer consumer = null;

        public JMSDestination(Destination destination, Session session, MessageProducer producer, MessageConsumer consumer) {
            this.destination = destination;
            this.session = session;
            this.producer = producer;
            this.consumer = consumer;
        }
    }

    public static enum DestinationType {
        Topic,
        Queue;

    }
}

