/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.MessagingException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.messaging.AtomAPIMMessage;
import org.fcrepo.server.messaging.FedoraMessage;
import org.fcrepo.server.messaging.FedoraMethod;
import org.fcrepo.server.messaging.JMSManager;
import org.fcrepo.server.messaging.Messaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingImpl
implements Messaging {
    private static final Logger logger = LoggerFactory.getLogger(MessagingImpl.class);
    private final Map<String, List<String>> mdMap;
    private final JMSManager jmsMgr;
    private final String fedoraBaseUrl;
    private static final String messageFormat = Constants.ATOM_APIM1_0.uri;

    public MessagingImpl(String fedoraBaseUrl, Map<String, List<String>> mdMap, Properties jndiProps) throws MessagingException {
        this(fedoraBaseUrl, mdMap, new JMSManager(jndiProps));
    }

    public MessagingImpl(String fedoraBaseUrl, Map<String, List<String>> mdMap, JMSManager jmsMgr) {
        this.fedoraBaseUrl = fedoraBaseUrl;
        this.mdMap = mdMap;
        this.jmsMgr = jmsMgr;
    }

    @Override
    public void send(String destName, FedoraMessage message) throws MessagingException {
        this.jmsMgr.send(destName, message.toString());
    }

    public void send(String destName, FedoraMethod method, FedoraMessage message) throws MessagingException {
        TextMessage jmsMessage = this.jmsMgr.createTextMessage(destName, message.toString());
        try {
            jmsMessage.setStringProperty("methodName", method.getName());
            if (method.getPID() != null) {
                jmsMessage.setStringProperty("pid", method.getPID().toString());
            }
        }
        catch (JMSException jmse) {
            throw new MessagingException("Unable to set message properties.", jmse);
        }
        this.jmsMgr.send(destName, (Message)jmsMessage);
    }

    @Override
    public void send(FedoraMethod method) throws MessagingException {
        if (Management.class == method.getMethod().getDeclaringClass()) {
            AtomAPIMMessage message = new AtomAPIMMessage(method, this.fedoraBaseUrl, Server.VERSION, messageFormat);
            String methodName = method.getName();
            if (methodName.startsWith("ingest") || methodName.startsWith("add") || methodName.startsWith("modify") || methodName.startsWith("purge") || methodName.startsWith("set")) {
                for (String destName : this.mdMap.get(Messaging.MessageType.apimUpdate.toString())) {
                    this.send(destName, method, message);
                }
            } else {
                for (String destName : this.mdMap.get(Messaging.MessageType.apimAccess.toString())) {
                    this.send(destName, method, message);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Silently dropping non-Management method: " + method.getName());
        }
    }

    @Override
    public void close() throws MessagingException {
        if (this.jmsMgr != null) {
            this.jmsMgr.close();
        }
    }
}

