/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fcrepo.common.Constants;
import org.fcrepo.server.DatastoreConfig;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.MessagingException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.messaging.FedoraMessage;
import org.fcrepo.server.messaging.FedoraMethod;
import org.fcrepo.server.messaging.JMSManager;
import org.fcrepo.server.messaging.Messaging;
import org.fcrepo.server.messaging.MessagingImpl;
import org.fcrepo.server.utilities.ServerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingModule
extends Module
implements Messaging {
    private static final Logger logger = LoggerFactory.getLogger(MessagingModule.class);
    private Messaging msg;
    private JMSManager jmsMgr;
    private static final String ACTIVEMQ_PREFIX = "org.apache.activemq.default.directory.prefix";

    public MessagingModule(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        if (!this.enabled()) {
            logger.info("Messaging Module is disabled.");
            return;
        }
        if (System.getProperty(ACTIVEMQ_PREFIX) == null) {
            System.setProperty(ACTIVEMQ_PREFIX, new File(Constants.FEDORA_HOME, "data").getPath() + File.separator);
        }
        Properties jndiProps = this.getJNDISettings();
        try {
            this.jmsMgr = new JMSManager(jndiProps);
        }
        catch (Exception e) {
            throw new ModuleInitializationException(e.getMessage(), this.getRole());
        }
        try {
            String fedoraBaseUrl = ServerUtility.getBaseURL("http");
            this.msg = new MessagingImpl(fedoraBaseUrl, this.createDestinations(), this.jmsMgr);
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Error connecting to JMS ", this.getRole(), e);
        }
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
    }

    @Override
    public void shutdownModule() throws ModuleShutdownException {
        if (this.enabled()) {
            try {
                this.close();
            }
            catch (MessagingException e) {
                throw new ModuleShutdownException(e.getMessage(), this.getRole(), e);
            }
        }
    }

    @Override
    public void send(String destName, FedoraMessage message) throws MessagingException {
        this.msg.send(destName, message);
    }

    @Override
    public void send(FedoraMethod method) throws MessagingException {
        this.msg.send(method);
    }

    private Properties getJNDISettings() {
        String contextFactory = this.getParameter("java.naming.factory.initial");
        String providerURL = this.getParameter("java.naming.provider.url");
        String connectionFactory = this.getParameter("connection.factory.name");
        if (providerURL == null || providerURL.length() == 0) {
            providerURL = "vm:(broker:(tcp://localhost:61616))";
            if (logger.isDebugEnabled()) {
                logger.debug("Using default provider url: " + providerURL);
            }
        }
        if (connectionFactory == null || connectionFactory.length() == 0) {
            connectionFactory = "ConnectionFactory";
            if (logger.isDebugEnabled()) {
                logger.debug("Using default connection factory name: " + connectionFactory);
            }
        }
        if (contextFactory == null || contextFactory.length() == 0) {
            contextFactory = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
            if (logger.isDebugEnabled()) {
                logger.debug("Using default initial context factory: " + contextFactory);
            }
        } else if (contextFactory.equalsIgnoreCase("container")) {
            return null;
        }
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", contextFactory);
        props.setProperty("java.naming.provider.url", providerURL);
        props.setProperty("connection.factory.name", connectionFactory);
        return props;
    }

    private Map<String, List<String>> createDestinations() throws ModuleInitializationException {
        HashMap<String, List<String>> mdMap = new HashMap<String, List<String>>();
        for (Messaging.MessageType type : Messaging.MessageType.values()) {
            mdMap.put(type.toString(), new ArrayList());
        }
        Iterator<String> parameters = this.parameterNames();
        while (parameters.hasNext()) {
            String[] msgTypes;
            String param = parameters.next();
            if (!param.startsWith("datastore")) continue;
            DatastoreConfig dsConfig = this.getDatastore(param);
            for (String msgType : msgTypes = dsConfig.getParameter("messageTypes").split(" ")) {
                if (mdMap.containsKey(msgType)) continue;
                throw new ModuleInitializationException(msgType + " is not a supported MessageType.", this.getRole());
            }
            String destName = dsConfig.getParameter("name");
            String type = dsConfig.getParameter("type");
            boolean transacted = Boolean.parseBoolean(dsConfig.getParameter("transacted"));
            String ackMode = dsConfig.getParameter("ackMode");
            JMSManager.DestinationType destType = JMSManager.DestinationType.Topic;
            if (type.equalsIgnoreCase("queue")) {
                destType = JMSManager.DestinationType.Queue;
            }
            int destAckMode = 1;
            if (ackMode != null && ackMode.length() > 0) {
                try {
                    destAckMode = Integer.parseInt(ackMode);
                }
                catch (NumberFormatException e) {
                    throw new ModuleInitializationException("ackMode must be a number", this.getRole());
                }
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("createDestination(%s, %s, %s, %s)", new Object[]{destName, destType, transacted, destAckMode}));
                }
                this.jmsMgr.createDestination(destName, destType, transacted, destAckMode);
            }
            catch (Exception e) {
                throw new ModuleInitializationException(e.getMessage(), this.getRole());
            }
            for (String msgType : msgTypes) {
                ((List)mdMap.get(msgType)).add(destName);
            }
        }
        return mdMap;
    }

    private DatastoreConfig getDatastore(String name) throws ModuleInitializationException {
        String value = this.getParameter(name);
        if (value == null || value.length() == 0) {
            throw new ModuleInitializationException(name + " parameter " + "is required", this.getRole());
        }
        DatastoreConfig dsConfig = this.getServer().getDatastoreConfig(value);
        if (dsConfig == null) {
            throw new ModuleInitializationException(value + " datastore " + "configuration is missing.", this.getRole());
        }
        return dsConfig;
    }

    private boolean enabled() {
        String enabled = this.getParameter("enabled");
        return enabled != null && enabled.equalsIgnoreCase("true");
    }

    @Override
    public void close() throws MessagingException {
        if (this.msg != null) {
            this.msg.close();
            this.msg = null;
        }
    }
}

