/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.oai;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.oai.BadResumptionTokenException;
import org.fcrepo.oai.CannotDisseminateFormatException;
import org.fcrepo.oai.DateGranularitySupport;
import org.fcrepo.oai.DeletedRecordSupport;
import org.fcrepo.oai.Header;
import org.fcrepo.oai.IDDoesNotExistException;
import org.fcrepo.oai.NoMetadataFormatsException;
import org.fcrepo.oai.NoRecordsMatchException;
import org.fcrepo.oai.NoSetHierarchyException;
import org.fcrepo.oai.OAIProvider;
import org.fcrepo.oai.Record;
import org.fcrepo.oai.RepositoryException;
import org.fcrepo.oai.SimpleHeader;
import org.fcrepo.oai.SimpleMetadataFormat;
import org.fcrepo.oai.SimpleRecord;
import org.fcrepo.oai.SimpleResumptionToken;
import org.fcrepo.oai.SimpleSetInfo;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.UnknownSessionTokenException;
import org.fcrepo.server.search.Condition;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.ObjectFields;
import org.fcrepo.server.utilities.DCFields;

public class FedoraOAIProvider
implements Constants,
OAIProvider {
    private final String m_repositoryName;
    private final String m_repositoryDomainName;
    private final String m_localname;
    private final String m_relpath;
    private final Set m_adminEmails;
    private final Set<String> m_descriptions;
    private final List<SimpleSetInfo> m_setInfos;
    private final long m_maxSets;
    private final long m_maxRecords;
    private final long m_maxHeaders;
    private final FieldSearch m_fieldSearch;
    private final Set<SimpleMetadataFormat> m_formats;
    private static Set s_emptySet = new HashSet();
    private static String[] s_headerFields = new String[]{"pid", "dcmDate"};
    private static String[] s_headerAndDCFields = new String[]{"pid", "dcmDate", "title", "creator", "subject", "description", "publisher", "contributor", "date", "type", "format", "identifier", "source", "language", "relation", "coverage", "rights"};

    public FedoraOAIProvider(String repositoryName, String repositoryDomainName, String localname, String relpath, Set adminEmails, Set friendBaseURLs, String namespaceID, long maxSets, long maxRecords, long maxHeaders, FieldSearch fieldSearch) {
        this.m_repositoryName = repositoryName;
        this.m_repositoryDomainName = repositoryDomainName;
        this.m_localname = localname;
        this.m_relpath = relpath;
        this.m_adminEmails = adminEmails;
        this.m_maxSets = maxSets;
        this.m_maxRecords = maxRecords;
        this.m_maxHeaders = maxHeaders;
        this.m_fieldSearch = fieldSearch;
        this.m_descriptions = new HashSet<String>();
        StringBuffer buf = new StringBuffer();
        buf.append("      <oai-identifier xmlns=\"" + FedoraOAIProvider.OAI_IDENTIFIER.uri + "\"\n");
        buf.append("          xmlns:xsi=\"" + FedoraOAIProvider.XSI.uri + "\"\n");
        buf.append("          xsi:schemaLocation=\"" + FedoraOAIProvider.OAI_IDENTIFIER.uri + "\n");
        buf.append("          " + FedoraOAIProvider.OAI_IDENTIFIER2_0.xsdLocation + "\">\n");
        buf.append("        <scheme>oai</scheme>\n");
        buf.append("        <repositoryIdentifier>" + this.m_repositoryDomainName + "</repositoryIdentifier>\n");
        buf.append("        <delimiter>:</delimiter>\n");
        buf.append("        <sampleIdentifier>oai:" + this.m_repositoryDomainName + ":" + namespaceID + ":7654</sampleIdentifier>\n");
        buf.append("      </oai-identifier>");
        this.m_descriptions.add(buf.toString());
        if (friendBaseURLs != null && friendBaseURLs.size() > 0) {
            buf = new StringBuffer();
            buf.append("      <friends xmlns=\"" + FedoraOAIProvider.OAI_FRIENDS.uri + "\"\n");
            buf.append("          xmlns:xsi=\"" + FedoraOAIProvider.XSI.uri + "\"\n");
            buf.append("          xsi:schemaLocation=\"" + FedoraOAIProvider.OAI_FRIENDS.uri + "\n");
            buf.append("          " + FedoraOAIProvider.OAI_FRIENDS2_0.xsdLocation + "\">\n");
            Iterator iter = friendBaseURLs.iterator();
            while (iter.hasNext()) {
                buf.append("        <baseURL>" + (String)iter.next() + "</baseURL>\n");
            }
            buf.append("      </friends>");
            this.m_descriptions.add(buf.toString());
        }
        this.m_formats = new HashSet<SimpleMetadataFormat>();
        this.m_formats.add(new SimpleMetadataFormat("oai_dc", FedoraOAIProvider.OAI_DC2_0.xsdLocation, FedoraOAIProvider.OAI_DC.uri));
        this.m_setInfos = new ArrayList<SimpleSetInfo>();
    }

    @Override
    public String getRepositoryName() {
        return this.m_repositoryName;
    }

    @Override
    public String getBaseURL(String protocol, String port) {
        return protocol + "://" + this.m_localname + ":" + port + this.m_relpath;
    }

    @Override
    public String getProtocolVersion() {
        return "2.0";
    }

    @Override
    public Date getEarliestDatestamp() {
        return new Date();
    }

    @Override
    public DeletedRecordSupport getDeletedRecordSupport() {
        return DeletedRecordSupport.NO;
    }

    @Override
    public DateGranularitySupport getDateGranularitySupport() {
        return DateGranularitySupport.SECONDS;
    }

    @Override
    public Set getAdminEmails() {
        return this.m_adminEmails;
    }

    @Override
    public Set getSupportedCompressionEncodings() {
        return s_emptySet;
    }

    @Override
    public Set getDescriptions() {
        return this.m_descriptions;
    }

    @Override
    public Record getRecord(String identifier, String metadataPrefix) throws CannotDisseminateFormatException, IDDoesNotExistException, RepositoryException {
        if (!metadataPrefix.equals("oai_dc")) {
            throw new CannotDisseminateFormatException("Repository does not provide that format in OAI-PMH responses.");
        }
        String pid = this.getPID(identifier);
        List<ObjectFields> l = null;
        try {
            l = this.m_fieldSearch.findObjects(s_headerAndDCFields, 100, new FieldSearchQuery(Condition.getConditions("pid='" + pid + "' dcmDate>'2000-01-01'"))).objectFieldsList();
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() > 0) {
            ObjectFields f = l.get(0);
            return new SimpleRecord(this.getHeader(f), this.getDCXML(f), s_emptySet);
        }
        try {
            l = this.m_fieldSearch.findObjects(new String[]{"pid"}, 1, new FieldSearchQuery(Condition.getConditions("pid='" + pid + "'"))).objectFieldsList();
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() == 0) {
            throw new IDDoesNotExistException("The provided id does not match any item in the repository.");
        }
        throw new CannotDisseminateFormatException("The item doesn't even have dc_oai metadata.");
    }

    @Override
    public List getRecords(Date from, Date until, String metadataPrefix, String set) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, RepositoryException {
        FieldSearchResult fsr;
        if (!metadataPrefix.equals("oai_dc")) {
            throw new CannotDisseminateFormatException("Repository does not provide that format in OAI-PMH responses.");
        }
        List<ObjectFields> l = null;
        try {
            fsr = this.m_fieldSearch.findObjects(s_headerAndDCFields, (int)this.getMaxRecords(), new FieldSearchQuery(Condition.getConditions("dcmDate>'2000-01-01'" + this.getDatePart(from, until))));
            l = fsr.objectFieldsList();
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() == 0) {
            throw new NoRecordsMatchException("No records match the given criteria.");
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < l.size(); ++i) {
            ObjectFields f = l.get(i);
            ret.add(new SimpleRecord(this.getHeader(f), this.getDCXML(f), s_emptySet));
        }
        if (fsr.getToken() != null) {
            ret.add(new SimpleResumptionToken(fsr.getToken(), fsr.getExpirationDate(), fsr.getCompleteListSize(), fsr.getCursor()));
        }
        return ret;
    }

    private Header getHeader(ObjectFields f) {
        String identifier = "oai:" + this.m_repositoryDomainName + ":" + f.getPid();
        Date datestamp = f.getDCMDate();
        HashSet setSpecs = new HashSet();
        return new SimpleHeader(identifier, datestamp, setSpecs, true);
    }

    private String getDCXML(DCFields dc) {
        return dc.getAsXML();
    }

    @Override
    public List getRecords(String resumptionToken) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, BadResumptionTokenException, RepositoryException {
        FieldSearchResult fsr;
        List<ObjectFields> l = null;
        try {
            fsr = this.m_fieldSearch.resumeFindObjects(resumptionToken);
            l = fsr.objectFieldsList();
        }
        catch (UnknownSessionTokenException uste) {
            throw new BadResumptionTokenException("Not a known resumptionToken.");
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() == 0) {
            throw new NoRecordsMatchException("No records match the given criteria.");
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < l.size(); ++i) {
            ObjectFields f = l.get(i);
            ret.add(new SimpleRecord(this.getHeader(f), this.getDCXML(f), s_emptySet));
        }
        if (fsr.getToken() != null) {
            ret.add(new SimpleResumptionToken(fsr.getToken(), fsr.getExpirationDate(), fsr.getCompleteListSize(), fsr.getCursor()));
        }
        return ret;
    }

    private String getDatePart(Date from, Date until) {
        if (from == null && until == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        if (from != null) {
            out.append(" dcmDate>='");
            out.append(formatter.format(from));
            out.append("'");
        }
        if (until != null) {
            out.append(" dcmDate<='");
            out.append(formatter.format(until));
            out.append("'");
        }
        return out.toString();
    }

    @Override
    public List getHeaders(Date from, Date until, String metadataPrefix, String set) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, RepositoryException {
        FieldSearchResult fsr;
        if (!metadataPrefix.equals("oai_dc")) {
            throw new CannotDisseminateFormatException("Repository does not provide that format in OAI-PMH responses.");
        }
        List<ObjectFields> l = null;
        try {
            fsr = this.m_fieldSearch.findObjects(s_headerFields, (int)this.getMaxHeaders(), new FieldSearchQuery(Condition.getConditions("dcmDate>'2000-01-01'" + this.getDatePart(from, until))));
            l = fsr.objectFieldsList();
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() == 0) {
            throw new NoRecordsMatchException("No records match the given criteria.");
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < l.size(); ++i) {
            ObjectFields f = l.get(i);
            String identifier = "oai:" + this.m_repositoryDomainName + ":" + f.getPid();
            Date datestamp = f.getDCMDate();
            HashSet setSpecs = new HashSet();
            ret.add(new SimpleHeader(identifier, datestamp, setSpecs, true));
        }
        if (fsr.getToken() != null) {
            ret.add(new SimpleResumptionToken(fsr.getToken(), fsr.getExpirationDate(), fsr.getCompleteListSize(), fsr.getCursor()));
        }
        return ret;
    }

    @Override
    public List getHeaders(String resumptionToken) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, BadResumptionTokenException, RepositoryException {
        FieldSearchResult fsr;
        List<ObjectFields> l = null;
        try {
            fsr = this.m_fieldSearch.resumeFindObjects(resumptionToken);
            l = fsr.objectFieldsList();
        }
        catch (UnknownSessionTokenException uste) {
            throw new BadResumptionTokenException("Not a known resumptionToken.");
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() == 0) {
            throw new NoRecordsMatchException("No records match the given criteria.");
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < l.size(); ++i) {
            ObjectFields f = l.get(i);
            String identifier = "oai:" + this.m_repositoryDomainName + ":" + f.getPid();
            Date datestamp = f.getDCMDate();
            HashSet setSpecs = new HashSet();
            ret.add(new SimpleHeader(identifier, datestamp, setSpecs, true));
        }
        if (fsr.getToken() != null) {
            ret.add(new SimpleResumptionToken(fsr.getToken(), fsr.getExpirationDate(), fsr.getCompleteListSize(), fsr.getCursor()));
        }
        return ret;
    }

    @Override
    public List getSets() throws NoSetHierarchyException, RepositoryException {
        return this.m_setInfos;
    }

    @Override
    public List getSets(String resumptionToken) throws BadResumptionTokenException, NoSetHierarchyException, RepositoryException {
        throw new BadResumptionTokenException("Not a known resumptionToken.");
    }

    private String getPID(String id) throws IDDoesNotExistException {
        if (!id.startsWith("oai:" + this.m_repositoryDomainName + ":")) {
            throw new IDDoesNotExistException("For this repository, all identifiers in OAI requests should begin with oai:" + this.m_repositoryDomainName + ":");
        }
        if (id.indexOf("'") != -1) {
            throw new IDDoesNotExistException("For this repository, no identifiers contain the apostrophe character.");
        }
        return id.substring(4 + this.m_repositoryDomainName.length() + 1);
    }

    @Override
    public Set getMetadataFormats(String id) throws NoMetadataFormatsException, IDDoesNotExistException, RepositoryException {
        if (id == null) {
            return this.m_formats;
        }
        String pid = this.getPID(id);
        List<ObjectFields> l = null;
        try {
            l = this.m_fieldSearch.findObjects(new String[]{"pid"}, 1, new FieldSearchQuery(Condition.getConditions("pid='" + pid + "' dcmDate>'2000-01-01'"))).objectFieldsList();
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() > 0) {
            return this.m_formats;
        }
        try {
            l = this.m_fieldSearch.findObjects(new String[]{"pid"}, 1, new FieldSearchQuery(Condition.getConditions("pid='" + pid + "'"))).objectFieldsList();
        }
        catch (ServerException se) {
            throw new RepositoryException(se.getClass().getName() + ": " + se.getMessage());
        }
        if (l.size() > 0) {
            throw new NoMetadataFormatsException("The item doesn't even have dc_oai metadata.");
        }
        throw new IDDoesNotExistException("The provided id does not match any item in the repository.");
    }

    @Override
    public long getMaxSets() throws RepositoryException {
        return this.m_maxSets;
    }

    @Override
    public long getMaxRecords() throws RepositoryException {
        return this.m_maxRecords;
    }

    @Override
    public long getMaxHeaders() throws RepositoryException {
        return this.m_maxHeaders;
    }
}

