/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.oai;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.fcrepo.oai.OAIProvider;
import org.fcrepo.oai.OAIProviderServlet;
import org.fcrepo.oai.OAIResponder;
import org.fcrepo.oai.RepositoryException;
import org.fcrepo.server.Server;
import org.fcrepo.server.security.Authorization;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FedoraOAIProviderServlet
extends OAIProviderServlet {
    private static final long serialVersionUID = 1L;
    Server m_server;
    OAIResponder m_responder;

    @Override
    public OAIResponder getResponder() throws RepositoryException {
        if (this.m_responder == null) {
            try {
                OAIProvider provider = this.m_server.getBean("org.fcrepo.oai.OAIProvider", OAIProvider.class);
                Authorization authz = this.m_server.getBean("org.fcrepo.server.security.Authorization", Authorization.class);
                this.m_responder = new OAIResponder(provider, authz);
            }
            catch (Exception e) {
                throw new RepositoryException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        return this.m_responder;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            WebApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext());
            this.m_server = (Server)appContext.getBean("org.fcrepo.server.Server");
            if (this.m_server == null) {
                this.failStartup("Could not retrieve org.fcrepo.server.Server bean", null);
            }
        }
        catch (Throwable th) {
            String msg = "Fedora startup failed";
            this.failStartup(msg, th);
        }
    }

    private void failStartup(String message, Throwable th) throws ServletException {
        System.err.println("\n**************************");
        System.err.println("** FEDORA STARTUP ERROR **");
        System.err.println("**************************\n");
        System.err.println(message);
        if (th == null) {
            System.err.println();
            throw new ServletException(message);
        }
        th.printStackTrace();
        System.err.println();
        throw new ServletException(message, th);
    }

    public static void main(String[] args) throws Exception {
        new FedoraOAIProviderServlet().test(args);
    }
}

