/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.observer;

import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.fcrepo.server.observer.Publisher;
import org.fcrepo.server.observer.Subscriber;

public class ObserverQueue
implements Publisher,
Subscriber,
Runnable {
    private final Set<Subscriber> subscribers = new CopyOnWriteArraySet<Subscriber>();
    private BlockingQueue<Object> messages = new LinkedBlockingQueue<Object>();

    @Override
    public void update(Publisher o, Object arg) {
        this.messages.add(arg);
    }

    @Override
    public void run() {
        while (true) {
            try {
                Object obj = this.messages.take();
                this.notifySubscribers(obj);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    public void addSubscriber(Subscriber obs) {
        this.subscribers.add(obs);
    }

    @Override
    public void notifySubscribers() {
        this.notifySubscribers(null);
    }

    @Override
    public void notifySubscribers(Object o) {
        for (Subscriber subscriber : this.subscribers) {
            subscriber.update(this, o);
        }
    }

    @Override
    public void removeSubscriber(Subscriber obs) {
        this.subscribers.remove(obs);
    }
}

