/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Models;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.resourceIndex.ContentModelTripleGenerator_3_0;
import org.fcrepo.server.resourceIndex.FedoraObjectTripleGenerator_3_0;
import org.fcrepo.server.resourceIndex.ServiceDefinitionTripleGenerator_3_0;
import org.fcrepo.server.resourceIndex.ServiceDeploymentTripleGenerator;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.storage.DOReader;
import org.jrdf.graph.Triple;

public class ModelBasedTripleGenerator
implements TripleGenerator {
    private static final Map<String, Class<? extends TripleGenerator>> m_generatorClasses = new HashMap<String, Class<? extends TripleGenerator>>();
    private final Map<String, TripleGenerator> m_generators = new HashMap<String, TripleGenerator>();

    public ModelBasedTripleGenerator() {
        for (String modelID : m_generatorClasses.keySet()) {
            Class<? extends TripleGenerator> genClass = m_generatorClasses.get(modelID);
            try {
                TripleGenerator generator = genClass.newInstance();
                this.m_generators.put(modelID, generator);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate triple generator " + genClass.getName() + " for model " + modelID, e);
            }
        }
    }

    public void setTripleGenerators(Map<String, ? extends TripleGenerator> generators) {
        this.m_generators.putAll(generators);
    }

    @Override
    public Set<Triple> getTriplesForObject(DOReader reader) throws ResourceIndexException {
        HashSet<Triple> objectTriples = new HashSet<Triple>();
        try {
            for (String modelRelobject : reader.getContentModels()) {
                if (!this.m_generators.containsKey(modelRelobject)) continue;
                objectTriples.addAll(this.m_generators.get(modelRelobject).getTriplesForObject(reader));
            }
        }
        catch (ServerException e) {
            throw new ResourceIndexException("Could not read object's content model", e);
        }
        return objectTriples;
    }

    static {
        m_generatorClasses.put(Models.FEDORA_OBJECT_3_0.uri, FedoraObjectTripleGenerator_3_0.class);
        m_generatorClasses.put(Models.SERVICE_DEFINITION_3_0.uri, ServiceDefinitionTripleGenerator_3_0.class);
        m_generatorClasses.put(Models.SERVICE_DEPLOYMENT_3_0.uri, ServiceDeploymentTripleGenerator.class);
        m_generatorClasses.put(Models.CONTENT_MODEL_3_0.uri, ContentModelTripleGenerator_3_0.class);
    }
}

