/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Module;
import org.fcrepo.server.Parameterized;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.resourceIndex.ResourceIndexImpl;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.utilities.status.ServerState;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.FlushErrorHandler;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TripleUpdate;
import org.trippi.TriplestoreConnector;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class ResourceIndexModule
extends Module
implements ResourceIndex {
    private static final Logger logger = LoggerFactory.getLogger(ResourceIndexModule.class);
    private ResourceIndex _ri;

    public ResourceIndexModule(Map<String, String> parameters, Server server, String role) throws ModuleInitializationException {
        super(parameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        int level = this.getRequiredInt("level", 0, 1);
        if (level == 0) {
            logger.info("Disabled in configuration ( level={} ), exiting", (Object)level);
            return;
        }
        boolean syncUpdates = this.getBoolean("syncUpdates", false);
        try {
            TriplestoreConnector connector = null;
            String ds = this.getParameter("datastore");
            if (ds != null) {
                logger.info("Configuring triplestore connector from fcfg datastore configuration {}", (Object)ds);
                connector = this.getConnector(this.getServer().getDatastoreConfig(ds));
            } else {
                logger.info("Configuring triplestore from bean " + TriplestoreConnector.class.getName());
                connector = this.getServer().getBean(TriplestoreConnector.class.getName(), TriplestoreConnector.class);
            }
            TripleGenerator generator = this.getServer().getBean(TripleGenerator.class.getName(), TripleGenerator.class);
            this._ri = new ResourceIndexImpl(connector, generator, level, syncUpdates);
            this.setAliasMap(this.getAliases());
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Error initializing RI", this.getRole(), e);
        }
    }

    private TriplestoreConnector getConnector(Parameterized datastore) throws Exception {
        String className;
        if (datastore == null) {
            throw new ModuleInitializationException("Specifed datastore does not exist in fedora.fcfg", this.getRole());
        }
        Map<String, String> config = datastore.getParameters();
        String path = config.get("path");
        if (path != null) {
            config.put("path", datastore.getParameter("path", true));
        }
        if ((className = config.get("connectorClassName")) == null) {
            throw new ResourceIndexException("Required datastore parameter is missing: connectorClassName");
        }
        this.getServer().getStatusFile().append(ServerState.STARTING, "Initializing Triplestore");
        return TriplestoreConnector.init((String)className, config);
    }

    private Map<String, String> getAliases() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iter = this.parameterNames();
        while (iter.hasNext()) {
            String pName = iter.next();
            String[] parts = pName.split(":");
            if (parts.length != 2 || !parts[0].equals("alias")) continue;
            map.put(parts[1], this.getParameter(pName));
        }
        map.put("fedora", Constants.FEDORA.uri);
        map.put("dc", Constants.DC.uri);
        map.put("fedora-model", Constants.MODEL.uri);
        map.put("fedora-rels-ext", Constants.RELS_EXT.uri);
        map.put("fedora-view", Constants.VIEW.uri);
        map.put("rdf", Constants.RDF.uri);
        map.put("mulgara", Constants.MULGARA.uri);
        map.put("xml-schema", Constants.RDF_XSD.uri);
        return map;
    }

    private int getRequiredInt(String name, int min, int max) throws ModuleInitializationException {
        try {
            int value = Integer.parseInt(this.getRequired(name));
            if (value < min || value > max) {
                throw new ModuleInitializationException(name + " parameter is out of range, expected [" + min + "-" + max + "]", this.getRole());
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new ModuleInitializationException(name + " parameter must be " + "an integer", this.getRole());
        }
    }

    private boolean getBoolean(String name, boolean defaultValue) throws ModuleInitializationException {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.toLowerCase()).equals("true") || value.equals("yes") || value.equals("on")) {
            return true;
        }
        if (value.equals("false") || value.equals("no") || value.equals("off")) {
            return false;
        }
        throw new ModuleInitializationException(name + " parameter, if " + "specified, must be a boolean (true or false)", this.getRole());
    }

    private String getRequired(String name) throws ModuleInitializationException {
        String value = this.getParameter(name);
        if (value != null) {
            return value;
        }
        throw new ModuleInitializationException(name + " parameter " + "is required", this.getRole());
    }

    @Override
    public void shutdownModule() throws ModuleShutdownException {
        if (this._ri != null) {
            try {
                this._ri.close();
            }
            catch (TrippiException e) {
                throw new ModuleShutdownException("Error closing RI", this.getRole(), e);
            }
        }
    }

    @Override
    public int getIndexLevel() {
        if (this._ri == null) {
            return 0;
        }
        return this._ri.getIndexLevel();
    }

    @Override
    public void addObject(DOReader reader) throws ResourceIndexException {
        this._ri.addObject(reader);
    }

    @Override
    public void modifyObject(DOReader oldReader, DOReader newReader) throws ResourceIndexException {
        this._ri.modifyObject(oldReader, newReader);
    }

    @Override
    public void deleteObject(DOReader oldReader) throws ResourceIndexException {
        this._ri.deleteObject(oldReader);
    }

    @Override
    public void export(OutputStream out, RDFFormat format) throws ResourceIndexException {
        this._ri.export(out, format);
    }

    public void setAliasMap(Map<String, String> aliasToPrefix) throws TrippiException {
        this._ri.setAliasMap(aliasToPrefix);
    }

    public Map<String, String> getAliasMap() throws TrippiException {
        return this._ri.getAliasMap();
    }

    public TupleIterator findTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this._ri.findTuples(queryLang, tupleQuery, limit, distinct);
    }

    public int countTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this._ri.countTuples(queryLang, tupleQuery, limit, distinct);
    }

    public TripleIterator findTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this._ri.findTriples(queryLang, tripleQuery, limit, distinct);
    }

    public int countTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this._ri.countTriples(queryLang, tripleQuery, limit, distinct);
    }

    public TripleIterator findTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this._ri.findTriples(subject, predicate, object, limit);
    }

    public int countTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this._ri.countTriples(subject, predicate, object, limit);
    }

    public TripleIterator findTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this._ri.findTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct);
    }

    public int countTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this._ri.countTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct);
    }

    public String[] listTupleLanguages() {
        return this._ri.listTupleLanguages();
    }

    public String[] listTripleLanguages() {
        return this._ri.listTripleLanguages();
    }

    public void close() throws TrippiException {
    }

    public void add(List<Triple> triples, boolean flush) throws IOException, TrippiException {
        this._ri.add(triples, flush);
    }

    public void add(TripleIterator triples, boolean flush) throws IOException, TrippiException {
        this._ri.add(triples, flush);
    }

    public void add(Triple triple, boolean flush) throws IOException, TrippiException {
        this._ri.add(triple, flush);
    }

    public void delete(List<Triple> triples, boolean flush) throws IOException, TrippiException {
        this._ri.delete(triples, flush);
    }

    public void delete(TripleIterator triples, boolean flush) throws IOException, TrippiException {
        this._ri.delete(triples, flush);
    }

    public void delete(Triple triple, boolean flush) throws IOException, TrippiException {
        this._ri.delete(triple, flush);
    }

    public void flushBuffer() throws IOException, TrippiException {
        this._ri.flushBuffer();
    }

    public void setFlushErrorHandler(FlushErrorHandler h) {
        this._ri.setFlushErrorHandler(h);
    }

    public int getBufferSize() {
        return this._ri.getBufferSize();
    }

    public List<TripleUpdate> findBufferedUpdates(SubjectNode subject, PredicateNode predicate, ObjectNode object, int updateType) {
        return this._ri.findBufferedUpdates(subject, predicate, object, updateType);
    }
}

