/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.FaultException;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.resourceIndex.TripleGeneratorBase;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.service.ServiceMapper;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.MethodDef;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.xml.sax.InputSource;

public class ServiceDefinitionTripleGenerator_3_0
extends TripleGeneratorBase
implements TripleGenerator {
    private static final String METHODMAP_DS = "METHODMAP";

    @Override
    public Set<Triple> getTriplesForObject(DOReader reader) throws ResourceIndexException {
        HashSet<Triple> set = new HashSet<Triple>();
        try {
            SimpleURIReference objURI = new SimpleURIReference(new URI(PID.toURI((String)reader.GetObjectPID())));
            this.addMethodDefTriples((URIReference)objURI, reader, set);
        }
        catch (Exception e) {
            throw new ResourceIndexException("Could not generate triples", e);
        }
        return set;
    }

    private void addMethodDefTriples(URIReference objURI, DOReader reader, Set<Triple> set) throws ResourceIndexException {
        try {
            for (MethodDef element : this.getAbstractMethods(reader)) {
                this.add((SubjectNode)objURI, Constants.MODEL.DEFINES_METHOD, element.methodName, set);
            }
        }
        catch (ResourceIndexException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceIndexException("Error adding method def triples", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodDef[] getAbstractMethods(DOReader reader) throws ServerException {
        ServiceMapper mapper = new ServiceMapper(reader.GetObjectPID());
        Datastream methodmap = reader.GetDatastream(METHODMAP_DS, null);
        if (methodmap != null) {
            InputStream contentStream = methodmap.getContentStream();
            try {
                MethodDef[] methodDefArray = mapper.getMethodDefs(new InputSource(contentStream));
                return methodDefArray;
            }
            finally {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    throw new FaultException((Throwable)e);
                }
            }
        }
        return new MethodDef[0];
    }
}

