/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.errors.DatastreamLockedException;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.ObjectLockedException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ObjectValidityException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.rest.DatastreamFilenameHelper;
import org.fcrepo.server.rest.DefaultSerializer;
import org.fcrepo.server.rest.RestException;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRestResource {
    public static final String VALID_PID_PART = "/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRestResource.class);
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String DEFAULT_ENC = "UTF-8";
    public static final String FORM = "multipart/form-data";
    public static final String HTML = "text/html";
    public static final String XML = "text/xml";
    public static final String ZIP = "application/zip";
    public static final MediaType TEXT_HTML = new MediaType("text", "html");
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    protected Server m_server;
    protected Management m_management;
    protected Access m_access;
    protected String m_hostname;
    protected ObjectMapper m_mapper;
    protected DatastreamFilenameHelper m_datastreamFilenameHelper;
    @javax.ws.rs.core.Context
    protected HttpServletRequest m_servletRequest;
    @javax.ws.rs.core.Context
    protected UriInfo m_uriInfo;
    @javax.ws.rs.core.Context
    protected HttpHeaders m_headers;

    public BaseRestResource(Server server) {
        try {
            this.m_server = server;
            this.m_management = (Management)((Object)this.m_server.getModule("org.fcrepo.server.management.Management"));
            this.m_access = (Access)((Object)this.m_server.getModule("org.fcrepo.server.access.Access"));
            this.m_hostname = this.m_server.getParameter("fedoraServerHost");
            this.m_datastreamFilenameHelper = new DatastreamFilenameHelper(this.m_server, this.m_management, this.m_access);
            this.m_mapper = new ObjectMapper();
        }
        catch (Exception ex) {
            throw new RestException("Unable to locate Fedora server instance", ex);
        }
    }

    protected Context getContext() {
        return ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, this.m_servletRequest);
    }

    protected DefaultSerializer getSerializer(Context context) {
        return new DefaultSerializer(this.m_hostname, context);
    }

    protected void transform(String xml, String xslt, Writer out) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        File xslFile = new File(this.m_server.getHomeDir(), xslt);
        TransformerFactory factory = TransformerFactory.newInstance();
        if (factory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
        Templates template = factory.newTemplates(new StreamSource(xslFile));
        Transformer transformer = template.newTransformer();
        String appContext = this.getContext().getEnvironmentValue("FEDORA_CONTEXT_NAME");
        transformer.setParameter("fedora", appContext);
        transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(out));
    }

    protected Response buildResponse(MIMETypedStream result) throws Exception {
        if (result.MIMEType.equalsIgnoreCase("application/fedora-redirect")) {
            URI location = URI.create(IOUtils.toString((InputStream)result.getStream()));
            return Response.temporaryRedirect((URI)location).build();
        }
        Response.ResponseBuilder builder = Response.ok();
        if (result.header != null) {
            for (Property header : result.header) {
                if (header.name == null || header.name.equalsIgnoreCase("transfer-encoding") || header.name.equalsIgnoreCase("content-length") || header.name.equalsIgnoreCase("content-type")) continue;
                builder.header(header.name, (Object)header.value);
            }
        }
        if (result.getSize() != -1L) {
            builder.header("content-length", (Object)result.getSize());
        }
        if (!result.MIMEType.equals("")) {
            builder.type(result.MIMEType);
        }
        builder.entity((Object)result.getStream());
        return builder.build();
    }

    private Response handleException(Exception ex) {
        if (ex instanceof ObjectNotInLowlevelStorageException || ex instanceof DatastreamNotFoundException) {
            LOGGER.warn("Resource not found: " + ex.getMessage() + "; unable to fulfill REST API request", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ex.getMessage()).type("text/plain").build();
        }
        if (ex instanceof AuthzException) {
            LOGGER.warn("Authorization failed; unable to fulfill REST API request", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ex.getMessage()).type("text/plain").build();
        }
        if (ex instanceof IllegalArgumentException) {
            LOGGER.warn("Bad request; unable to fulfill REST API request", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).type("text/plain").build();
        }
        if (ex instanceof ObjectLockedException || ex instanceof DatastreamLockedException) {
            LOGGER.warn("Lock exception; unable to fulfill REST API request", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)ex.getMessage()).type("text/plain").build();
        }
        if (ex instanceof ObjectValidityException) {
            LOGGER.warn("Validation exception; unable to fulfill REST API request", (Throwable)ex);
            if (((ObjectValidityException)ex).getValidation() != null) {
                DefaultSerializer serializer = new DefaultSerializer("n/a", this.getContext());
                String errors = serializer.objectValidationToXml(((ObjectValidityException)ex).getValidation());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).type(XML).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).type("text/plain").build();
        }
        LOGGER.error("Unexpected error fulfilling REST API request", (Throwable)ex);
        throw new WebApplicationException((Throwable)ex);
    }

    protected Response handleException(Exception ex, boolean flash) {
        Response error = this.handleException(ex);
        if (flash) {
            error = Response.ok((Object)error.getEntity()).build();
        }
        return error;
    }
}

