/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.fcrepo.common.http.WebClient;
import org.fcrepo.common.http.WebClientConfiguration;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.rest.BaseRestResource;
import org.fcrepo.server.rest.RestHelper;
import org.fcrepo.server.rest.RestUtil;
import org.fcrepo.server.rest.param.DateTimeParam;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.utilities.DateUtility;
import org.springframework.stereotype.Component;

@Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/datastreams")
@Component
public class DatastreamResource
extends BaseRestResource {
    public DatastreamResource(Server server) {
        super(server);
    }

    @GET
    public Response listDatastreams(@PathParam(value="pid") String pid, @QueryParam(value="asOfDateTime") String dateTime, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash, @QueryParam(value="profiles") @DefaultValue(value="false") boolean profiles, @QueryParam(value="dsState") String dsState, @QueryParam(value="validateChecksum") @DefaultValue(value="false") boolean validateChecksum) {
        try {
            String output;
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dateTime);
            Context context = this.getContext();
            MediaType mime = RestHelper.getContentType(format);
            if (profiles) {
                mime = MediaType.TEXT_XML_TYPE;
                Datastream[] datastreams = this.m_management.getDatastreams(context, pid, asOfDateTime, dsState);
                output = this.getSerializer(context).datastreamProfilesToXML(pid, datastreams, asOfDateTime, validateChecksum);
            } else {
                mime = RestHelper.getContentType(format);
                DatastreamDef[] dsDefs = this.m_access.listDatastreams(context, pid, asOfDateTime);
                output = this.getSerializer(context).dataStreamsToXML(pid, asOfDateTime, dsDefs);
                if (TEXT_HTML.isCompatible(mime)) {
                    CharArrayWriter writer = new CharArrayWriter();
                    this.transform(output, "access/listDatastreams.xslt", writer);
                    output = writer.toString();
                }
            }
            return Response.ok((Object)output, (MediaType)mime).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{dsID}")
    @GET
    public Response getDatastreamProfile(@PathParam(value="pid") String pid, @PathParam(value="dsID") String dsID, @QueryParam(value="asOfDateTime") String dateTime, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="validateChecksum") @DefaultValue(value="false") boolean validateChecksum, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dateTime);
            Context context = this.getContext();
            Datastream dsProfile = this.m_management.getDatastream(context, pid, dsID, asOfDateTime);
            if (dsProfile == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("No datastream could be found. Either there is no datastream for the digital object \"" + pid + "\" with datastream ID of \"" + dsID + "\"  OR  there are no datastreams that match the specified " + "date/time value of \"" + dateTime + "\".")).build();
            }
            String xml = this.getSerializer(context).datastreamProfileToXML(pid, dsID, dsProfile, asOfDateTime, validateChecksum);
            MediaType mime = RestHelper.getContentType(format);
            if (TEXT_HTML.isCompatible(mime)) {
                CharArrayWriter writer = new CharArrayWriter();
                this.transform(xml, "management/viewDatastreamProfile.xslt", writer);
                xml = writer.toString();
            }
            return Response.ok((Object)xml, (MediaType)mime).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{dsID}/history")
    @GET
    public Response getDatastreamHistory(@PathParam(value="pid") String pid, @PathParam(value="dsID") String dsID, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            Datastream[] datastreamHistory = this.m_management.getDatastreamHistory(context, pid, dsID);
            if (datastreamHistory == null || datastreamHistory.length == 0) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("No datastream history could be found. There is no datastream history for the digital object \"" + pid + "\" with datastream ID of \"" + dsID)).build();
            }
            String xml = this.getSerializer(context).datastreamHistoryToXml(pid, dsID, datastreamHistory);
            MediaType mime = RestHelper.getContentType(format);
            if (TEXT_HTML.isCompatible(mime)) {
                CharArrayWriter writer = new CharArrayWriter();
                this.transform(xml, "management/viewDatastreamHistory.xslt", writer);
                xml = writer.toString();
            }
            return Response.ok((Object)xml, (MediaType)mime).build();
        }
        catch (Exception e) {
            return this.handleException(e, flash);
        }
    }

    @Path(value="/{dsID}/content")
    @GET
    public Response getDatastream(@PathParam(value="pid") String pid, @PathParam(value="dsID") String dsID, @QueryParam(value="asOfDateTime") String dateTime, @QueryParam(value="download") String download, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        Context context = this.getContext();
        try {
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dateTime);
            MIMETypedStream stream = this.m_access.getDatastreamDissemination(context, pid, dsID, asOfDateTime);
            if (this.m_datastreamFilenameHelper != null) {
                this.m_datastreamFilenameHelper.addContentDispositionHeader(context, pid, dsID, download, asOfDateTime, stream);
            }
            return this.buildResponse(stream);
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{dsID}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteDatastream(@PathParam(value="pid") String pid, @PathParam(value="dsID") String dsID, @QueryParam(value="startDT") String startDT, @QueryParam(value="endDT") String endDT, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            Date startDate = DateUtility.parseDateOrNull((String)startDT);
            Date endDate = DateUtility.parseDateOrNull((String)endDT);
            Date[] purged = this.m_management.purgeDatastream(context, pid, dsID, startDate, endDate, logMessage);
            ArrayList<String> results = new ArrayList<String>();
            for (Date d : purged) {
                results.add(DateUtility.convertDateToXSDString((Date)d));
            }
            return Response.ok((Object)this.m_mapper.writeValueAsString(results)).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{dsID}")
    @PUT
    public Response modifyDatastream(@PathParam(value="pid") String pid, @PathParam(value="dsID") String dsID, @QueryParam(value="dsLocation") String dsLocation, @QueryParam(value="altIDs") List<String> altIDs, @QueryParam(value="dsLabel") String dsLabel, @QueryParam(value="versionable") Boolean versionable, @QueryParam(value="dsState") String dsState, @QueryParam(value="formatURI") String formatURI, @QueryParam(value="checksumType") String checksumType, @QueryParam(value="checksum") String checksum, @QueryParam(value="mimeType") String mimeType, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="ignoreContent") @DefaultValue(value="false") boolean ignoreContent, @QueryParam(value="lastModifiedDate") DateTimeParam lastModifiedDate, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        return this.addOrUpdateDatastream(false, pid, dsID, this.m_headers.getMediaType(), mimeType, null, dsLocation, altIDs, dsLabel, versionable, dsState, formatURI, checksumType, checksum, logMessage, ignoreContent, lastModifiedDate, flash);
    }

    @Path(value="/{dsID}")
    @POST
    public Response addDatastream(@PathParam(value="pid") String pid, @PathParam(value="dsID") String dsID, @QueryParam(value="controlGroup") @DefaultValue(value="X") String controlGroup, @QueryParam(value="dsLocation") String dsLocation, @QueryParam(value="altIDs") List<String> altIDs, @QueryParam(value="dsLabel") String dsLabel, @QueryParam(value="versionable") @DefaultValue(value="true") Boolean versionable, @QueryParam(value="dsState") @DefaultValue(value="A") String dsState, @QueryParam(value="formatURI") String formatURI, @QueryParam(value="checksumType") String checksumType, @QueryParam(value="checksum") String checksum, @QueryParam(value="mimeType") String mimeType, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        return this.addOrUpdateDatastream(true, pid, dsID, this.m_headers.getMediaType(), mimeType, controlGroup, dsLocation, altIDs, dsLabel, versionable, dsState, formatURI, checksumType, checksum, logMessage, false, null, flash);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Response addOrUpdateDatastream(boolean posted, String pid, String dsID, MediaType mediaType, String mimeType, String controlGroup, String dsLocation, List<String> altIDList, String dsLabel, Boolean versionable, String dsState, String formatURI, String checksumType, String checksum, String logMessage, boolean ignoreContent, DateTimeParam lastModifiedDate, boolean flash) {
        try {
            RestUtil restUtil;
            RestUtil.RequestContent content;
            String[] altIDs = new String[]{};
            if (altIDList != null && altIDList.size() > 0) {
                altIDs = altIDList.toArray(new String[altIDList.size()]);
            }
            Context context = this.getContext();
            Datastream existingDS = this.m_management.getDatastream(context, pid, dsID, null);
            if (!posted && versionable == null && existingDS != null) {
                versionable = existingDS.DSVersionable;
            }
            Date requestModDate = null;
            if (lastModifiedDate != null) {
                requestModDate = (Date)lastModifiedDate.getValue();
            }
            if (existingDS != null && existingDS.DSState.equals("D") && dsState != null && (dsState.equals("A") || dsState.equals("I"))) {
                this.m_management.setDatastreamState(context, pid, dsID, dsState, logMessage);
                existingDS.DSState = dsState;
            }
            InputStream is = null;
            if (!ignoreContent && (content = (restUtil = new RestUtil()).getRequestContent(this.m_servletRequest, this.m_headers)) != null && content.getContentStream() != null) {
                is = content.getContentStream();
                if (mimeType == null && content.getMimeType() != null) {
                    mimeType = content.getMimeType();
                }
            }
            if (mimeType == null && mediaType != null) {
                mimeType = mediaType.toString();
            } else if (mimeType == null && mediaType == null && existingDS != null) {
                mimeType = existingDS.DSMIME;
            }
            if (dsLocation == null && TEXT_XML.isCompatible(MediaType.valueOf((String)mimeType)) && controlGroup == null) {
                controlGroup = "X";
            }
            if (existingDS == null) {
                if (!posted) return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                if ((dsLocation == null || dsLocation.equals("")) && ("X".equals(controlGroup) || "M".equals(controlGroup))) {
                    dsLocation = this.m_management.putTempStream(context, is);
                }
                dsID = this.m_management.addDatastream(context, pid, dsID, altIDs, dsLabel, versionable, mimeType, formatURI, dsLocation, controlGroup, dsState, checksumType, checksum, logMessage);
            } else {
                if ("X".equals(existingDS.DSControlGrp)) {
                    if (is == null && dsLocation != null && !dsLocation.equals("")) {
                        try {
                            WebClientConfiguration webconfig = this.m_server.getWebClientConfig();
                            WebClient webClient = new WebClient(webconfig);
                            is = webClient.get(dsLocation, true);
                        }
                        catch (IOException ioe) {
                            throw new Exception("Could not retrive content from " + dsLocation + " due to error: " + ioe.getMessage());
                        }
                    }
                    this.m_management.modifyDatastreamByValue(context, pid, dsID, altIDs, dsLabel, mimeType, formatURI, is, checksumType, checksum, logMessage, requestModDate);
                } else {
                    if (dsLocation == null && "M".equals(existingDS.DSControlGrp)) {
                        dsLocation = is != null ? this.m_management.putTempStream(context, is) : null;
                    }
                    this.m_management.modifyDatastreamByReference(context, pid, dsID, altIDs, dsLabel, mimeType, formatURI, dsLocation, checksumType, checksum, logMessage, requestModDate);
                }
                if (dsState != null && (dsState.equals("A") || dsState.equals("D") || dsState.equals("I")) && !dsState.equals(existingDS.DSState)) {
                    this.m_management.setDatastreamState(context, pid, dsID, dsState, logMessage);
                }
                if (versionable != existingDS.DSVersionable) {
                    this.m_management.setDatastreamVersionable(context, pid, dsID, versionable, logMessage);
                }
            }
            Response.ResponseBuilder builder = posted ? Response.created((URI)this.m_uriInfo.getRequestUri().resolve(URLEncoder.encode(dsID, "UTF-8"))) : Response.ok();
            builder.header("Content-Type", (Object)"text/xml");
            Datastream dsProfile = this.m_management.getDatastream(context, pid, dsID, null);
            String xml = this.getSerializer(context).datastreamProfileToXML(pid, dsID, dsProfile, null, false);
            builder.entity((Object)xml);
            return builder.build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }
}

