/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.management.DefaultManagement;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.ObjectFields;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultManagement.class);
    String fedoraServerHost;
    String fedoraServerPort;
    String fedoraServerProtocol;
    String fedoraAppServerContext;

    public DefaultSerializer(String fedoraServerHost, Context context) {
        this.fedoraServerHost = fedoraServerHost;
        this.fedoraServerPort = context.getEnvironmentValue(Constants.HTTP_REQUEST.SERVER_PORT.uri);
        this.fedoraAppServerContext = context.getEnvironmentValue("FEDORA_CONTEXT_NAME");
        this.fedoraServerProtocol = Constants.HTTP_REQUEST.SECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri)) ? "https" : "http";
    }

    String pidsToXml(String[] pidList) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<pidList  xmlns=\"" + Constants.PID_LIST1_0.namespace.uri + "\" " + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"" + Constants.PID_LIST1_0.namespace.uri + " " + Constants.PID_LIST1_0.xsdLocation + "\">");
        for (int i = 0; i < pidList.length; ++i) {
            xml.append("  <pid>" + pidList[i] + "</pid>\n");
        }
        xml.append("</pidList>\n");
        return xml.toString();
    }

    public String objectProfileToXML(ObjectProfile objProfile, Date versDateTime) {
        String tmp;
        StringBuilder buffer = new StringBuilder();
        String pid = objProfile.PID;
        String dateString = "";
        if (versDateTime != null && (tmp = DateUtility.convertDateToString((Date)versDateTime)) != null) {
            dateString = String.format("dateTime=\"%s\" ", tmp);
        }
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<objectProfile  xmlns=\"" + Constants.OBJ_PROFILE1_0.namespace.uri + "\" " + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"" + Constants.OBJ_PROFILE1_0.namespace.uri + " " + Constants.OBJ_PROFILE1_0.xsdLocation + "\"" + " pid=\"" + StreamUtility.enc(pid) + "\" " + dateString + ">");
        buffer.append("<objLabel>" + StreamUtility.enc(objProfile.objectLabel) + "</objLabel>");
        buffer.append("<objOwnerId>" + StreamUtility.enc(objProfile.objectOwnerId) + "</objOwnerId>");
        buffer.append("<objModels>");
        for (String model : objProfile.objectModels) {
            buffer.append("<model>");
            buffer.append(StreamUtility.enc(model));
            buffer.append("</model>");
        }
        buffer.append("</objModels>");
        String cDate = DateUtility.convertDateToString((Date)objProfile.objectCreateDate);
        buffer.append("<objCreateDate>" + cDate + "</objCreateDate>");
        String mDate = DateUtility.convertDateToString((Date)objProfile.objectLastModDate);
        buffer.append("<objLastModDate>" + mDate + "</objLastModDate>");
        buffer.append("<objDissIndexViewURL>" + StreamUtility.enc(objProfile.dissIndexViewURL) + "</objDissIndexViewURL>");
        buffer.append("<objItemIndexViewURL>" + StreamUtility.enc(objProfile.itemIndexViewURL) + "</objItemIndexViewURL>");
        buffer.append("<objState>" + StreamUtility.enc(objProfile.objectState) + "</objState>");
        buffer.append("</objectProfile>");
        return buffer.toString();
    }

    private String datastreamFieldSerialization(Datastream dsProfile, String prefix, boolean validateChecksum) {
        StringBuffer buffer = new StringBuffer();
        if (prefix != null) {
            if (!prefix.equals("")) {
                prefix = prefix + ":";
            }
        } else {
            prefix = "";
        }
        buffer.append("<" + prefix + "dsLabel>" + StreamUtility.enc(dsProfile.DSLabel) + "</" + prefix + "dsLabel>");
        buffer.append("<" + prefix + "dsVersionID>" + StreamUtility.enc(dsProfile.DSVersionID) + "</" + prefix + "dsVersionID>");
        String cDate = DateUtility.convertDateToString((Date)dsProfile.DSCreateDT);
        buffer.append("<" + prefix + "dsCreateDate>" + StreamUtility.enc(cDate) + "</" + prefix + "dsCreateDate>");
        buffer.append("<" + prefix + "dsState>" + StreamUtility.enc(dsProfile.DSState) + "</" + prefix + "dsState>");
        buffer.append("<" + prefix + "dsMIME>" + StreamUtility.enc(dsProfile.DSMIME) + "</" + prefix + "dsMIME>");
        buffer.append("<" + prefix + "dsFormatURI>" + StreamUtility.enc(dsProfile.DSFormatURI) + "</" + prefix + "dsFormatURI>");
        buffer.append("<" + prefix + "dsControlGroup>" + StreamUtility.enc(dsProfile.DSControlGrp) + "</" + prefix + "dsControlGroup>");
        buffer.append("<" + prefix + "dsSize>" + StreamUtility.enc(Long.valueOf(dsProfile.DSSize).toString()) + "</" + prefix + "dsSize>");
        buffer.append("<" + prefix + "dsVersionable>" + StreamUtility.enc(Boolean.valueOf(dsProfile.DSVersionable).toString()) + "</" + prefix + "dsVersionable>");
        buffer.append("<" + prefix + "dsInfoType>" + StreamUtility.enc(dsProfile.DSInfoType) + "</" + prefix + "dsInfoType>");
        buffer.append("<" + prefix + "dsLocation>" + StreamUtility.enc(dsProfile.DSLocation) + "</" + prefix + "dsLocation>");
        buffer.append("<" + prefix + "dsLocationType>" + StreamUtility.enc(dsProfile.DSLocationType) + "</" + prefix + "dsLocationType>");
        buffer.append("<" + prefix + "dsChecksumType>" + StreamUtility.enc(dsProfile.DSChecksumType) + "</" + prefix + "dsChecksumType>");
        buffer.append("<" + prefix + "dsChecksum>" + StreamUtility.enc(dsProfile.DSChecksum) + "</" + prefix + "dsChecksum>");
        if (validateChecksum) {
            String valid = dsProfile.compareChecksum() ? "true" : "false";
            buffer.append("<" + prefix + "dsChecksumValid>" + valid + "</" + prefix + "dsChecksumValid>");
        }
        String[] dsAltIDs = dsProfile.DatastreamAltIDs;
        for (int i = 0; i < dsAltIDs.length; ++i) {
            buffer.append("<" + prefix + "dsAltID>" + StreamUtility.enc(dsAltIDs[i]) + "</" + prefix + "dsAltID>");
        }
        return buffer.toString();
    }

    String datastreamProfileToXML(String pid, String dsID, Datastream dsProfile, Date versDateTime, boolean validateChecksum) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<datastreamProfile  xmlns=\"" + Constants.MANAGEMENT.uri + "\" " + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"http://www.fedora.info/definitions/1/0/management/ " + "http://www.fedora.info/definitions/1/0/datastreamProfile.xsd" + "\"" + " pid=\"" + StreamUtility.enc(pid) + "\"" + " dsID=\"" + StreamUtility.enc(dsID) + "\"");
        if (versDateTime != null && !DateUtility.convertDateToString((Date)versDateTime).equalsIgnoreCase("")) {
            buffer.append(" dateTime=\"" + DateUtility.convertDateToString((Date)versDateTime) + "\"");
        }
        buffer.append(" >");
        buffer.append(this.datastreamFieldSerialization(dsProfile, "", validateChecksum));
        buffer.append("</datastreamProfile>");
        return buffer.toString();
    }

    String datastreamProfilesToXML(String pid, Datastream[] dsProfiles, Date versDateTime, boolean validateChecksum) {
        String tmp;
        StringBuilder builder = new StringBuilder();
        String dateString = "";
        if (versDateTime != null && (tmp = DateUtility.convertDateToString((Date)versDateTime)) != null) {
            dateString = String.format("asOfDateTime=\"%s\" ", tmp);
        }
        String baseUrl = StreamUtility.enc(this.fedoraServerProtocol) + "://" + StreamUtility.enc(this.fedoraServerHost) + ":" + StreamUtility.enc(this.fedoraServerPort) + "/" + this.fedoraAppServerContext;
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<objectDatastreams xmlns=\"" + Constants.ACCESS.uri + "\" ").append("xmlns:apim=\"" + Constants.MANAGEMENT.uri + "\" ").append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append("xsi:schemaLocation=\"http://www.fedora.info/definitions/1/0/access/ ").append(baseUrl).append("/schema/listDatastreams.xsd\"").append(" pid=\"").append(StreamUtility.enc(pid)).append("\" ").append(dateString).append(" baseURL=\"").append(baseUrl).append("/\" >");
        for (Datastream ds : dsProfiles) {
            StringBuilder profileBuilder = new StringBuilder();
            profileBuilder.append("<datastreamProfile pid=\"").append(StreamUtility.enc(pid)).append("\" dsID=\"").append(StreamUtility.enc(ds.DatastreamID)).append("\" >");
            profileBuilder.append(this.datastreamFieldSerialization(ds, "apim", validateChecksum));
            profileBuilder.append("</datastreamProfile>");
            builder.append(profileBuilder.toString());
        }
        builder.append("</objectDatastreams>");
        return builder.toString();
    }

    String objectHistoryToXml(String[] objectHistory, String pid) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<fedoraObjectHistory  xmlns=\"" + Constants.OBJ_HISTORY1_0.namespace.uri + "\"" + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"" + Constants.OBJ_HISTORY1_0.namespace.uri + " " + Constants.OBJ_HISTORY1_0.xsdLocation + "\"" + " pid=\"" + pid + "\" >");
        for (String ts : objectHistory) {
            buffer.append("<objectChangeDate>" + ts + "</objectChangeDate>");
        }
        buffer.append("</fedoraObjectHistory>");
        return buffer.toString();
    }

    String datastreamHistoryToXml(String pid, String dsID, Datastream[] history) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<datastreamHistory  xmlns=\"" + Constants.MANAGEMENT.uri + "\" " + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"http://www.fedora.info/definitions/1/0/management/ " + "http://www.fedora.info/definitions/1/0/datastreamHistory.xsd" + "\"" + " pid=\"" + StreamUtility.enc(pid) + "\"" + " dsID=\"" + StreamUtility.enc(dsID) + "\">");
        for (Datastream ds : history) {
            buffer.append("<datastreamProfile ").append("pid=\"").append(StreamUtility.enc(pid)).append("\"").append(" dsID=\"").append(StreamUtility.enc(dsID)).append("\">");
            buffer.append(this.datastreamFieldSerialization(ds, "", false));
            buffer.append("</datastreamProfile>");
        }
        buffer.append("</datastreamHistory>");
        logger.debug(buffer.toString());
        return buffer.toString();
    }

    public String objectMethodsToXml(ObjectMethodsDef[] methodDefs, String pid, String sDef, Date versDateTime) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String asOfDateTimeElement = "";
        if (versDateTime != null) {
            asOfDateTimeElement = "asOfDateTime=\"" + DateUtility.convertDateToString((Date)versDateTime) + "\" ";
        }
        String sDefElement = "";
        if (sDef != null) {
            sDefElement = "sDef=\"" + StreamUtility.enc(sDef) + "\" ";
        }
        buffer.append("<objectMethods xmlns=\"" + Constants.OBJ_METHODS1_0.namespace.uri + "\" " + "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" " + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "xsi:schemaLocation=\"" + Constants.OBJ_METHODS1_0.namespace.uri + " " + Constants.OBJ_METHODS1_0.xsdLocation + "\" " + " pid=\"" + StreamUtility.enc(pid) + "\" " + asOfDateTimeElement + sDefElement + "baseURL=\"" + StreamUtility.enc(this.fedoraServerProtocol) + "://" + StreamUtility.enc(this.fedoraServerHost) + ":" + StreamUtility.enc(this.fedoraServerPort) + "/" + this.fedoraAppServerContext + "/\" >");
        String nextSdef = "null";
        String currentSdef = "";
        for (int i = 0; i < methodDefs.length; ++i) {
            currentSdef = methodDefs[i].sDefPID;
            if (sDef != null && !currentSdef.equals(sDef)) continue;
            if (!currentSdef.equalsIgnoreCase(nextSdef)) {
                if (!nextSdef.equals("null")) {
                    buffer.append("</sDef>");
                }
                buffer.append("<sDef pid=\"" + StreamUtility.enc(methodDefs[i].sDefPID) + "\" >");
            }
            buffer.append("<method name=\"" + StreamUtility.enc(methodDefs[i].methodName) + "\" >");
            MethodParmDef[] methodParms = methodDefs[i].methodParmDefs;
            for (int j = 0; j < methodParms.length; ++j) {
                buffer.append("<methodParm parmName=\"" + StreamUtility.enc(methodParms[j].parmName) + "\" parmDefaultValue=\"" + StreamUtility.enc(methodParms[j].parmDefaultValue) + "\" parmRequired=\"" + methodParms[j].parmRequired + "\" parmLabel=\"" + StreamUtility.enc(methodParms[j].parmLabel) + "\" >");
                if (methodParms[j].parmDomainValues.length > 0) {
                    buffer.append("<methodParmDomain>");
                    for (int k = 0; k < methodParms[j].parmDomainValues.length; ++k) {
                        buffer.append("<methodParmValue>" + StreamUtility.enc(methodParms[j].parmDomainValues[k]) + "</methodParmValue>");
                    }
                    buffer.append("</methodParmDomain>");
                }
                buffer.append("</methodParm>");
            }
            buffer.append("</method>");
            nextSdef = currentSdef;
        }
        if (!nextSdef.equals("null")) {
            buffer.append("</sDef>");
        }
        buffer.append("</objectMethods>");
        return buffer.toString();
    }

    String searchResultToHtml(String query, String terms, String[] searchableFields, String[] wantedFields, int maxResults, FieldSearchResult result) {
        StringBuffer html = new StringBuffer();
        HashSet<String> fieldHash = new HashSet<String>();
        if (wantedFields != null) {
            for (String wf : wantedFields) {
                fieldHash.add(wf);
            }
        }
        html.append("<html><head><title>Search Repository</title></head>");
        html.append("<body><center>");
        html.append("<table width=\"784\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        html.append("<tr><td width=\"141\" height=\"134\" valign=\"top\"><img src=\"/" + this.fedoraAppServerContext + "/images/newlogo2.jpg\" width=\"141\" height=\"134\"/></td>");
        html.append("<td width=\"643\" valign=\"top\">");
        html.append("<center><h2>Fedora Repository</h2>");
        html.append("<h3>Find Objects</h3>");
        html.append("</center></td></tr></table>");
        html.append("\n");
        html.append("<form method=\"get\">");
        html.append("<center><table border=0 cellpadding=6 cellspacing=0>\n");
        html.append("<tr><td colspan=3 valign=top><i>Fields to display:</i></td><td></td></tr>");
        html.append("<tr>");
        int fieldPerCol = searchableFields.length / 3 + 1;
        for (int i = 0; i < searchableFields.length; ++i) {
            boolean everOtherNFields;
            boolean bl = everOtherNFields = i % fieldPerCol == 0;
            if (everOtherNFields) {
                if (i > 0) {
                    html.append("</font></td>");
                    html.append("\n");
                }
                html.append("<td valign=top><font size=-1>");
                html.append("\n");
            }
            html.append("<input type='checkbox' name='" + searchableFields[i] + "' value='true' " + ("pid".equals(searchableFields[i]) || "title".equals(searchableFields[i]) || fieldHash.contains(searchableFields[i]) ? "checked" : "") + "> <a href='#'>" + searchableFields[i] + "</a><br>");
            html.append("\n");
        }
        html.append("</font></td><td bgcolor=silver valign=top>&nbsp;&nbsp;&nbsp;</td><td valign=top>");
        html.append("Search all fields for phrase: <input type=\"text\" name=\"terms\" size=\"15\" value=\"" + (terms == null ? "" : StreamUtility.enc(terms)) + "\"> <a href=\"#\" onClick=\"javascript:alert('Search All Fields\\n\\nEnter a phrase.  Objects where any field contains the phrase will be returned.\\nThis is a case-insensitive search, and you may use the * or ? wildcards.\\n\\nExamples:\\n\\n  *o*\\n    finds objects where any field contains the letter o.\\n\\n  ?edora\\n    finds objects where a word starts with any letter and ends with edora.')\"><i>help</i></a><p> ");
        html.append("Or search specific field(s): <input type=\"text\" name=\"query\" size=\"15\" value=\"" + (query == null ? "" : StreamUtility.enc(query)) + "\"> <a href=\"#\" onClick=\"javascript:alert('Search Specific Field(s)\\n\\nEnter one or more conditions, separated by space.  Objects matching all conditions will be returned.\\nA condition is a field (choose from the field names on the left) followed by an operator, followed by a value.\\nThe = operator will match if the field\\'s entire value matches the value given.\\nThe ~ operator will match on phrases within fields, and accepts the ? and * wildcards.\\nThe &lt;, &gt;, &lt;=, and &gt;= operators can be used with numeric values, such as dates.\\n\\nExamples:\\n\\n  pid~demo:* description~fedora\\n    Matches all demo objects with a description containing the word fedora.\\n\\n  cDate&gt;=1976-03-04 creator~*n*\\n    Matches objects created on or after March 4th, 1976 where at least one of the creators has an n in their name.\\n\\n  mDate&gt;2002-10-2 mDate&lt;2002-10-2T12:00:00\\n    Matches objects modified sometime before noon (UTC) on October 2nd, 2002')\"><i>help</i></a><p> ");
        html.append("Maximum Results: <select name=\"maxResults\"><option value=\"20\">20</option><option value=\"40\">40</option><option value=\"60\">60</option><option value=\"80\">80</option></select> ");
        html.append("<p><input type=\"submit\" value=\"Search\"> ");
        html.append("</td></tr></table></center>");
        html.append("</form><hr size=1>");
        if (result != null) {
            int i;
            List<ObjectFields> objectFieldList = result.objectFieldsList();
            html.append("<center><table width=\"90%\" border=\"1\" cellpadding=\"5\" cellspacing=\"5\" bgcolor=\"silver\">\n");
            html.append("<tr>");
            for (i = 0; i < wantedFields.length; ++i) {
                html.append("<td valign=\"top\"><strong>");
                html.append(wantedFields[i]);
                html.append("</strong></td>");
            }
            html.append("</tr>");
            for (i = 0; i < objectFieldList.size(); ++i) {
                ObjectFields f = objectFieldList.get(i);
                html.append("<tr>");
                for (int j = 0; j < wantedFields.length; ++j) {
                    String l = wantedFields[j];
                    html.append("<td valign=\"top\">");
                    if (l.equalsIgnoreCase("pid")) {
                        html.append("<a href=\"objects/");
                        try {
                            html.append(URLEncoder.encode(f.getPid(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                        html.append("\">");
                        html.append(f.getPid());
                        html.append("</a>");
                    } else if (l.equalsIgnoreCase("label")) {
                        if (f.getLabel() != null) {
                            html.append(StreamUtility.enc(f.getLabel()));
                        }
                    } else if (l.equalsIgnoreCase("state")) {
                        html.append(f.getState());
                    } else if (l.equalsIgnoreCase("ownerId")) {
                        if (f.getOwnerId() != null) {
                            html.append(f.getOwnerId());
                        }
                    } else if (l.equalsIgnoreCase("cDate")) {
                        html.append(DateUtility.convertDateToString((Date)f.getCDate()));
                    } else if (l.equalsIgnoreCase("mDate")) {
                        html.append(DateUtility.convertDateToString((Date)f.getMDate()));
                    } else if (l.equalsIgnoreCase("dcmDate")) {
                        if (f.getDCMDate() != null) {
                            html.append(DateUtility.convertDateToString((Date)f.getDCMDate()));
                        }
                    } else if (l.equalsIgnoreCase("title")) {
                        html.append(DefaultSerializer.join(f.titles()));
                    } else if (l.equalsIgnoreCase("creator")) {
                        html.append(DefaultSerializer.join(f.creators()));
                    } else if (l.equalsIgnoreCase("subject")) {
                        html.append(DefaultSerializer.join(f.subjects()));
                    } else if (l.equalsIgnoreCase("description")) {
                        html.append(DefaultSerializer.join(f.descriptions()));
                    } else if (l.equalsIgnoreCase("publisher")) {
                        html.append(DefaultSerializer.join(f.publishers()));
                    } else if (l.equalsIgnoreCase("contributor")) {
                        html.append(DefaultSerializer.join(f.contributors()));
                    } else if (l.equalsIgnoreCase("date")) {
                        html.append(DefaultSerializer.join(f.dates()));
                    } else if (l.equalsIgnoreCase("type")) {
                        html.append(DefaultSerializer.join(f.types()));
                    } else if (l.equalsIgnoreCase("format")) {
                        html.append(DefaultSerializer.join(f.formats()));
                    } else if (l.equalsIgnoreCase("identifier")) {
                        html.append(DefaultSerializer.join(f.identifiers()));
                    } else if (l.equalsIgnoreCase("source")) {
                        html.append(DefaultSerializer.join(f.sources()));
                    } else if (l.equalsIgnoreCase("language")) {
                        html.append(DefaultSerializer.join(f.languages()));
                    } else if (l.equalsIgnoreCase("relation")) {
                        html.append(DefaultSerializer.join(f.relations()));
                    } else if (l.equalsIgnoreCase("coverage")) {
                        html.append(DefaultSerializer.join(f.coverages()));
                    } else if (l.equalsIgnoreCase("rights")) {
                        html.append(DefaultSerializer.join(f.rights()));
                    }
                    html.append("</td>");
                    html.append("\n");
                }
                html.append("</tr>");
                html.append("\n");
                html.append("<tr><td colspan=\"");
                html.append(wantedFields.length);
                html.append("\"></td></tr>");
                html.append("\n");
            }
            html.append("</table>");
            html.append("\n");
            if (result != null && result.getToken() != null) {
                if (result.getCursor() != -1L) {
                    long viewingStart = result.getCursor() + 1L;
                    long viewingEnd = (long)result.objectFieldsList().size() + viewingStart - 1L;
                    html.append("<p>Viewing results " + viewingStart + " to " + viewingEnd);
                    if (result.getCompleteListSize() != -1L) {
                        html.append(" of " + result.getCompleteListSize());
                    }
                    html.append("</p>\n");
                }
                html.append("<form method=\"get\" action=\"\">");
                html.append("\n");
                for (String field : wantedFields) {
                    html.append("<input type=\"hidden\" name=\"" + field + "\" value=\"true\">");
                    html.append("\n");
                }
                html.append("\n");
                html.append("\n<input type=\"hidden\" name=\"sessionToken\" value=\"" + result.getToken() + "\">\n");
                html.append("\n<input type=\"hidden\" name=\"maxResults\" value=\"" + maxResults + "\">\n");
                html.append("<input type=\"submit\" value=\"More Results &gt;\"></form>");
            }
            html.append("</center>\n");
        }
        html.append("</center>");
        html.append("</body>");
        html.append("</html>");
        return html.toString();
    }

    String searchResultToXml(FieldSearchResult result) {
        StringBuffer xmlBuf = new StringBuffer();
        String baseUrl = StreamUtility.enc(this.fedoraServerProtocol) + "://" + StreamUtility.enc(this.fedoraServerHost) + ":" + StreamUtility.enc(this.fedoraServerPort) + "/" + this.fedoraAppServerContext;
        xmlBuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlBuf.append("<result xmlns=\"http://www.fedora.info/definitions/1/0/types/\" ").append("xmlns:types=\"http://www.fedora.info/definitions/1/0/types/\" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append("xsi:schemaLocation=\"http://www.fedora.info/definitions/1/0/types/ ").append(baseUrl).append("/schema/findObjects.xsd\"");
        xmlBuf.append(">\n");
        if (result != null && result.getToken() != null) {
            xmlBuf.append("  <listSession>\n");
            xmlBuf.append("    <token>" + result.getToken() + "</token>\n");
            if (result.getCursor() != -1L) {
                xmlBuf.append("    <cursor>" + result.getCursor() + "</cursor>\n");
            }
            if (result.getCompleteListSize() != -1L) {
                xmlBuf.append("    <completeListSize>" + result.getCompleteListSize() + "</completeListSize>\n");
            }
            if (result.getExpirationDate() != null) {
                xmlBuf.append("    <expirationDate>" + DateUtility.convertDateToString((Date)result.getExpirationDate()) + "</expirationDate>\n");
            }
            xmlBuf.append("  </listSession>\n");
        }
        xmlBuf.append("  <resultList>\n");
        if (result != null) {
            List<ObjectFields> fieldList = result.objectFieldsList();
            for (int i = 0; i < fieldList.size(); ++i) {
                ObjectFields f = fieldList.get(i);
                xmlBuf.append("  <objectFields>\n");
                DefaultSerializer.appendXML("pid", f.getPid(), xmlBuf);
                DefaultSerializer.appendXML("label", f.getLabel(), xmlBuf);
                DefaultSerializer.appendXML("state", f.getState(), xmlBuf);
                DefaultSerializer.appendXML("ownerId", f.getOwnerId(), xmlBuf);
                DefaultSerializer.appendXML("cDate", f.getCDate(), xmlBuf);
                DefaultSerializer.appendXML("mDate", f.getMDate(), xmlBuf);
                DefaultSerializer.appendXML("dcmDate", f.getDCMDate(), xmlBuf);
                this.appendXML("title", f.titles(), xmlBuf);
                this.appendXML("creator", f.creators(), xmlBuf);
                this.appendXML("subject", f.subjects(), xmlBuf);
                this.appendXML("description", f.descriptions(), xmlBuf);
                this.appendXML("publisher", f.publishers(), xmlBuf);
                this.appendXML("contributor", f.contributors(), xmlBuf);
                this.appendXML("date", f.dates(), xmlBuf);
                this.appendXML("type", f.types(), xmlBuf);
                this.appendXML("format", f.formats(), xmlBuf);
                this.appendXML("identifier", f.identifiers(), xmlBuf);
                this.appendXML("source", f.sources(), xmlBuf);
                this.appendXML("language", f.languages(), xmlBuf);
                this.appendXML("relation", f.relations(), xmlBuf);
                this.appendXML("coverage", f.coverages(), xmlBuf);
                this.appendXML("rights", f.rights(), xmlBuf);
                xmlBuf.append("  </objectFields>\n");
            }
        }
        xmlBuf.append("  </resultList>\n");
        xmlBuf.append("</result>\n");
        return xmlBuf.toString();
    }

    private static String join(List<DCField> l) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(StreamUtility.enc(l.get(i).getValue()));
        }
        return ret.toString();
    }

    private static void appendXML(String name, String value, StringBuffer out) {
        if (value != null) {
            out.append("      <" + name + ">" + StreamUtility.enc(value) + "</" + name + ">\n");
        }
    }

    private void appendXML(String name, List<DCField> values, StringBuffer out) {
        for (int i = 0; i < values.size(); ++i) {
            DefaultSerializer.appendXML(name, values.get(i).getValue(), out);
        }
    }

    private static void appendXML(String name, Date dt, StringBuffer out) {
        if (dt != null) {
            DefaultSerializer.appendXML(name, DateUtility.convertDateToString((Date)dt), out);
        }
    }

    public String dataStreamsToXML(String pid, Date asOfDateTime, DatastreamDef[] dsDefs) {
        String tmp;
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String dateString = "";
        if (asOfDateTime != null && (tmp = DateUtility.convertDateToString((Date)asOfDateTime)) != null) {
            dateString = String.format("asOfDateTime=\"%s\" ", tmp);
        }
        xml.append("<objectDatastreams  xmlns=\"" + Constants.OBJ_DATASTREAMS1_0.namespace.uri + "\" " + "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" " + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + " xsi:schemaLocation=\"" + Constants.OBJ_DATASTREAMS1_0.namespace.uri + " " + Constants.OBJ_DATASTREAMS1_0.xsdLocation + "\"" + " pid=\"" + StreamUtility.enc(pid) + "\" " + dateString + " baseURL=\"" + StreamUtility.enc(this.fedoraServerProtocol) + "://" + StreamUtility.enc(this.fedoraServerHost) + ":" + StreamUtility.enc(this.fedoraServerPort) + "/" + this.fedoraAppServerContext + "/\" >");
        for (int i = 0; i < dsDefs.length; ++i) {
            xml.append("    <datastream dsid=\"" + StreamUtility.enc(dsDefs[i].dsID) + "\" " + "label=\"" + StreamUtility.enc(dsDefs[i].dsLabel) + "\" " + "mimeType=\"" + StreamUtility.enc(dsDefs[i].dsMIME) + "\" />");
        }
        xml.append("</objectDatastreams>");
        return xml.toString();
    }

    public String objectValidationToXml(Validation validation) {
        StringBuilder buffer = new StringBuilder();
        String pid = validation.getPid();
        Date date = validation.getAsOfDateTime();
        String dateString = null;
        boolean valid = validation.isValid();
        if (date != null) {
            dateString = DateUtility.convertDateToString((Date)date);
        }
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<management:validation  xmlns:management=\"" + Constants.OBJ_VALIDATION1_0.namespace.uri + "\"" + " xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + " xsi:schemaLocation=\"" + Constants.OBJ_VALIDATION1_0.namespace.uri + " " + Constants.OBJ_VALIDATION1_0.xsdLocation + "\"" + " pid=\"" + StreamUtility.enc(pid) + "\" " + " valid=\"" + valid + "\">\n");
        if (date != null) {
            buffer.append("  <management:asOfDateTime>" + dateString + "</management:asOfDateTime>\n");
        }
        buffer.append("  <management:contentModels>\n");
        for (String model : validation.getContentModels()) {
            buffer.append("    <management:model>");
            buffer.append(StreamUtility.enc(model));
            buffer.append("</management:model>\n");
        }
        buffer.append("  </management:contentModels>\n");
        buffer.append("  <management:problems>\n");
        for (String problem : validation.getObjectProblems()) {
            buffer.append("    <management:problem>");
            buffer.append(problem);
            buffer.append("</management:problem>\n");
        }
        buffer.append("  </management:problems>\n");
        buffer.append("  <management:datastreamProblems>\n");
        Map<String, List<String>> dsprobs = validation.getDatastreamProblems();
        for (String ds : dsprobs.keySet()) {
            List<String> problems = dsprobs.get(ds);
            buffer.append("    <management:datastream");
            buffer.append(" datastreamID=\"");
            buffer.append(ds);
            buffer.append("\">\n");
            for (String problem : problems) {
                buffer.append("      <management:problem>");
                buffer.append(problem);
                buffer.append("</management:problem>\n");
            }
            buffer.append("    </management:datastream>");
        }
        buffer.append("  </management:datastreamProblems>\n");
        buffer.append("</management:validation>");
        return buffer.toString();
    }
}

