/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.servlet.ServletException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.rest.BaseRestResource;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class DescribeRepositoryResource
extends BaseRestResource
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(DescribeRepositoryResource.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";

    public DescribeRepositoryResource(Server server) {
        super(server);
    }

    @Path(value="/")
    @GET
    public Response describe(@QueryParam(value="xml") @DefaultValue(value="false") boolean xml) throws ServletException, IOException {
        Context context = this.getContext();
        try {
            return this.describeRepository(context, xml);
        }
        catch (Exception ae) {
            return this.handleException(ae, false);
        }
    }

    @Path(value="/")
    @POST
    public Response postDescribe(@QueryParam(value="xml") @DefaultValue(value="false") boolean xml) throws ServletException, IOException {
        return this.describe(xml);
    }

    public Response describeRepository(Context context, boolean xml) throws ServerException {
        RepositoryInfo repositoryInfo = null;
        try {
            repositoryInfo = this.m_access.describeRepository(context);
            if (repositoryInfo != null) {
                ReposInfoSerializer result = new ReposInfoSerializer(context, repositoryInfo);
                if (xml) {
                    return Response.ok((Object)result, (String)CONTENT_TYPE_XML).build();
                }
                return Response.ok((Object)new HtmlTransformation(context, result), (String)CONTENT_TYPE_HTML).build();
            }
            logger.error("No repository info returned");
            return Response.noContent().build();
        }
        catch (AuthzException ae) {
            throw ae;
        }
        catch (Throwable th) {
            String msg = "Error describing repository";
            logger.error(msg, th);
            throw new GeneralException(msg, th);
        }
    }

    public class HtmlTransformation
    implements StreamingOutput {
        private final ReposInfoSerializer reposInfo;
        private final Context context;

        public HtmlTransformation(Context context, ReposInfoSerializer input) {
            this.reposInfo = input;
            this.context = context;
        }

        public void write(OutputStream out) throws IOException {
            File xslFile = new File(DescribeRepositoryResource.this.m_server.getHomeDir(), "access/viewRepositoryInfo.xslt");
            PipedOutputStream po = new PipedOutputStream();
            PipedInputStream pr = new PipedInputStream(po);
            this.reposInfo.write(po);
            try {
                TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                Templates template = factory.newTemplates(new StreamSource(xslFile));
                Transformer transformer = template.newTransformer();
                transformer.setParameter("fedora", this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
                transformer.transform(new StreamSource(pr), new StreamResult(out));
            }
            catch (TransformerException te) {
                throw new IOException("Transform error" + te.toString(), te);
            }
            out.flush();
        }
    }

    public class ReposInfoSerializer
    implements StreamingOutput {
        private RepositoryInfo repositoryInfo = null;

        public ReposInfoSerializer(Context context, RepositoryInfo repositoryInfo) {
            this.repositoryInfo = repositoryInfo;
        }

        public void write(OutputStream output) throws IOException {
            String[] emails;
            String[] retainPIDs;
            OutputStreamWriter pw = new OutputStreamWriter(output, "UTF-8");
            pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.write("<fedoraRepository xmlns=\"" + Constants.REPO_DESC1_0.namespace.uri + "\"" + " xmlns:xsd=\"" + Constants.XML_XSD.uri + "\"" + " xmlns:xsi=\"" + Constants.XSI.uri + "\"" + " xsi:schemaLocation=\"" + Constants.ACCESS.uri + " " + Constants.REPO_DESC1_0.xsdLocation + "\">");
            pw.write("<repositoryName>" + this.repositoryInfo.repositoryName + "</repositoryName>");
            pw.write("<repositoryBaseURL>" + this.repositoryInfo.repositoryBaseURL + "</repositoryBaseURL>");
            pw.write("<repositoryVersion>" + this.repositoryInfo.repositoryVersion + "</repositoryVersion>");
            pw.write("<repositoryPID>");
            pw.write("    <PID-namespaceIdentifier>" + this.repositoryInfo.repositoryPIDNamespace + "</PID-namespaceIdentifier>");
            pw.write("    <PID-delimiter>:</PID-delimiter>");
            pw.write("    <PID-sample>" + this.repositoryInfo.samplePID + "</PID-sample>");
            for (String element : retainPIDs = this.repositoryInfo.retainPIDs) {
                pw.write("    <retainPID>" + element + "</retainPID>");
            }
            pw.write("</repositoryPID>");
            pw.write("<repositoryOAI-identifier>");
            pw.write("    <OAI-namespaceIdentifier>" + this.repositoryInfo.OAINamespace + "</OAI-namespaceIdentifier>");
            pw.write("    <OAI-delimiter>:</OAI-delimiter>");
            pw.write("    <OAI-sample>" + this.repositoryInfo.sampleOAIIdentifer + "</OAI-sample>");
            pw.write("</repositoryOAI-identifier>");
            pw.write("<sampleSearch-URL>" + this.repositoryInfo.sampleSearchURL + "</sampleSearch-URL>");
            pw.write("<sampleAccess-URL>" + this.repositoryInfo.sampleAccessURL + "</sampleAccess-URL>");
            pw.write("<sampleOAI-URL>" + this.repositoryInfo.sampleOAIURL + "</sampleOAI-URL>");
            for (String element : emails = this.repositoryInfo.adminEmailList) {
                pw.write("<adminEmail>" + element + "</adminEmail>");
            }
            pw.write("</fedoraRepository>");
            pw.flush();
            pw.close();
        }
    }
}

