/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.rest.BaseRestResource;
import org.fcrepo.server.rest.RestHelper;
import org.fcrepo.server.rest.RestUtil;
import org.fcrepo.server.rest.param.DateTimeParam;
import org.fcrepo.server.search.Condition;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class FedoraObjectsResource
extends BaseRestResource {
    private final String FOXML1_1 = "info:fedora/fedora-system:FOXML-1.1";
    private final String ATOMZIP1_1 = "info:fedora/fedora-system:ATOMZip-1.1";
    static final String[] SEARCHABLE_FIELDS = new String[]{"pid", "label", "state", "ownerId", "cDate", "mDate", "dcmDate", "title", "creator", "subject", "description", "publisher", "contributor", "date", "type", "format", "identifier", "source", "language", "relation", "coverage", "rights"};
    private static final Logger logger = LoggerFactory.getLogger(FedoraObjectsResource.class);

    public FedoraObjectsResource(Server server) {
        super(server);
    }

    @GET
    @Path(value="/")
    @Produces(value={"text/html", "text/xml"})
    public Response searchObjects(@QueryParam(value="terms") String terms, @QueryParam(value="query") String query, @QueryParam(value="maxResults") @DefaultValue(value="25") int maxResults, @QueryParam(value="sessionToken") String sessionToken, @QueryParam(value="resultFormat") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            String[] wantedFields = FedoraObjectsResource.getWantedFields(this.m_servletRequest);
            MediaType mime = RestHelper.getContentType(format);
            FieldSearchResult result = null;
            if (wantedFields.length > 0 || sessionToken != null) {
                result = sessionToken != null ? this.m_access.resumeFindObjects(context, sessionToken) : (terms != null && terms.length() != 0 ? this.m_access.findObjects(context, wantedFields, maxResults, new FieldSearchQuery(terms)) : this.m_access.findObjects(context, wantedFields, maxResults, new FieldSearchQuery(Condition.getConditions(query))));
            }
            String output = TEXT_HTML.isCompatible(mime) ? this.getSerializer(context).searchResultToHtml(query, terms, SEARCHABLE_FIELDS, wantedFields, maxResults, result) : this.getSerializer(context).searchResultToXml(result);
            return Response.ok((Object)output, (MediaType)mime).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/nextPID")
    @POST
    public Response getNextPID(@QueryParam(value="numPIDs") @DefaultValue(value="1") int numPIDS, @QueryParam(value="namespace") String namespace, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) throws Exception {
        try {
            Context context = this.getContext();
            String[] pidList = this.m_management.getNextPID(context, numPIDS, namespace);
            MediaType mime = RestHelper.getContentType(format);
            if (pidList.length > 0) {
                String output = this.getSerializer(context).pidsToXml(pidList);
                if (TEXT_HTML.isCompatible(mime)) {
                    CharArrayWriter writer = new CharArrayWriter();
                    this.transform(output, "management/getNextPIDInfo.xslt", writer);
                    output = writer.toString();
                }
                return Response.ok((Object)output, (MediaType)mime).build();
            }
            return Response.noContent().build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    private static String[] getWantedFields(HttpServletRequest request) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String f : SEARCHABLE_FIELDS) {
            if (!"true".equals(request.getParameter(f))) continue;
            fields.add(f);
        }
        return fields.toArray(new String[fields.size()]);
    }

    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/validate")
    @GET
    @Produces(value={"text/xml"})
    public Response doObjectValidation(@PathParam(value="pid") String pid, @QueryParam(value="asOfDateTime") String dateTime, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dateTime);
            MediaType mediaType = TEXT_XML;
            Validation validation = this.m_management.validate(context, pid, asOfDateTime);
            String xml = this.getSerializer(context).objectValidationToXml(validation);
            return Response.ok((Object)xml, (MediaType)mediaType).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/export")
    @GET
    @Produces(value={"text/xml", "application/zip"})
    public Response getObjectExport(@PathParam(value="pid") String pid, @QueryParam(value="format") @DefaultValue(value="info:fedora/fedora-system:FOXML-1.1") String format, @QueryParam(value="context") String exportContext, @QueryParam(value="encoding") @DefaultValue(value="UTF-8") String encoding, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            InputStream is = this.m_management.export(context, pid, format, exportContext, encoding);
            MediaType mediaType = TEXT_XML;
            if (format.equals("info:fedora/fedora-system:ATOMZip-1.1")) {
                mediaType = MediaType.valueOf((String)"application/zip");
            }
            return Response.ok((Object)is, (MediaType)mediaType).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/versions")
    @GET
    public Response getObjectHistory(@PathParam(value="pid") String pid, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            String[] objectHistory = this.m_access.getObjectHistory(context, pid);
            String xml = this.getSerializer(context).objectHistoryToXml(objectHistory, pid);
            MediaType mime = RestHelper.getContentType(format);
            if (TEXT_HTML.isCompatible(mime)) {
                CharArrayWriter writer = new CharArrayWriter();
                this.transform(xml, "access/viewObjectHistory.xslt", writer);
                xml = writer.toString();
            }
            return Response.ok((Object)xml, (MediaType)mime).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/objectXML")
    @GET
    @Produces(value={"text/xml"})
    public Response getObjectXML(@PathParam(value="pid") String pid, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            InputStream is = this.m_management.getObjectXML(context, pid, "UTF-8");
            return Response.ok((Object)is, (MediaType)TEXT_XML).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @GET
    @Produces(value={"text/html", "text/xml"})
    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}")
    public Response getObjectProfile(@PathParam(value="pid") String pid, @QueryParam(value="asOfDateTime") String dateTime, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dateTime);
            Context context = this.getContext();
            ObjectProfile objProfile = this.m_access.getObjectProfile(context, pid, asOfDateTime);
            String xml = this.getSerializer(context).objectProfileToXML(objProfile, asOfDateTime);
            MediaType mime = RestHelper.getContentType(format);
            if (TEXT_HTML.isCompatible(mime)) {
                CharArrayWriter writer = new CharArrayWriter();
                this.transform(xml, "access/viewObjectProfile.xslt", writer);
                xml = writer.toString();
            }
            return Response.ok((Object)xml, (MediaType)mime).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @DELETE
    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}")
    public Response deleteObject(@PathParam(value="pid") String pid, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            Date d = this.m_management.purgeObject(context, pid, logMessage);
            return Response.ok((Object)DateUtility.convertDateToXSDString((Date)d), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @POST
    @Path(value="/new")
    @Consumes(value={"text/xml", "multipart/form-data"})
    public Response newObject(@javax.ws.rs.core.Context HttpHeaders headers, @QueryParam(value="label") String label, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="format") @DefaultValue(value="info:fedora/fedora-system:FOXML-1.1") String format, @QueryParam(value="encoding") @DefaultValue(value="UTF-8") String encoding, @QueryParam(value="namespace") String namespace, @QueryParam(value="ownerId") String ownerID, @QueryParam(value="state") @DefaultValue(value="A") String state, @QueryParam(value="ignoreMime") @DefaultValue(value="false") boolean ignoreMime, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        return this.createObject(headers, "new", label, logMessage, format, encoding, namespace, ownerID, state, ignoreMime, flash);
    }

    @POST
    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}")
    @Consumes(value={"text/xml", "multipart/form-data"})
    public Response createObject(@javax.ws.rs.core.Context HttpHeaders headers, @PathParam(value="pid") String pid, @QueryParam(value="label") String label, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="format") @DefaultValue(value="info:fedora/fedora-system:FOXML-1.1") String format, @QueryParam(value="encoding") @DefaultValue(value="UTF-8") String encoding, @QueryParam(value="namespace") String namespace, @QueryParam(value="ownerId") String ownerID, @QueryParam(value="state") @DefaultValue(value="A") String state, @QueryParam(value="ignoreMime") @DefaultValue(value="false") boolean ignoreMime, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            InputStream is = null;
            RestUtil restUtil = new RestUtil();
            RestUtil.RequestContent content = restUtil.getRequestContent(this.m_servletRequest, headers);
            if (content != null && content.getContentStream() != null) {
                if (ignoreMime) {
                    is = content.getContentStream();
                } else {
                    String contentMime = content.getMimeType();
                    if (contentMime != null && TEXT_XML.isCompatible(MediaType.valueOf((String)contentMime))) {
                        is = content.getContentStream();
                    }
                }
            }
            if (is == null) {
                if (pid == null || pid.equals("new")) {
                    pid = this.m_management.getNextPID(context, 1, namespace)[0];
                }
                if (ownerID == null || "".equals(ownerID.trim())) {
                    ownerID = context.getSubjectValue(Constants.SUBJECT.LOGIN_ID.uri);
                }
                is = new ByteArrayInputStream(FedoraObjectsResource.getFOXMLTemplate(pid, label, ownerID, encoding).getBytes());
            } else if (namespace != null && !namespace.equals("")) {
                logger.warn("The namespace parameter is only applicable when object content is not provided, thus the namespace provided '" + namespace + "' has been ignored.");
            }
            pid = this.m_management.ingest(context, is, logMessage, format, encoding, pid);
            URI createdLocation = this.m_uriInfo.getRequestUri().resolve(URLEncoder.encode(pid, "UTF-8"));
            return Response.created((URI)createdLocation).entity((Object)pid).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    @PUT
    @Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+(:|%3A|%3a)(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}")
    @Produces(value={"text/plain"})
    public Response updateObject(@PathParam(value="pid") String pid, @QueryParam(value="label") String label, @QueryParam(value="logMessage") String logMessage, @QueryParam(value="ownerId") String ownerID, @QueryParam(value="state") String state, @QueryParam(value="lastModifiedDate") DateTimeParam lastModifiedDate, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Context context = this.getContext();
            Date requestModDate = null;
            if (lastModifiedDate != null) {
                requestModDate = (Date)lastModifiedDate.getValue();
            }
            Date lastModDate = this.m_management.modifyObject(context, pid, state, label, ownerID, logMessage, requestModDate);
            return Response.ok().entity((Object)DateUtility.convertDateToXSDString((Date)lastModDate)).build();
        }
        catch (Exception ex) {
            return this.handleException(ex, flash);
        }
    }

    private static String getFOXMLTemplate(String pid, String label, String ownerId, String encoding) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
        xml.append("<foxml:digitalObject VERSION=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        xml.append("    xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\"\n");
        xml.append("           xsi:schemaLocation=\"" + Constants.FOXML.uri + " " + Constants.FOXML1_1.xsdLocation + "\"");
        if (pid != null && pid.length() > 0) {
            xml.append("\n           PID=\"" + StreamUtility.enc(pid) + "\">\n");
        } else {
            xml.append(">\n");
        }
        xml.append("  <foxml:objectProperties>\n");
        xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>\n");
        xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"" + StreamUtility.enc(label) + "\"/>\n");
        xml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#ownerId\" VALUE=\"" + ownerId + "\"/>\n");
        xml.append("  </foxml:objectProperties>\n");
        xml.append("</foxml:digitalObject>");
        return xml.toString();
    }
}

