/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.CharArrayWriter;
import java.util.Date;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.rest.BaseRestResource;
import org.fcrepo.server.rest.RestHelper;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.utilities.DateUtility;
import org.springframework.stereotype.Component;

@Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+:(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/methods")
@Component
public class MethodResource
extends BaseRestResource {
    @javax.ws.rs.core.Context
    UriInfo uriInfo;

    public MethodResource(Server server) {
        super(server);
    }

    @GET
    @Produces(value={"text/html", "text/xml"})
    public Response getAllObjectMethods(@PathParam(value="pid") String pid, @QueryParam(value="asOfDateTime") String dTime, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        return this.getObjectMethodsForSDefImpl(pid, null, dTime, format, flash);
    }

    @Path(value="/{sDef}")
    @GET
    @Produces(value={"text/html", "text/xml"})
    public Response getObjectMethodsForSDef(@PathParam(value="pid") String pid, @PathParam(value="sDef") String sDef, @QueryParam(value="asOfDateTime") String dTime, @QueryParam(value="format") @DefaultValue(value="text/html") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        return this.getObjectMethodsForSDefImpl(pid, sDef, dTime, format, flash);
    }

    @Path(value="/{sDef}/{method}")
    @GET
    public Response invokeSDefMethodUsingGET(@PathParam(value="pid") String pid, @PathParam(value="sDef") String sDef, @PathParam(value="method") String method, @QueryParam(value="asOfDateTime") String dTime, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        try {
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dTime);
            return this.buildResponse(this.m_access.getDissemination(this.getContext(), pid, sDef, method, MethodResource.toProperties((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), asOfDateTime != null), asOfDateTime));
        }
        catch (Exception e) {
            return this.handleException(e, flash);
        }
    }

    private Response getObjectMethodsForSDefImpl(String pid, String sDef, String dTime, String format, boolean flash) {
        try {
            Date asOfDateTime = DateUtility.parseDateOrNull((String)dTime);
            Context context = this.getContext();
            ObjectMethodsDef[] methodDefs = this.m_access.listMethods(context, pid, asOfDateTime);
            String xml = this.getSerializer(context).objectMethodsToXml(methodDefs, pid, sDef, asOfDateTime);
            MediaType mime = RestHelper.getContentType(format);
            if (TEXT_HTML.isCompatible(mime)) {
                CharArrayWriter writer = new CharArrayWriter();
                this.transform(xml, "access/listMethods.xslt", writer);
                xml = writer.toString();
            }
            return Response.ok((Object)xml, (MediaType)mime).build();
        }
        catch (Exception e) {
            return this.handleException(e, flash);
        }
    }

    private static Property[] toProperties(MultivaluedMap<String, String> map, boolean omitDateTime) {
        Property[] props = omitDateTime ? new Property[map.size() - 1] : new Property[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            if (key.equals("asOfDateTime")) continue;
            props[i++] = new Property(key, (String)map.getFirst((Object)key));
        }
        return props;
    }
}

