/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RequestContent getRequestContent(HttpServletRequest request, HttpHeaders headers) throws Exception {
        RequestContent rContent = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                String contentLength;
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                rContent = new RequestContent();
                rContent.contentStream = item.openStream();
                rContent.mimeType = item.getContentType();
                FileItemHeaders itemHeaders = item.getHeaders();
                if (itemHeaders != null && (contentLength = itemHeaders.getHeader("Content-Length")) != null) {
                    rContent.size = Integer.parseInt(contentLength);
                }
                break;
            }
        } else if (rContent == null) {
            if (request.getContentLength() > 0) {
                rContent = new RequestContent();
                rContent.contentStream = (InputStream)request.getInputStream();
                rContent.size = request.getContentLength();
            } else {
                String transferEncoding = request.getHeader("Transfer-Encoding");
                if (transferEncoding != null && transferEncoding.contains("chunked")) {
                    BufferedInputStream bis = new BufferedInputStream((InputStream)request.getInputStream());
                    bis.mark(2);
                    if (bis.read() > 0) {
                        bis.reset();
                        rContent = new RequestContent();
                        rContent.contentStream = bis;
                    }
                }
            }
        }
        if (rContent != null) {
            List lengthHeaders;
            MediaType mediaType;
            if (rContent.mimeType == null && (mediaType = headers.getMediaType()) != null) {
                rContent.mimeType = mediaType.toString();
            }
            if (rContent.size == 0L && (lengthHeaders = headers.getRequestHeader("Content-Length")) != null && lengthHeaders.size() > 0) {
                rContent.size = Long.parseLong((String)lengthHeaders.get(0));
            }
        }
        return rContent;
    }

    class RequestContent {
        private InputStream contentStream = null;
        private String mimeType = null;
        private long size = 0L;

        RequestContent() {
        }

        public InputStream getContentStream() {
            return this.contentStream;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public long getSize() {
            return this.size;
        }
    }
}

