/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.fcrepo.server.Server;
import org.fcrepo.server.rest.BaseRestResource;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class SchemaResource
extends BaseRestResource {
    private final File schemaDir;

    public SchemaResource(Server server) {
        super(server);
        this.schemaDir = new File(server.getHomeDir(), "xsd");
    }

    @GET
    @Path(value="/{schema : \\w+\\.((dtd)|(xsd))}")
    public Response getSchema(@PathParam(value="schema") String schemaName) {
        File schema = new File(this.schemaDir, schemaName);
        if (schema.exists()) {
            String mime = schemaName.endsWith("xsd") ? "text/xml" : "text/plain";
            try {
                return Response.ok((Object)new FileInputStream(schema), (String)mime).build();
            }
            catch (IOException ioe) {
                return this.handleException(ioe, false);
            }
        }
        return Response.status((int)404).build();
    }
}

