/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.QueryParseException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StorageDeviceException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnrecognizedFieldException;
import org.fcrepo.server.search.Condition;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.FieldSearchSQLImpl;
import org.fcrepo.server.search.ObjectFields;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.utilities.MD5Utility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSearchResultSQLImpl
implements FieldSearchResult {
    private static final Logger logger = LoggerFactory.getLogger(FieldSearchResultSQLImpl.class);
    private ArrayList m_objectFields;
    private String m_token;
    private long m_cursor = -1L;
    private final long m_completeListSize = -1L;
    private Date m_expirationDate;
    private String m_nextPID;
    private final Connection m_conn;
    private final ConnectionPool m_cPool;
    private final RepositoryReader m_repoReader;
    private final String[] m_resultFields;
    private final int m_maxResults;
    private final int m_maxSeconds;
    private long m_startMillis;
    private PreparedStatement m_statement;
    private ResultSet m_resultSet;
    private long m_nextCursor = 0L;
    private boolean m_expired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldSearchResultSQLImpl(ConnectionPool cPool, RepositoryReader repoReader, String[] resultFields, int maxResults, int maxSeconds, FieldSearchQuery query) throws SQLException, QueryParseException {
        this.m_cPool = cPool;
        this.m_repoReader = repoReader;
        this.m_resultFields = resultFields;
        this.m_maxResults = maxResults;
        this.m_maxSeconds = maxSeconds;
        this.m_conn = this.m_cPool.getReadOnlyConnection();
        boolean success = false;
        try {
            this.m_statement = this.m_conn.prepareStatement(this.logAndGetQueryText(query, this.m_resultFields));
            this.m_resultSet = this.m_statement.executeQuery();
            success = true;
        }
        finally {
            if (!success) {
                try {
                    if (this.m_resultSet != null) {
                        this.m_resultSet.close();
                    }
                    if (this.m_statement != null) {
                        this.m_statement.close();
                    }
                    if (this.m_conn != null) {
                        this.m_cPool.free(this.m_conn);
                    }
                }
                catch (SQLException e) {
                    logger.warn("SQL error during failed query cleanup", (Throwable)e);
                }
                finally {
                    this.m_resultSet = null;
                    this.m_statement = null;
                }
            }
        }
    }

    private String logAndGetQueryText(FieldSearchQuery query, String[] resultFields) throws SQLException, QueryParseException {
        StringBuffer queryText = new StringBuffer("SELECT");
        if (query.getType() == 2) {
            queryText.append(" doFields.pid FROM doFields" + this.getWhereClause(query.getTerms()));
        } else {
            StringBuffer resultFieldsString = new StringBuffer();
            if (resultFields.length > 0) {
                String delimiter = " ";
                for (String element : resultFields) {
                    String dbColumn = "doFields." + FieldSearchResultSQLImpl.dcFixup(element);
                    resultFieldsString.append(delimiter + dbColumn);
                    delimiter = ", ";
                }
            }
            queryText.append(resultFieldsString);
            queryText.append(" FROM doFields");
            queryText.append(this.getWhereClause(query.getConditions()));
        }
        String qt = queryText.toString();
        logger.debug(qt);
        return qt;
    }

    private String getWhereClause(String terms) throws QueryParseException {
        if (terms.indexOf("'") != -1) {
            throw new QueryParseException("Query cannot contain the ' character.");
        }
        StringBuffer whereClause = new StringBuffer();
        if (!terms.equals("*") && !terms.equals("")) {
            whereClause.append(" WHERE");
            int usedCount = 0;
            boolean needsEscape = false;
            for (String column : FieldSearchSQLImpl.DB_COLUMN_NAMES) {
                String qPart;
                boolean use;
                boolean bl = use = column.indexOf("Date") == -1;
                if (!use && column.equals("dcDate")) {
                    use = true;
                }
                if (!use) continue;
                if (usedCount > 0) {
                    whereClause.append(" OR");
                }
                if ((qPart = FieldSearchResultSQLImpl.toSql(column, terms)).charAt(0) == ' ') {
                    needsEscape = true;
                } else {
                    whereClause.append(" ");
                }
                whereClause.append(qPart);
                ++usedCount;
            }
            if (needsEscape) {
                // empty if block
            }
        }
        return whereClause.toString();
    }

    private String getWhereClause(List conditions) throws QueryParseException {
        StringBuffer whereClause = new StringBuffer();
        boolean willJoin = false;
        if (conditions.size() > 0) {
            boolean needsEscape = false;
            whereClause.append(" WHERE");
            for (int i = 0; i < conditions.size(); ++i) {
                String sqlPart;
                Condition cond = (Condition)conditions.get(i);
                if (i > 0) {
                    whereClause.append(" AND");
                }
                String op = cond.getOperator().getSymbol();
                String prop = cond.getProperty();
                if (prop.toLowerCase().endsWith("date")) {
                    Date dt;
                    if (op.equals("~")) {
                        if (prop.equals("date")) {
                            sqlPart = FieldSearchResultSQLImpl.toSql("doFields.dcDate", cond.getValue());
                            if (sqlPart.startsWith(" ")) {
                                needsEscape = true;
                            } else {
                                whereClause.append(' ');
                            }
                            whereClause.append(sqlPart);
                            continue;
                        }
                        throw new QueryParseException("The ~ operator cannot be used with cDate, mDate, or dcmDate because they are not string-valued fields.");
                    }
                    try {
                        dt = DateUtility.parseDateStrict((String)cond.getValue());
                    }
                    catch (ParseException e) {
                        throw new QueryParseException("When using equality or inequality operators with a date-based value, the date must be in yyyy-MM-DD[THH:mm:ss[.SSS][Z]] form.");
                    }
                    if (prop.equals("date")) {
                        if (!willJoin) {
                            willJoin = true;
                            whereClause.insert(0, " LEFT JOIN dcDates ON doFields.pid=dcDates.pid");
                        }
                        whereClause.append(" dcDates.dcDate" + op + dt.getTime());
                        continue;
                    }
                    whereClause.append(" doFields." + prop + op + dt.getTime());
                    continue;
                }
                if (op.equals("=")) {
                    if (FieldSearchResultSQLImpl.isDCProp(prop)) {
                        throw new QueryParseException("The = operator can only be used with dates and non-repeating fields.");
                    }
                    sqlPart = FieldSearchResultSQLImpl.toSql("doFields." + prop, cond.getValue());
                    if (sqlPart.indexOf("LIKE ") != -1) {
                        throw new QueryParseException("The = operator cannot be used with wildcards.");
                    }
                    if (sqlPart.startsWith(" ")) {
                        needsEscape = true;
                    } else {
                        whereClause.append(' ');
                    }
                    whereClause.append(sqlPart);
                    continue;
                }
                if (op.equals("~")) {
                    if (FieldSearchResultSQLImpl.isDCProp(prop)) {
                        prop = "dc" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                    }
                    if ((sqlPart = FieldSearchResultSQLImpl.toSql("doFields." + prop, cond.getValue())).startsWith(" ")) {
                        needsEscape = true;
                    } else {
                        whereClause.append(' ');
                    }
                    whereClause.append(sqlPart);
                    continue;
                }
                throw new QueryParseException("Can't use >, >=, <, or <= operator on a string-based field.");
            }
            if (needsEscape) {
                // empty if block
            }
        }
        return whereClause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExpired() {
        long passedSeconds = (System.currentTimeMillis() - this.m_startMillis) / 1000L;
        this.m_expired = passedSeconds > (long)this.m_maxSeconds;
        logger.debug("has fieldSearchResultSQL expired? " + this.m_expired + ", passed: " + passedSeconds);
        if (this.m_expired) {
            try {
                if (this.m_resultSet != null) {
                    this.m_resultSet.close();
                }
                if (this.m_statement != null) {
                    this.m_statement.close();
                }
                if (this.m_conn != null) {
                    this.m_cPool.free(this.m_conn);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.m_resultSet = null;
                this.m_statement = null;
            }
        }
        return this.m_expired;
    }

    protected void step() throws UnrecognizedFieldException, ObjectIntegrityException, RepositoryConfigurationException, StreamIOException, ServerException {
        block21: {
            this.m_objectFields = new ArrayList();
            int resultCount = 0;
            try {
                while (resultCount < this.m_maxResults && (this.m_nextPID != null || this.m_resultSet.next())) {
                    String pid;
                    ++resultCount;
                    if (this.m_nextPID == null) {
                        pid = this.m_resultSet.getString("pid");
                    } else {
                        pid = this.m_nextPID;
                        this.m_nextPID = null;
                    }
                    this.m_objectFields.add(this.getObjectFields(pid));
                }
                if (resultCount == this.m_maxResults && this.m_resultSet.next()) {
                    this.m_nextPID = this.m_resultSet.getString("pid");
                    long now = System.currentTimeMillis();
                    this.m_token = MD5Utility.getBase16Hash(this.hashCode() + "" + now);
                    this.m_cursor = this.m_nextCursor;
                    this.m_nextCursor += (long)resultCount;
                    this.m_startMillis = now;
                    Date dt = new Date();
                    dt.setTime(this.m_startMillis + (long)(1000 * this.m_maxSeconds));
                    this.m_expirationDate = dt;
                    break block21;
                }
                this.m_token = null;
                try {
                    if (this.m_resultSet != null) {
                        this.m_resultSet.close();
                    }
                    if (this.m_statement != null) {
                        this.m_statement.close();
                    }
                    if (this.m_conn != null) {
                        this.m_cPool.free(this.m_conn);
                    }
                }
                catch (SQLException sqle2) {
                    throw new StorageDeviceException("Error closing statement or result set." + sqle2.getMessage());
                }
                finally {
                    this.m_resultSet = null;
                    this.m_statement = null;
                }
            }
            catch (SQLException sqle) {
                try {
                    try {
                        if (this.m_resultSet != null) {
                            this.m_resultSet.close();
                        }
                        if (this.m_statement != null) {
                            this.m_statement.close();
                        }
                        if (this.m_conn != null) {
                            this.m_cPool.free(this.m_conn);
                        }
                        throw new StorageDeviceException("Error with sql database. " + sqle.getMessage());
                    }
                    catch (SQLException sqle2) {
                        throw new StorageDeviceException("Error closing statement or result set." + sqle.getMessage() + sqle2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    this.m_resultSet = null;
                    this.m_statement = null;
                    throw throwable;
                }
            }
        }
    }

    private ObjectFields getObjectFields(String pid) throws UnrecognizedFieldException, ObjectIntegrityException, RepositoryConfigurationException, StreamIOException, ServerException {
        ObjectFields f;
        DOReader r = this.m_repoReader.getReader(false, ReadOnlyContext.EMPTY, pid);
        Datastream dcmd = null;
        try {
            dcmd = r.GetDatastream("DC", null);
        }
        catch (ClassCastException cce) {
            throw new ObjectIntegrityException("Object " + r.GetObjectPID() + " has a DC datastream, but it's not inline XML.");
        }
        if (dcmd != null) {
            f = new ObjectFields(this.m_resultFields, dcmd.getContentStream());
            for (String element : this.m_resultFields) {
                if (!element.equals("dcmDate")) continue;
                f.setDCMDate(dcmd.DSCreateDT);
            }
        } else {
            f = new ObjectFields();
        }
        for (String n : this.m_resultFields) {
            if (n.equals("pid")) {
                f.setPid(pid);
            }
            if (n.equals("label")) {
                f.setLabel(r.GetObjectLabel());
            }
            if (n.equals("state")) {
                f.setState(r.GetObjectState());
            }
            if (n.equals("ownerId")) {
                f.setOwnerId(r.getOwnerId());
            }
            if (n.equals("cDate")) {
                f.setCDate(r.getCreateDate());
            }
            if (!n.equals("mDate")) continue;
            f.setMDate(r.getLastModDate());
        }
        return f;
    }

    public List objectFieldsList() {
        return this.m_objectFields;
    }

    @Override
    public String getToken() {
        return this.m_token;
    }

    @Override
    public long getCursor() {
        return this.m_cursor;
    }

    @Override
    public long getCompleteListSize() {
        return -1L;
    }

    @Override
    public Date getExpirationDate() {
        return this.m_expirationDate;
    }

    private static String toSql(String name, String in) {
        StringBuffer out;
        if (!name.endsWith("pid")) {
            in = in.toLowerCase();
        }
        if (name.startsWith("dc") || name.startsWith("doFields.dc")) {
            StringBuffer newIn = new StringBuffer();
            if (!in.startsWith("*")) {
                newIn.append("* ");
            }
            newIn.append(in);
            if (!in.endsWith("*")) {
                newIn.append(" *");
            }
            in = newIn.toString();
        }
        if (in.indexOf("\\") != -1) {
            out = new StringBuffer();
            out.append("'");
            boolean needLike = false;
            boolean needEscape = false;
            boolean lastWasEscape = false;
            for (int i = 0; i < in.length(); ++i) {
                char c = in.charAt(i);
                if (!lastWasEscape && c == '\\') {
                    lastWasEscape = true;
                    continue;
                }
                char nextChar = '!';
                boolean useNextChar = false;
                if (!lastWasEscape) {
                    if (c == '?') {
                        out.append('_');
                        needLike = true;
                    } else if (c == '*') {
                        out.append('%');
                        needLike = true;
                    } else {
                        nextChar = c;
                        useNextChar = true;
                    }
                } else {
                    nextChar = c;
                    useNextChar = true;
                }
                if (useNextChar) {
                    if (nextChar == '\"') {
                        out.append("\\\"");
                        needEscape = true;
                    } else if (nextChar == '\'') {
                        out.append("\\'");
                        needEscape = true;
                    } else if (nextChar == '%') {
                        out.append("\\%");
                        needEscape = true;
                    } else if (nextChar == '_') {
                        out.append("\\_");
                        needEscape = true;
                    } else {
                        out.append(nextChar);
                    }
                }
                lastWasEscape = false;
            }
            out.append("'");
            if (needLike) {
                out.insert(0, " LIKE ");
            } else {
                String fixedString = out.toString().replaceAll("\\\\%", "%").replaceAll("\\\\_", "_");
                out = new StringBuffer();
                out.append(fixedString);
                out.insert(0, " = ");
            }
            out.insert(0, name);
            if (needEscape) {
                out.insert(0, ' ');
            }
            return out.toString();
        }
        out = new StringBuffer();
        out.append("'");
        boolean needLike = false;
        boolean needEscape = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '?') {
                out.append('_');
                needLike = true;
                continue;
            }
            if (c == '*') {
                out.append('%');
                needLike = true;
                continue;
            }
            if (c == '\"') {
                out.append("\\\"");
                needEscape = true;
                continue;
            }
            if (c == '\'') {
                out.append("\\'");
                needEscape = true;
                continue;
            }
            if (c == '%') {
                out.append("\\%");
                needEscape = true;
                continue;
            }
            if (c == '_') {
                out.append("\\_");
                needEscape = true;
                continue;
            }
            out.append(c);
        }
        out.append("'");
        if (needLike) {
            out.insert(0, " LIKE ");
        } else {
            String fixedString = out.toString().replaceAll("\\\\%", "%").replaceAll("\\\\_", "_");
            out = new StringBuffer();
            out.append(fixedString);
            out.insert(0, " = ");
        }
        out.insert(0, name);
        if (needEscape) {
            out.insert(0, ' ');
        }
        return out.toString();
    }

    private static final boolean isDCProp(String in) {
        if (in.equals("mDate") || in.equals("dcmDate")) {
            return false;
        }
        for (String n : FieldSearchSQLImpl.DB_COLUMN_NAMES) {
            if (!n.startsWith("dc") || n.toLowerCase().indexOf(in.toLowerCase()) != 2) continue;
            return true;
        }
        return false;
    }

    private static final String dcFixup(String st) {
        String dcFixed = FieldSearchResultSQLImpl.isDCProp(st) ? "dc" + st.substring(0, 1).toUpperCase() + st.substring(1) : st;
        return dcFixed;
    }
}

