/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnrecognizedFieldException;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.server.utilities.DCFields;
import org.fcrepo.utilities.DateUtility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ObjectFields
extends DCFields {
    private String m_pid;
    private String m_label;
    private String m_state;
    private String m_ownerId;
    private Date m_cDate;
    private Date m_mDate;
    private Date m_dcmDate;
    private StringBuffer m_currentContent;
    private final boolean[] m_want = new boolean[26];
    public static final int PID = 0;
    public static final int LABEL = 1;
    public static final int STATE = 4;
    public static final int OWNERID = 5;
    public static final int CDATE = 6;
    public static final int MDATE = 7;
    public static final int TITLE = 8;
    public static final int CREATOR = 9;
    public static final int SUBJECT = 10;
    public static final int DESCRIPTION = 11;
    public static final int PUBLISHER = 12;
    public static final int CONTRIBUTOR = 13;
    public static final int DATE = 14;
    public static final int TYPE = 15;
    public static final int FORMAT = 16;
    public static final int IDENTIFIER = 17;
    public static final int SOURCE = 18;
    public static final int LANGUAGE = 19;
    public static final int RELATION = 20;
    public static final int COVERAGE = 21;
    public static final int RIGHTS = 22;
    public static final int DCMDATE = 23;

    public ObjectFields() {
    }

    public ObjectFields(String[] fieldNames) throws UnrecognizedFieldException {
        for (String s : fieldNames) {
            if (s.equalsIgnoreCase("pid")) {
                this.m_want[0] = true;
                continue;
            }
            if (s.equalsIgnoreCase("label")) {
                this.m_want[1] = true;
                continue;
            }
            if (s.equalsIgnoreCase("state")) {
                this.m_want[4] = true;
                continue;
            }
            if (s.equalsIgnoreCase("ownerId")) {
                this.m_want[5] = true;
                continue;
            }
            if (s.equalsIgnoreCase("cDate")) {
                this.m_want[6] = true;
                continue;
            }
            if (s.equalsIgnoreCase("mDate")) {
                this.m_want[7] = true;
                continue;
            }
            if (s.equalsIgnoreCase("title")) {
                this.m_want[8] = true;
                continue;
            }
            if (s.equalsIgnoreCase("creator")) {
                this.m_want[9] = true;
                continue;
            }
            if (s.equalsIgnoreCase("subject")) {
                this.m_want[10] = true;
                continue;
            }
            if (s.equalsIgnoreCase("description")) {
                this.m_want[11] = true;
                continue;
            }
            if (s.equalsIgnoreCase("publisher")) {
                this.m_want[12] = true;
                continue;
            }
            if (s.equalsIgnoreCase("contributor")) {
                this.m_want[13] = true;
                continue;
            }
            if (s.equalsIgnoreCase("date")) {
                this.m_want[14] = true;
                continue;
            }
            if (s.equalsIgnoreCase("type")) {
                this.m_want[15] = true;
                continue;
            }
            if (s.equalsIgnoreCase("format")) {
                this.m_want[16] = true;
                continue;
            }
            if (s.equalsIgnoreCase("identifier")) {
                this.m_want[17] = true;
                continue;
            }
            if (s.equalsIgnoreCase("source")) {
                this.m_want[18] = true;
                continue;
            }
            if (s.equalsIgnoreCase("language")) {
                this.m_want[19] = true;
                continue;
            }
            if (s.equalsIgnoreCase("relation")) {
                this.m_want[20] = true;
                continue;
            }
            if (s.equalsIgnoreCase("coverage")) {
                this.m_want[21] = true;
                continue;
            }
            if (s.equalsIgnoreCase("rights")) {
                this.m_want[22] = true;
                continue;
            }
            if (s.equalsIgnoreCase("dcmDate")) {
                this.m_want[23] = true;
                continue;
            }
            throw new UnrecognizedFieldException("Unrecognized field: '" + s + "'");
        }
    }

    public ObjectFields(String[] fieldNames, InputStream in) throws UnrecognizedFieldException, RepositoryConfigurationException, ObjectIntegrityException, StreamIOException {
        this(fieldNames);
        SAXParser parser = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            parser = spf.newSAXParser();
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Error getting SAX parser for DC metadata: " + e.getClass().getName() + ": " + e.getMessage());
        }
        try {
            parser.parse(in, (DefaultHandler)this);
        }
        catch (SAXException saxe) {
            throw new ObjectIntegrityException("Parse error parsing ObjectFields: " + saxe.getMessage());
        }
        catch (IOException ioe) {
            throw new StreamIOException("Stream error parsing ObjectFields: " + ioe.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        this.m_currentContent = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.m_currentContent.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.m_want[0] && localName.equals("pid")) {
            this.setPid(this.m_currentContent.toString());
        } else if (this.m_want[1] && localName.equals("label")) {
            this.setLabel(this.m_currentContent.toString());
        } else if (this.m_want[4] && localName.equals("state")) {
            this.setState(this.m_currentContent.toString());
        } else if (this.m_want[5] && localName.equals("ownerId")) {
            this.setOwnerId(this.m_currentContent.toString());
        } else if (this.m_want[6] && localName.equals("cDate")) {
            this.setCDate(DateUtility.convertStringToDate((String)this.m_currentContent.toString()));
        } else if (this.m_want[7] && localName.equals("mDate")) {
            this.setMDate(DateUtility.convertStringToDate((String)this.m_currentContent.toString()));
        } else if (this.m_want[23] && localName.equals("dcmDate")) {
            this.setDCMDate(DateUtility.convertStringToDate((String)this.m_currentContent.toString()));
        } else if (this.m_want[8] && localName.equals("title")) {
            this.titles().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[9] && localName.equals("creator")) {
            this.creators().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[10] && localName.equals("subject")) {
            this.subjects().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[11] && localName.equals("description")) {
            this.descriptions().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[12] && localName.equals("publisher")) {
            this.publishers().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[13] && localName.equals("contributor")) {
            this.contributors().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[14] && localName.equals("date")) {
            this.dates().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[15] && localName.equals("type")) {
            this.types().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[16] && localName.equals("format")) {
            this.formats().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[17] && localName.equals("identifier")) {
            this.identifiers().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[18] && localName.equals("source")) {
            this.sources().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[19] && localName.equals("language")) {
            this.languages().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[20] && localName.equals("relation")) {
            this.relations().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[21] && localName.equals("coverage")) {
            this.coverages().add(new DCField(this.m_currentContent.toString()));
        } else if (this.m_want[22] && localName.equals("rights")) {
            this.rights().add(new DCField(this.m_currentContent.toString()));
        }
    }

    public void setPid(String pid) {
        this.m_pid = pid;
    }

    public String getPid() {
        return this.m_pid;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setState(String state) {
        this.m_state = state;
    }

    public String getState() {
        return this.m_state;
    }

    public void setOwnerId(String ownerId) {
        this.m_ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.m_ownerId;
    }

    public void setCDate(Date cDate) {
        this.m_cDate = cDate;
    }

    public Date getCDate() {
        return this.m_cDate;
    }

    public void setMDate(Date mDate) {
        this.m_mDate = mDate;
    }

    public Date getMDate() {
        return this.m_mDate;
    }

    public void setDCMDate(Date dcmDate) {
        this.m_dcmDate = dcmDate;
    }

    public Date getDCMDate() {
        return this.m_dcmDate;
    }
}

