/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.DateAttribute;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.cond.EvaluationResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeFinderModule
extends com.sun.xacml.finder.AttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(AttributeFinderModule.class);
    private Boolean instantiatedOk = null;
    protected final HashSet attributesDenied = new HashSet();
    private final Hashtable<String, URI> attributeIdUris = new Hashtable();
    private final Hashtable<String, String> attributeTypes = new Hashtable();
    private final Hashtable<String, URI> attributeTypeUris = new Hashtable();
    private static final Set NULLSET = new HashSet();
    private final Set<Integer> supportedDesignatorTypes = new HashSet<Integer>();
    protected final URI STRING_ATTRIBUTE_URI;

    protected AttributeFinderModule() {
        URI temp;
        try {
            temp = new URI("http://www.w3.org/2001/XMLSchema#string");
        }
        catch (URISyntaxException e1) {
            temp = null;
            e1.printStackTrace();
        }
        this.STRING_ATTRIBUTE_URI = temp;
    }

    public final void setInstantiatedOk(boolean value) {
        logger.debug("setInstantiatedOk() " + value);
        if (this.instantiatedOk == null) {
            this.instantiatedOk = new Boolean(value);
        }
    }

    public boolean isDesignatorSupported() {
        logger.debug("isDesignatorSupported() will return " + this.iAm() + " " + (this.instantiatedOk != null && this.instantiatedOk != false));
        return this.instantiatedOk != null && this.instantiatedOk != false;
    }

    private final boolean parmsOk(URI attributeType, URI attributeId, int designatorType) {
        logger.debug("in parmsOk " + this.iAm());
        if (!this.getSupportedDesignatorTypes().contains(new Integer(designatorType))) {
            logger.debug("AttributeFinder:parmsOk" + this.iAm() + " exit on " + "target not supported");
            return false;
        }
        if (attributeType == null) {
            logger.debug("AttributeFinder:parmsOk" + this.iAm() + " exit on " + "null attributeType");
            return false;
        }
        if (attributeId == null) {
            logger.debug("AttributeFinder:parmsOk" + this.iAm() + " exit on " + "null attributeId");
            return false;
        }
        logger.debug("AttributeFinder:parmsOk" + this.iAm() + " looking for " + attributeId.toString());
        this.showRegisteredAttributes();
        if (this.hasAttribute(attributeId.toString())) {
            if (!this.getAttributeType(attributeId.toString()).equals(attributeType.toString())) {
                logger.debug("AttributeFinder:parmsOk" + this.iAm() + " exit on " + "attributeType incorrect for attributeId");
                return false;
            }
        } else if (!"http://www.w3.org/2001/XMLSchema#string".equals(attributeType.toString())) {
            logger.debug("AttributeFinder:parmsOk" + this.iAm() + " exit on " + "attributeType incorrect for attributeId");
            return false;
        }
        logger.debug("exiting parmsOk normally " + this.iAm());
        return true;
    }

    protected String iAm() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected final Object getAttributeFromEvaluationResult(EvaluationResult attribute) {
        if (attribute.indeterminate()) {
            logger.debug("AttributeFinder:getAttributeFromEvaluationCtx" + this.iAm() + " exit on " + "couldn't get resource attribute from xacml request " + "indeterminate");
            return null;
        }
        if (attribute.getStatus() != null && !"urn:oasis:names:tc:xacml:1.0:status:ok".equals(attribute.getStatus())) {
            logger.debug("AttributeFinder:getAttributeFromEvaluationCtx" + this.iAm() + " exit on " + "couldn't get resource attribute from xacml request " + "bad status");
            return null;
        }
        AttributeValue attributeValue = attribute.getAttributeValue();
        if (!(attributeValue instanceof BagAttribute)) {
            logger.debug("AttributeFinder:getAttributeFromEvaluationCtx" + this.iAm() + " exit on " + "couldn't get resource attribute from xacml request " + "no bag");
            return null;
        }
        BagAttribute bag = (BagAttribute)attributeValue;
        if (1 != bag.size()) {
            logger.debug("AttributeFinder:getAttributeFromEvaluationCtx" + this.iAm() + " exit on " + "couldn't get resource attribute from xacml request " + "wrong bag n=" + bag.size());
            return null;
        }
        Iterator it = bag.iterator();
        Object element = it.next();
        if (element == null) {
            logger.debug("AttributeFinder:getAttributeFromEvaluationCtx" + this.iAm() + " exit on " + "couldn't get resource attribute from xacml request " + "null returned");
            return null;
        }
        if (it.hasNext()) {
            logger.debug("AttributeFinder:getAttributeFromEvaluationCtx" + this.iAm() + " exit on " + "couldn't get resource attribute from xacml request " + "too many returned");
            logger.debug(element.toString());
            while (it.hasNext()) {
                logger.debug(it.next().toString());
            }
            return null;
        }
        logger.debug("AttributeFinder:getAttributeFromEvaluationCtx " + this.iAm() + " returning " + element.toString());
        return element;
    }

    protected final void registerAttribute(String id, String type) throws URISyntaxException {
        logger.debug("registering attribute " + this.iAm() + " " + id);
        this.attributeIdUris.put(id, new URI(id));
        this.attributeTypeUris.put(id, new URI(type));
        this.attributeTypes.put(id, type);
    }

    protected final URI getAttributeIdUri(String id) {
        return this.attributeIdUris.get(id);
    }

    protected final boolean hasAttribute(String id) {
        return this.attributeIdUris.containsKey(id);
    }

    private final void showRegisteredAttributes() {
        for (String key : this.attributeIdUris.keySet()) {
            logger.debug("another registered attribute  = " + this.iAm() + " " + key);
        }
    }

    protected final String getAttributeType(String id) {
        return this.attributeTypes.get(id);
    }

    protected final URI getAttributeTypeUri(String id) {
        return this.attributeTypeUris.get(id);
    }

    protected final void registerSupportedDesignatorType(int designatorType) {
        logger.debug("registerSupportedDesignatorType() " + this.iAm());
        this.supportedDesignatorTypes.add(designatorType);
    }

    public Set getSupportedDesignatorTypes() {
        if (this.instantiatedOk != null && this.instantiatedOk.booleanValue()) {
            logger.debug("getSupportedDesignatorTypes() will return " + this.iAm() + " set of elements, n=" + this.supportedDesignatorTypes.size());
            return this.supportedDesignatorTypes;
        }
        logger.debug("getSupportedDesignatorTypes() will return " + this.iAm() + "NULLSET");
        return NULLSET;
    }

    protected abstract boolean canHandleAdhoc();

    private final boolean willService(URI attributeId) {
        String temp = attributeId.toString();
        if (this.hasAttribute(temp)) {
            logger.debug("willService() " + this.iAm() + " accept this known serviced attribute " + attributeId.toString());
            return true;
        }
        if (!this.canHandleAdhoc()) {
            logger.debug("willService() " + this.iAm() + " deny any adhoc attribute " + attributeId.toString());
            return false;
        }
        if (this.attributesDenied.contains(temp)) {
            logger.debug("willService() " + this.iAm() + " deny this known adhoc attribute " + attributeId.toString());
            return false;
        }
        logger.debug("willService() " + this.iAm() + " allow this unknown adhoc attribute " + attributeId.toString());
        return true;
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI category, EvaluationCtx context, int designatorType) {
        HashSet<Object> set;
        block31: {
            Object temp;
            block29: {
                block34: {
                    block33: {
                        block32: {
                            block30: {
                                logger.debug("AttributeFinder:findAttribute {}", (Object)this.iAm());
                                logger.debug("attributeType=[{}], attributeId=[{}] {}", new Object[]{attributeType, attributeId, this.iAm()});
                                if (!this.parmsOk(attributeType, attributeId, designatorType)) {
                                    logger.debug("AttributeFinder:findAttribute exit on parms not ok {}", (Object)this.iAm());
                                    if (attributeType == null) {
                                        try {
                                            attributeType = new URI("http://www.w3.org/2001/XMLSchema#string");
                                        }
                                        catch (URISyntaxException e) {
                                            // empty catch block
                                        }
                                    }
                                    return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
                                }
                                if (!this.willService(attributeId)) {
                                    logger.debug("AttributeFinder:willService() {} returns false", (Object)this.iAm());
                                    return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
                                }
                                if (category != null) {
                                    logger.debug("++++++++++ AttributeFinder:findAttribute {} category={}", (Object)this.iAm(), (Object)category.toString());
                                }
                                logger.debug("++++++++++ AttributeFinder:findAttribute {} designatorType={}", (Object)this.iAm(), (Object)designatorType);
                                logger.debug("about to get temp {}", (Object)this.iAm());
                                temp = this.getAttributeLocally(designatorType, attributeId.toASCIIString(), category, context);
                                logger.debug("{} got temp={}", (Object)this.iAm(), temp);
                                if (temp == null) {
                                    logger.debug("AttributeFinder:findAttribute exit on attribute value not found" + this.iAm());
                                    return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
                                }
                                set = new HashSet<Object>();
                                if (!(temp instanceof String)) break block29;
                                logger.debug("AttributeFinder:findAttribute will return a String {}", (Object)this.iAm());
                                if (!attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#string")) break block30;
                                set.add(new StringAttribute((String)temp));
                                break block31;
                            }
                            if (!attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#dateTime")) break block32;
                            try {
                                DateTimeAttribute tempDateTimeAttribute = DateTimeAttribute.getInstance((String)((String)temp));
                                set.add(tempDateTimeAttribute);
                            }
                            catch (Throwable t) {}
                            break block31;
                        }
                        if (!attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#date")) break block33;
                        try {
                            DateAttribute tempDateAttribute = DateAttribute.getInstance((String)((String)temp));
                            set.add(tempDateAttribute);
                        }
                        catch (Throwable t) {}
                        break block31;
                    }
                    if (!attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#time")) break block34;
                    try {
                        TimeAttribute tempTimeAttribute = TimeAttribute.getInstance((String)((String)temp));
                        set.add(tempTimeAttribute);
                    }
                    catch (Throwable t) {}
                    break block31;
                }
                if (!attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#integer")) break block31;
                try {
                    IntegerAttribute tempIntegerAttribute = IntegerAttribute.getInstance((String)((String)temp));
                    set.add(tempIntegerAttribute);
                }
                catch (Throwable t) {}
                break block31;
            }
            if (temp instanceof String[]) {
                logger.debug("AttributeFinder:findAttribute will return a String[] ", (Object)this.iAm());
                for (int i = 0; i < ((String[])temp).length; ++i) {
                    if (((String[])temp)[i] == null) continue;
                    if (attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        set.add(new StringAttribute(((String[])temp)[i]));
                        continue;
                    }
                    if (attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
                        logger.debug("USING AS DATETIME:{}", (Object)((String[])temp)[i]);
                        try {
                            DateTimeAttribute tempDateTimeAttribute = DateTimeAttribute.getInstance((String)((String[])temp)[i]);
                            set.add(tempDateTimeAttribute);
                        }
                        catch (Throwable t) {}
                        continue;
                    }
                    if (attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#date")) {
                        logger.debug("USING AS DATE:{}", (Object)((String[])temp)[i]);
                        try {
                            DateAttribute tempDateAttribute = DateAttribute.getInstance((String)((String[])temp)[i]);
                            set.add(tempDateAttribute);
                        }
                        catch (Throwable t) {}
                        continue;
                    }
                    if (attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#time")) {
                        logger.debug("USING AS TIME:{}", (Object)((String[])temp)[i]);
                        try {
                            TimeAttribute tempTimeAttribute = TimeAttribute.getInstance((String)((String[])temp)[i]);
                            set.add(tempTimeAttribute);
                        }
                        catch (Throwable t) {}
                        continue;
                    }
                    if (!attributeType.toString().equals("http://www.w3.org/2001/XMLSchema#integer")) continue;
                    logger.debug("USING AS INTEGER: {}", (Object)((String[])temp)[i]);
                    try {
                        IntegerAttribute tempIntegerAttribute = IntegerAttribute.getInstance((String)((String[])temp)[i]);
                        set.add(tempIntegerAttribute);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
        return new EvaluationResult((AttributeValue)new BagAttribute(attributeType, set));
    }

    protected abstract Object getAttributeLocally(int var1, String var2, URI var3, EvaluationCtx var4);
}

