/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.security.BERoleConfig;
import org.fcrepo.server.security.DefaultRoleConfig;
import org.fcrepo.server.security.MethodRoleConfig;
import org.fcrepo.server.security.ServiceDeploymentRoleConfig;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BESecurityConfig
implements Constants {
    private static final String _CONFIG = "serviceSecurityDescription";
    private static final String _INTERNAL_PREFIX = "fedoraInternalCall-";
    private static final String _ROLE = "role";
    private static final String _CALLSSL = "callSSL";
    private static final String _CALLBASICAUTH = "callBasicAuth";
    private static final String _CALLUSERNAME = "callUsername";
    private static final String _CALLPASSWORD = "callPassword";
    private static final String _CALLBACKSSL = "callbackSSL";
    private static final String _CALLBACKBASICAUTH = "callbackBasicAuth";
    private static final String _IPLIST = "iplist";
    private DefaultRoleConfig m_defaultConfig;
    private Boolean m_internalSSL;
    private Boolean m_internalBasicAuth;
    private String m_internalUsername;
    private String m_internalPassword;
    private String[] m_internalIPList;
    private final SortedMap<String, ServiceDeploymentRoleConfig> m_sDepConfigs = new TreeMap<String, ServiceDeploymentRoleConfig>();

    public DefaultRoleConfig getDefaultConfig() {
        return this.m_defaultConfig;
    }

    public void setDefaultConfig(DefaultRoleConfig config) {
        this.m_defaultConfig = config;
    }

    public Boolean getInternalSSL() {
        return this.m_internalSSL;
    }

    public Boolean getEffectiveInternalSSL() {
        if (this.m_internalSSL != null) {
            return this.m_internalSSL;
        }
        if (this.m_defaultConfig != null) {
            return this.m_defaultConfig.getEffectiveCallSSL();
        }
        return Boolean.FALSE;
    }

    public void setInternalSSL(Boolean value) {
        this.m_internalSSL = value;
    }

    public Boolean getInternalBasicAuth() {
        return this.m_internalBasicAuth;
    }

    public Boolean getEffectiveInternalBasicAuth() {
        if (this.m_internalBasicAuth != null) {
            return this.m_internalBasicAuth;
        }
        if (this.m_defaultConfig != null) {
            return this.m_defaultConfig.getEffectiveCallBasicAuth();
        }
        return Boolean.FALSE;
    }

    public void setInternalBasicAuth(Boolean value) {
        this.m_internalBasicAuth = value;
    }

    public String getInternalUsername() {
        return this.m_internalUsername;
    }

    public String getEffectiveInternalUsername() {
        if (this.m_internalUsername != null) {
            return this.m_internalUsername;
        }
        if (this.m_defaultConfig != null) {
            return this.m_defaultConfig.getEffectiveCallUsername();
        }
        return null;
    }

    public void setInternalUsername(String username) {
        this.m_internalUsername = username;
    }

    public String getInternalPassword() {
        return this.m_internalPassword;
    }

    public String getEffectiveInternalPassword() {
        if (this.m_internalPassword != null) {
            return this.m_internalPassword;
        }
        if (this.m_defaultConfig != null) {
            return this.m_defaultConfig.getEffectiveCallPassword();
        }
        return null;
    }

    public void setInternalPassword(String password) {
        this.m_internalPassword = password;
    }

    public String[] getInternalIPList() {
        return this.m_internalIPList;
    }

    public String[] getEffectiveInternalIPList() {
        if (this.m_internalIPList != null) {
            return this.m_internalIPList;
        }
        if (this.m_defaultConfig != null) {
            return this.m_defaultConfig.getEffectiveIPList();
        }
        return null;
    }

    public void setInternalIPList(String[] ips) {
        this.m_internalIPList = ips;
    }

    public SortedMap<String, ServiceDeploymentRoleConfig> getServiceDeploymentConfigs() {
        return this.m_sDepConfigs;
    }

    public void addEmptyConfigs(Map pidToMethodList) {
        for (String sDepPID : pidToMethodList.keySet()) {
            ServiceDeploymentRoleConfig sDepRoleConfig = (ServiceDeploymentRoleConfig)this.m_sDepConfigs.get(sDepPID);
            if (sDepRoleConfig == null) {
                sDepRoleConfig = new ServiceDeploymentRoleConfig(this.m_defaultConfig, sDepPID);
                this.m_sDepConfigs.put(sDepPID, sDepRoleConfig);
            }
            for (String methodName : (List)pidToMethodList.get(sDepPID)) {
                MethodRoleConfig methodRoleConfig = (MethodRoleConfig)sDepRoleConfig.getMethodConfigs().get(methodName);
                if (methodRoleConfig != null) continue;
                methodRoleConfig = new MethodRoleConfig(sDepRoleConfig, methodName);
                sDepRoleConfig.getMethodConfigs().put(methodName, methodRoleConfig);
            }
        }
    }

    public static BESecurityConfig fromStream(InputStream in) throws Exception {
        Element e;
        int i;
        BESecurityConfig config = new BESecurityConfig();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        DefaultRoleConfig defaultRoleConfig = new DefaultRoleConfig();
        BESecurityConfig.setValuesFromElement(defaultRoleConfig, root);
        config.setDefaultConfig(defaultRoleConfig);
        NodeList nodes = root.getElementsByTagName(_CONFIG);
        for (i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String role = e.getAttribute(_ROLE);
            if (role.indexOf(":") != -1 && role.indexOf("/") == -1) {
                ServiceDeploymentRoleConfig sDepRoleConfig = new ServiceDeploymentRoleConfig(defaultRoleConfig, role);
                BESecurityConfig.setValuesFromElement(sDepRoleConfig, e);
                config.getServiceDeploymentConfigs().put(role, sDepRoleConfig);
                continue;
            }
            if (!role.equals("fedoraInternalCall-1")) continue;
            config.setInternalSSL(BESecurityConfig.getBoolean(e, _CALLSSL));
            config.setInternalBasicAuth(BESecurityConfig.getBoolean(e, _CALLBASICAUTH));
            config.setInternalUsername(BESecurityConfig.getString(e, _CALLUSERNAME));
            config.setInternalPassword(BESecurityConfig.getString(e, _CALLPASSWORD));
            config.setInternalIPList(BESecurityConfig.getStringArray(e, _IPLIST));
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String[] parts = e.getAttribute(_ROLE).split("/");
            if (parts.length != 2) continue;
            String sDepPID = parts[0];
            String methodName = parts[1];
            ServiceDeploymentRoleConfig sDepRoleConfig = (ServiceDeploymentRoleConfig)config.getServiceDeploymentConfigs().get(sDepPID);
            if (sDepRoleConfig == null) {
                sDepRoleConfig = new ServiceDeploymentRoleConfig(defaultRoleConfig, sDepPID);
                config.getServiceDeploymentConfigs().put(sDepPID, sDepRoleConfig);
            }
            MethodRoleConfig methodRoleConfig = new MethodRoleConfig(sDepRoleConfig, methodName);
            BESecurityConfig.setValuesFromElement(methodRoleConfig, e);
            sDepRoleConfig.getMethodConfigs().put(methodName, methodRoleConfig);
        }
        return config;
    }

    private static void setValuesFromElement(BERoleConfig roleConfig, Element e) throws Exception {
        roleConfig.setCallSSL(BESecurityConfig.getBoolean(e, _CALLSSL));
        roleConfig.setCallBasicAuth(BESecurityConfig.getBoolean(e, _CALLBASICAUTH));
        roleConfig.setCallUsername(BESecurityConfig.getString(e, _CALLUSERNAME));
        roleConfig.setCallPassword(BESecurityConfig.getString(e, _CALLPASSWORD));
        roleConfig.setCallbackSSL(BESecurityConfig.getBoolean(e, _CALLBACKSSL));
        roleConfig.setCallbackBasicAuth(BESecurityConfig.getBoolean(e, _CALLBACKBASICAUTH));
        roleConfig.setIPList(BESecurityConfig.getStringArray(e, _IPLIST));
    }

    private static String getString(Element e, String name) {
        Attr a = e.getAttributeNode(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    private static Boolean getBoolean(Element e, String name) {
        String s = BESecurityConfig.getString(e, name);
        if (s != null) {
            return new Boolean(s);
        }
        return null;
    }

    private static String[] getStringArray(Element e, String name) {
        String s = BESecurityConfig.getString(e, name);
        if (s != null) {
            String[] array = s.split(" +");
            if (array.length == 1 && array[0].length() == 0) {
                return null;
            }
            return array;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStream(boolean skipNonOverrides, OutputStream out) throws Exception {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
            this.write(skipNonOverrides, true, writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable th) {}
            try {
                out.close();
            }
            catch (Throwable th) {}
        }
    }

    public void write(boolean skipNonOverrides, boolean withXMLDeclaration, PrintWriter writer) {
        String indent = "                           ";
        if (withXMLDeclaration) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        writer.println("<serviceSecurityDescription xmlns=\"" + BESecurityConfig.BE_SECURITY.uri + "\"");
        writer.println("                            xmlns:xsi=\"" + BESecurityConfig.XSI.uri + "\"");
        writer.println("                            xsi:schemaLocation=\"" + BESecurityConfig.BE_SECURITY.uri + " " + BESecurityConfig.BE_SECURITY1_0.xsdLocation + "\"");
        writer.print("                           ");
        BESecurityConfig.write(this.m_defaultConfig, false, skipNonOverrides, writer);
        writer.println(">");
        BESecurityConfig.writeInternalConfig(1, this.m_internalSSL, this.m_internalBasicAuth, this.m_internalUsername, this.m_internalPassword, this.m_internalIPList, writer);
        BESecurityConfig.writeInternalConfig(2, Boolean.FALSE, Boolean.FALSE, null, null, this.m_internalIPList, writer);
        for (String role : this.m_sDepConfigs.keySet()) {
            ServiceDeploymentRoleConfig bConfig = (ServiceDeploymentRoleConfig)this.m_sDepConfigs.get(role);
            BESecurityConfig.write(bConfig, true, skipNonOverrides, writer);
            for (String methodName : bConfig.getMethodConfigs().keySet()) {
                MethodRoleConfig mConfig = (MethodRoleConfig)bConfig.getMethodConfigs().get(methodName);
                BESecurityConfig.write(mConfig, true, skipNonOverrides, writer);
            }
        }
        writer.println("</serviceSecurityDescription>");
    }

    private static void writeInternalConfig(int n, Boolean ssl, Boolean basicAuth, String username, String password, String[] ipList, PrintWriter writer) {
        writer.print("  <serviceSecurityDescription");
        BESecurityConfig.writeAttribute(_ROLE, _INTERNAL_PREFIX + n, writer);
        BESecurityConfig.writeAttribute(_CALLSSL, ssl, writer);
        BESecurityConfig.writeAttribute(_CALLBASICAUTH, basicAuth, writer);
        BESecurityConfig.writeAttribute(_CALLUSERNAME, username, writer);
        BESecurityConfig.writeAttribute(_CALLPASSWORD, password, writer);
        BESecurityConfig.writeAttribute(_CALLBACKSSL, ssl, writer);
        BESecurityConfig.writeAttribute(_CALLBACKBASICAUTH, basicAuth, writer);
        BESecurityConfig.writeAttribute(_IPLIST, ipList, writer);
        writer.println("/>");
    }

    private static void write(BERoleConfig config, boolean wholeElement, boolean skipIfAllNull, PrintWriter writer) {
        if (wholeElement) {
            if (skipIfAllNull && config.getCallSSL() == null && config.getCallBasicAuth() == null && config.getCallUsername() == null && config.getCallPassword() == null && config.getCallbackSSL() == null && config.getCallbackBasicAuth() == null && config.getIPList() == null) {
                return;
            }
            writer.print("  <serviceSecurityDescription");
        }
        BESecurityConfig.writeAttribute(_ROLE, config.getRole(), writer);
        BESecurityConfig.writeAttribute(_CALLSSL, config.getCallSSL(), writer);
        BESecurityConfig.writeAttribute(_CALLBASICAUTH, config.getCallBasicAuth(), writer);
        BESecurityConfig.writeAttribute(_CALLUSERNAME, config.getCallUsername(), writer);
        BESecurityConfig.writeAttribute(_CALLPASSWORD, config.getCallPassword(), writer);
        BESecurityConfig.writeAttribute(_CALLBACKSSL, config.getCallbackSSL(), writer);
        BESecurityConfig.writeAttribute(_CALLBACKBASICAUTH, config.getCallbackBasicAuth(), writer);
        BESecurityConfig.writeAttribute(_IPLIST, config.getIPList(), writer);
        if (wholeElement) {
            writer.println("/>");
        }
    }

    private static void writeAttribute(String name, Object value, PrintWriter writer) {
        if (value != null) {
            String s;
            if (value instanceof String || value instanceof Boolean) {
                s = value.toString();
            } else {
                String[] tokens = (String[])value;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < tokens.length; ++i) {
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(tokens[i]);
                }
                s = buf.toString();
            }
            writer.print(" " + name + "=\"" + s + "\"");
        }
    }
}

