/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.security.BackendSecuritySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BackendSecurityDeserializer
extends DefaultHandler
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(BackendSecurityDeserializer.class);
    public static final String CALL_BASIC_AUTH = "callBasicAuth";
    public static final String CALL_SSL = "callSSL";
    public static final String CALL_USERNAME = "callUsername";
    public static final String CALL_PASSWORD = "callPassword";
    public static final String CALLBACK_BASIC_AUTH = "callbackBasicAuth";
    public static final String CALLBACK_SSL = "callbackSSL";
    public static final String IPLIST = "iplist";
    public static final String ROLE = "role";
    private final BackendSecuritySpec beSS;
    private Hashtable<String, String> beProperties = new Hashtable();
    private final SAXParser tmp_parser;
    private boolean tmp_rootElementFound;
    private int tmp_level;
    private String tmp_parentRole;
    private Hashtable<String, String> tmp_rootProperties;
    private Hashtable<String, String> tmp_serviceProperties;
    private String tmp_role;

    public BackendSecurityDeserializer(String characterEncoding, boolean validate) throws FactoryConfigurationError, ParserConfigurationException, SAXException, UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        buf.append("test");
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(validate);
        spf.setNamespaceAware(true);
        this.tmp_parser = spf.newSAXParser();
        this.beSS = new BackendSecuritySpec();
        this.beProperties = new Hashtable();
    }

    public BackendSecuritySpec deserialize(String inFilePath) throws GeneralException, StreamIOException, UnsupportedEncodingException {
        logger.debug("Parsing beSecurity file...");
        this.tmp_level = 0;
        try {
            FileInputStream fis = new FileInputStream(new File(inFilePath));
            this.tmp_parser.parse((InputStream)fis, (DefaultHandler)this);
        }
        catch (IOException ioe) {
            throw new StreamIOException("BackendSecurityDeserializer: Stream IO problem while parsing backend security config file.");
        }
        catch (SAXException se) {
            throw new GeneralException("BackendSecurityDeserializer: Error parsing backend security config file. " + se.getMessage());
        }
        if (!this.tmp_rootElementFound) {
            throw new GeneralException("BackendSecurityDeserializer: Root element not found in backend security config file.");
        }
        logger.debug("Parse successful.");
        return this.beSS;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        if (uri.equals(BackendSecurityDeserializer.BE_SECURITY.uri) && localName.equals("serviceSecurityDescription")) {
            block6: {
                logger.debug("start element uri=" + uri + " localName=" + localName + " tmp_level=" + this.tmp_level);
                this.tmp_role = BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, ROLE);
                this.beProperties = new Hashtable();
                this.setProperty(CALL_BASIC_AUTH, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, CALL_BASIC_AUTH));
                this.setProperty(CALL_SSL, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, CALL_SSL));
                this.setProperty(CALL_USERNAME, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, CALL_USERNAME));
                this.setProperty(CALL_PASSWORD, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, CALL_PASSWORD));
                this.setProperty(CALLBACK_BASIC_AUTH, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, CALLBACK_BASIC_AUTH));
                this.setProperty(CALLBACK_SSL, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, CALLBACK_SSL));
                this.setProperty(IPLIST, BackendSecurityDeserializer.grab(a, BackendSecurityDeserializer.BE_SECURITY.uri, IPLIST));
                try {
                    if (this.tmp_level == 0) {
                        this.tmp_rootElementFound = true;
                        this.tmp_rootProperties = new Hashtable();
                        this.tmp_rootProperties.putAll(this.beProperties);
                        this.validateProperties();
                        this.beSS.setSecuritySpec("default", null, this.beProperties);
                        break block6;
                    }
                    if (this.tmp_level == 1) {
                        this.tmp_parentRole = this.tmp_role;
                        this.tmp_serviceProperties = new Hashtable();
                        this.tmp_serviceProperties.putAll(this.beProperties);
                        this.inheritProperties(this.tmp_rootProperties);
                        this.validateProperties();
                        this.beSS.setSecuritySpec(this.tmp_role, null, this.beProperties);
                        break block6;
                    }
                    if (this.tmp_level == 2) {
                        this.inheritProperties(this.tmp_serviceProperties);
                        this.inheritProperties(this.tmp_rootProperties);
                        this.validateProperties();
                        this.beSS.setSecuritySpec(this.tmp_parentRole, this.tmp_role, this.beProperties);
                        break block6;
                    }
                    logger.debug("xml element depth exceeded");
                    throw new SAXException("BackendSecurityDeserializer: serviceSecurityDescription elements can only be nested two levels deep from root element!");
                }
                catch (Exception e) {
                    throw new SAXException("BackendSecurityDeserializer: Error setting properties for role " + this.tmp_role + ". " + e.getMessage());
                }
            }
            ++this.tmp_level;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        logger.debug("end element uri=" + uri + " localName=" + localName + " tmp_level=" + this.tmp_level);
        if (uri.equals(BackendSecurityDeserializer.BE_SECURITY.uri) && localName.equals("serviceSecurityDescription")) {
            --this.tmp_level;
        }
    }

    private static String grab(Attributes a, String namespace, String elementName) {
        String ret = a.getValue(namespace, elementName);
        if (ret == null) {
            ret = a.getValue(elementName);
        }
        return ret;
    }

    private void setProperty(String key, String value) {
        if (key != null && value != null) {
            logger.debug("Setting propery.  key=" + key + " value=" + value);
            this.beProperties.put(key, value);
        }
    }

    private void inheritProperties(Hashtable inheritableProperties) {
        logger.debug("Setting inherited properties...");
        for (String key : inheritableProperties.keySet()) {
            if (this.beProperties.containsKey(key)) continue;
            this.setProperty(key, (String)inheritableProperties.get(key));
        }
    }

    private void validateProperties() throws GeneralException {
        logger.debug("Validating properties...");
        if (!this.beProperties.containsKey(CALL_BASIC_AUTH)) {
            this.setProperty(CALL_BASIC_AUTH, "false");
        }
        if (!this.beProperties.containsKey(CALL_SSL)) {
            this.setProperty(CALL_SSL, "false");
        }
        if (!this.beProperties.containsKey(CALLBACK_BASIC_AUTH)) {
            this.setProperty(CALLBACK_BASIC_AUTH, "false");
        }
        if (!this.beProperties.containsKey(CALLBACK_SSL)) {
            this.setProperty(CALLBACK_SSL, "false");
        }
        if (this.beProperties.get(CALL_BASIC_AUTH).equals("true")) {
            if (!this.beProperties.containsKey(CALL_USERNAME)) {
                throw new GeneralException("BackendSecurityDeserializer: callBasicAuth is set to true, but callUsername is missingfor role of " + this.tmp_role);
            }
            if (!this.beProperties.containsKey(CALL_PASSWORD)) {
                throw new GeneralException("BackendSecurityDeserializer: callBasicAuth is set to true, but callPassword is missingfor role of " + this.tmp_role);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        logger.debug("BackendSecurityDeserializer start main()...");
        BackendSecurityDeserializer bds = new BackendSecurityDeserializer("UTF-8", false);
        BackendSecuritySpec beSS = bds.deserialize(args[0]);
        Set<String> allRoleKeys = beSS.listRoleKeys();
        for (String roleKey : allRoleKeys) {
            logger.debug("************ ROLEKEY = " + roleKey);
            Hashtable<String, String> roleProperties = beSS.getSecuritySpec(roleKey);
            for (String propKey : roleProperties.keySet()) {
                String propValue = roleProperties.get(propKey);
                logger.debug(propKey + "=" + propValue);
            }
        }
    }
}

