/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.PolicySet;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.common.FaultException;
import org.fcrepo.server.Server;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.BackendPolicies;
import org.fcrepo.server.security.PolicyLoader;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.validation.ValidationUtility;
import org.fcrepo.utilities.FileUtils;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFinderModule
extends com.sun.xacml.finder.PolicyFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(PolicyFinderModule.class);
    private static final List<String> ERROR_CODE_LIST = new ArrayList<String>(1);
    private static final String DEFAULT = "default";
    private static final String DEFAULT_XACML_COMBINING_ALGORITHM = "com.sun.xacml.combine.OrderedDenyOverridesPolicyAlg";
    private static final String XACML_DIST_BASE = "fedora-internal-use";
    private static final String DEFAULT_REPOSITORY_POLICIES_DIRECTORY = "fedora-internal-use/fedora-internal-use-repository-policies-approximating-2.0";
    private static final String BACKEND_POLICIES_ACTIVE_DIRECTORY = "fedora-internal-use/fedora-internal-use-backend-service-policies";
    private static final String BE_SECURITY_XML_LOCATION = "config/beSecurity.xml";
    private static final String BACKEND_POLICIES_XSL_LOCATION = "fedora-internal-use/build-backend-policy.xsl";
    private static final String COMBINING_ALGORITHM_KEY = "XACML-COMBINING-ALGORITHM";
    private static final String REPOSITORY_POLICIES_DIRECTORY_KEY = "REPOSITORY-POLICIES-DIRECTORY";
    private static final String POLICY_SCHEMA_PATH_KEY = "POLICY-SCHEMA-PATH";
    private static final String VALIDATE_REPOSITORY_POLICIES_KEY = "VALIDATE-REPOSITORY-POLICIES";
    private static final String VALIDATE_OBJECT_POLICIES_FROM_DATASTREAM_KEY = "VALIDATE-OBJECT-POLICIES-FROM-DATASTREAM";
    private final String m_combiningAlgorithm;
    private final String m_serverHome;
    private final String m_repositoryPolicyDirectoryPath;
    private final String m_repositoryBackendPolicyDirectoryPath;
    private final boolean m_validateRepositoryPolicies;
    private final boolean m_validateObjectPoliciesFromDatastream;
    private final PolicyParser m_policyParser;
    private final PolicyLoader m_policyLoader;
    private final List<AbstractPolicy> m_repositoryPolicies;

    public PolicyFinderModule(Server server, PolicyLoader policyLoader, ModuleConfiguration authorizationConfig) throws GeneralException {
        this.m_serverHome = server.getHomeDir().getAbsolutePath();
        this.m_policyLoader = policyLoader;
        Map<String, String> moduleParameters = authorizationConfig.getParameters();
        this.m_repositoryBackendPolicyDirectoryPath = this.m_serverHome + File.separator + BACKEND_POLICIES_ACTIVE_DIRECTORY;
        this.m_repositoryPolicyDirectoryPath = moduleParameters.containsKey(REPOSITORY_POLICIES_DIRECTORY_KEY) ? authorizationConfig.getParameter(REPOSITORY_POLICIES_DIRECTORY_KEY, true) : "";
        this.m_combiningAlgorithm = moduleParameters.containsKey(COMBINING_ALGORITHM_KEY) ? moduleParameters.get(COMBINING_ALGORITHM_KEY) : DEFAULT_XACML_COMBINING_ALGORITHM;
        this.m_validateRepositoryPolicies = moduleParameters.containsKey(VALIDATE_REPOSITORY_POLICIES_KEY) ? new Boolean(moduleParameters.get(VALIDATE_REPOSITORY_POLICIES_KEY)) : false;
        if (moduleParameters.containsKey(VALIDATE_OBJECT_POLICIES_FROM_DATASTREAM_KEY)) {
            try {
                this.m_validateObjectPoliciesFromDatastream = Boolean.parseBoolean(moduleParameters.get(VALIDATE_OBJECT_POLICIES_FROM_DATASTREAM_KEY));
            }
            catch (Exception e) {
                throw new GeneralException("bad init parm boolean value for VALIDATE-OBJECT-POLICIES-FROM-DATASTREAM", e);
            }
        } else {
            this.m_validateObjectPoliciesFromDatastream = false;
        }
        if (moduleParameters.containsKey(POLICY_SCHEMA_PATH_KEY)) {
            String schemaPath = moduleParameters.get(POLICY_SCHEMA_PATH_KEY);
            File schema = schemaPath.startsWith(File.separator) ? new File(schemaPath) : new File(new File(this.m_serverHome), schemaPath);
            try {
                FileInputStream in = new FileInputStream(schema);
                this.m_policyParser = new PolicyParser(in);
                ValidationUtility.setPolicyParser(this.m_policyParser);
            }
            catch (Exception e) {
                throw new GeneralException("Error loading policy schema: " + schema.getAbsolutePath(), e);
            }
        } else {
            throw new GeneralException("Policy schema path not specified.  Must be given as POLICY-SCHEMA-PATH");
        }
        this.m_repositoryPolicies = new ArrayList<AbstractPolicy>();
    }

    public void init(PolicyFinder finder) {
        try {
            logger.info("Loading repository policies...");
            this.setupActivePolicyDirectories();
            this.m_repositoryPolicies.clear();
            Map<String, AbstractPolicy> repositoryPolicies = this.m_policyLoader.loadPolicies(this.m_policyParser, this.m_validateRepositoryPolicies, new File(this.m_repositoryBackendPolicyDirectoryPath));
            repositoryPolicies.putAll(this.m_policyLoader.loadPolicies(this.m_policyParser, this.m_validateRepositoryPolicies, new File(this.m_repositoryPolicyDirectoryPath)));
            this.m_repositoryPolicies.addAll(repositoryPolicies.values());
        }
        catch (Throwable t) {
            logger.error("Error loading repository policies: " + t.toString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateBackendPolicies() throws Exception {
        logger.info("Generating backend policies...");
        FileUtils.deleteContents((File)new File(this.m_repositoryBackendPolicyDirectoryPath));
        BackendPolicies backendPolicies = new BackendPolicies(this.m_serverHome + File.separator + BE_SECURITY_XML_LOCATION);
        Hashtable tempfiles = backendPolicies.generateBackendPolicies();
        TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
        try {
            Iterator iterator = tempfiles.keySet().iterator();
            while (iterator.hasNext()) {
                File f = new File(this.m_serverHome + File.separator + BACKEND_POLICIES_XSL_LOCATION);
                StreamSource ss = new StreamSource(f);
                Transformer transformer = tfactory.newTransformer(ss);
                String key = (String)iterator.next();
                File infile = new File((String)tempfiles.get(key));
                FileInputStream fis = new FileInputStream(infile);
                FileOutputStream fos = new FileOutputStream(this.m_repositoryBackendPolicyDirectoryPath + File.separator + key);
                transformer.transform(new StreamSource(fis), new StreamResult(fos));
            }
        }
        finally {
            Iterator iter = tempfiles.keySet().iterator();
            while (iter.hasNext()) {
                File tempFile = new File((String)tempfiles.get(iter.next()));
                tempFile.delete();
            }
        }
    }

    private void setupActivePolicyDirectories() throws Exception {
        File repoPolicyDir = new File(this.m_repositoryPolicyDirectoryPath + File.separator + DEFAULT);
        if (!repoPolicyDir.exists()) {
            repoPolicyDir.mkdirs();
            File source = new File(this.m_serverHome + File.separator + DEFAULT_REPOSITORY_POLICIES_DIRECTORY);
            FileUtils.copy((File)source, (File)repoPolicyDir);
        }
        this.generateBackendPolicies();
    }

    public boolean isRequestSupported() {
        return true;
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicyFinderResult policyFinderResult = null;
        try {
            AbstractPolicy objectPolicyFromObject;
            ArrayList<AbstractPolicy> policies = new ArrayList<AbstractPolicy>(this.m_repositoryPolicies);
            String pid = PolicyFinderModule.getPid(context);
            if (pid != null && !"".equals(pid) && (objectPolicyFromObject = this.m_policyLoader.loadObjectPolicy(this.m_policyParser.copy(), pid, this.m_validateObjectPoliciesFromDatastream)) != null) {
                policies.add(objectPolicyFromObject);
            }
            PolicyCombiningAlgorithm policyCombiningAlgorithm = (PolicyCombiningAlgorithm)Class.forName(this.m_combiningAlgorithm).newInstance();
            PolicySet policySet = new PolicySet(new URI(""), policyCombiningAlgorithm, null, policies);
            policyFinderResult = new PolicyFinderResult((AbstractPolicy)policySet);
        }
        catch (Exception e) {
            logger.warn("PolicyFinderModule seriously failed to evaluate a policy ", (Throwable)e);
            policyFinderResult = new PolicyFinderResult(new Status(ERROR_CODE_LIST, e.getMessage()));
        }
        return policyFinderResult;
    }

    public static String getPid(EvaluationCtx context) {
        URI resourceIdType = null;
        URI resourceIdId = null;
        try {
            resourceIdType = new URI("http://www.w3.org/2001/XMLSchema#string");
            resourceIdId = new URI(Constants.OBJECT.PID.uri);
        }
        catch (URISyntaxException e) {
            throw new FaultException("Bad URI syntax", (Throwable)e);
        }
        EvaluationResult attribute = context.getResourceAttribute(resourceIdType, resourceIdId, null);
        Object element = PolicyFinderModule.getAttributeFromEvaluationResult(attribute);
        if (element == null) {
            logger.debug("PolicyFinderModule:getPid exit on can't get contextId on request callback");
            return null;
        }
        if (!(element instanceof StringAttribute)) {
            logger.debug("PolicyFinderModule:getPid exit on couldn't get contextId from xacml request non-string returned");
            return null;
        }
        return ((StringAttribute)element).getValue();
    }

    private static final Object getAttributeFromEvaluationResult(EvaluationResult attribute) {
        if (attribute.indeterminate()) {
            return null;
        }
        if (attribute.getStatus() != null && !"urn:oasis:names:tc:xacml:1.0:status:ok".equals(attribute.getStatus())) {
            return null;
        }
        AttributeValue attributeValue = attribute.getAttributeValue();
        if (!(attributeValue instanceof BagAttribute)) {
            return null;
        }
        BagAttribute bag = (BagAttribute)attributeValue;
        if (1 != bag.size()) {
            return null;
        }
        return bag.iterator().next();
    }

    private static List<AbstractPolicy> loadPolicies(PolicyParser parser, boolean validate, File dir) throws IOException, ValidationException {
        ArrayList<AbstractPolicy> policies = new ArrayList<AbstractPolicy>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                policies.addAll(PolicyFinderModule.loadPolicies(parser, validate, file));
                continue;
            }
            if (!file.getName().endsWith(".xml")) continue;
            logger.info("Loading policy: " + file.getPath());
            FileInputStream policyStream = new FileInputStream(file);
            policies.add(parser.parse(policyStream, validate));
        }
        return policies;
    }

    static {
        ERROR_CODE_LIST.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
    }
}

