/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.AbstractPolicy;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PolicyLoader {
    private static final Logger logger = LoggerFactory.getLogger(PolicyLoader.class);
    protected final RepositoryReader m_repoReader;

    public PolicyLoader(RepositoryReader repoReader) {
        this.m_repoReader = repoReader;
    }

    public abstract Map<String, AbstractPolicy> loadPolicies(PolicyParser var1, boolean var2, File var3) throws IOException, ValidationException;

    protected AbstractPolicy loadObjectPolicy(PolicyParser policyParser, String pid, boolean validate) throws ServerException {
        try {
            DOReader reader = this.m_repoReader.getReader(false, ReadOnlyContext.EMPTY, pid);
            Datastream ds = reader.GetDatastream("POLICY", null);
            if (ds != null) {
                logger.debug("Using POLICY for " + pid);
                return policyParser.parse(ds.getContentStream(), validate);
            }
            return null;
        }
        catch (ObjectNotInLowlevelStorageException e) {
            return null;
        }
    }
}

