/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.fcrepo.common.FaultException;
import org.fcrepo.server.errors.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PolicyParser {
    private static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final Schema m_schema;
    private final Validator m_validator;
    private final DocumentBuilder m_domParser;

    public PolicyParser(InputStream schemaStream) throws IOException, SAXException {
        this(PolicyParser.getSchema(schemaStream));
    }

    private PolicyParser(Schema schema) throws SAXException {
        this.m_schema = schema;
        this.m_validator = schema.newValidator();
        this.m_domParser = PolicyParser.createDOMParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema getSchema(InputStream schemaStream) throws SAXException {
        Schema result;
        SchemaFactory schemaFactory = SCHEMA_FACTORY;
        synchronized (schemaFactory) {
            result = SCHEMA_FACTORY.newSchema(new StreamSource(schemaStream));
        }
        return result;
    }

    public PolicyParser copy() {
        try {
            return new PolicyParser(this.m_schema);
        }
        catch (SAXException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    public AbstractPolicy parse(InputStream policyStream, boolean schemaValidate) throws ValidationException {
        Document doc = null;
        try {
            doc = this.m_domParser.parse(policyStream);
        }
        catch (Exception e) {
            throw new ValidationException("Policy invalid; malformed XML", e);
        }
        if (schemaValidate) {
            try {
                this.m_validator.validate(new DOMSource(doc));
            }
            catch (Exception e) {
                throw new ValidationException("Policy invalid; schema validation failed", e);
            }
        }
        Element root = doc.getDocumentElement();
        String rootName = root.getTagName();
        try {
            if (rootName.equals("Policy")) {
                return Policy.getInstance((Node)root);
            }
            if (rootName.equals("PolicySet")) {
                return PolicySet.getInstance((Node)root);
            }
            throw new ValidationException("Policy invalid; root element is " + rootName + ", but should be " + "Policy or PolicySet");
        }
        catch (ParsingException e) {
            throw new ValidationException("Policy invalid; failed parsing by Sun XACML implementation", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder createDOMParser() {
        try {
            DocumentBuilder builder;
            DocumentBuilderFactory documentBuilderFactory = BUILDER_FACTORY;
            synchronized (documentBuilderFactory) {
                builder = BUILDER_FACTORY.newDocumentBuilder();
            }
            builder.setErrorHandler(new ThrowAllErrorHandler());
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new FaultException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            PolicyParser.fail("One argument required: /path/to/xacml-policy-to-validate.xml");
        }
        String schemaPathProperty = "com.sun.xacml.PolicySchema";
        String schemaPath = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaPath == null) {
            PolicyParser.fail("System property com.sun.xacml.PolicySchema (path to XACML schema) must be set. (e.g. -Dcom.sun.xacml.PolicySchema=/path/to/schema)");
        }
        try {
            InputStream instance = PolicyParser.getStream(args[0]);
            PolicyParser parser = new PolicyParser(PolicyParser.getStream(schemaPath));
            parser.parse(instance, true);
            System.out.println("Validation successful");
            System.exit(0);
        }
        catch (ValidationException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                PolicyParser.fail(e.getCause().getMessage());
            } else {
                PolicyParser.fail(e);
            }
        }
        catch (Exception e) {
            PolicyParser.fail(e);
        }
    }

    private static InputStream getStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (Exception e) {
            PolicyParser.fail("File not found: " + path);
            return null;
        }
    }

    private static void fail(String message) {
        System.out.println("ERROR: " + message);
        System.out.println("Validation failed");
        System.exit(1);
    }

    private static void fail(Exception e) {
        e.printStackTrace();
        PolicyParser.fail(e.getClass().getName() + ": See above for detail");
    }

    static {
        BUILDER_FACTORY.setIgnoringComments(true);
        BUILDER_FACTORY.setNamespaceAware(true);
    }

    public static class ThrowAllErrorHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXParseException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXParseException {
            throw e;
        }
    }
}

