/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.fcrepo.common.Constants;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.security.AttributeFinderModule;
import org.fcrepo.server.security.PolicyFinderModule;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceAttributeFinderModule
extends AttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(ResourceAttributeFinderModule.class);
    static final String OWNER_ID_SEPARATOR_CONFIG_KEY = "OWNER-ID-SEPARATOR";
    static final String DEFAULT_OWNER_ID_SEPARATOR = ",";
    private String ownerIdSeparator = ",";
    private static final ResourceAttributeFinderModule singleton = new ResourceAttributeFinderModule();
    private DOManager doManager = null;

    @Override
    protected boolean canHandleAdhoc() {
        return false;
    }

    private ResourceAttributeFinderModule() {
        try {
            this.registerAttribute(Constants.OBJECT.STATE.uri, Constants.OBJECT.STATE.datatype);
            this.registerAttribute(Constants.OBJECT.OBJECT_TYPE.uri, Constants.OBJECT.OBJECT_TYPE.datatype);
            this.registerAttribute(Constants.OBJECT.OWNER.uri, Constants.OBJECT.OWNER.datatype);
            this.registerAttribute(Constants.OBJECT.CREATED_DATETIME.uri, Constants.OBJECT.CREATED_DATETIME.datatype);
            this.registerAttribute(Constants.OBJECT.LAST_MODIFIED_DATETIME.uri, Constants.OBJECT.LAST_MODIFIED_DATETIME.datatype);
            this.registerAttribute(Constants.DATASTREAM.STATE.uri, Constants.DATASTREAM.STATE.datatype);
            this.registerAttribute(Constants.DATASTREAM.CONTROL_GROUP.uri, Constants.DATASTREAM.CONTROL_GROUP.datatype);
            this.registerAttribute(Constants.DATASTREAM.CREATED_DATETIME.uri, Constants.DATASTREAM.CREATED_DATETIME.datatype);
            this.registerAttribute(Constants.DATASTREAM.INFO_TYPE.uri, Constants.DATASTREAM.INFO_TYPE.datatype);
            this.registerAttribute(Constants.DATASTREAM.LOCATION_TYPE.uri, Constants.DATASTREAM.LOCATION_TYPE.datatype);
            this.registerAttribute(Constants.DATASTREAM.MIME_TYPE.uri, Constants.DATASTREAM.MIME_TYPE.datatype);
            this.registerAttribute(Constants.DATASTREAM.CONTENT_LENGTH.uri, Constants.DATASTREAM.CONTENT_LENGTH.datatype);
            this.registerAttribute(Constants.DATASTREAM.FORMAT_URI.uri, Constants.DATASTREAM.FORMAT_URI.datatype);
            this.registerAttribute(Constants.DATASTREAM.LOCATION.uri, Constants.DATASTREAM.LOCATION.datatype);
            this.registerAttribute(Constants.MODEL.HAS_MODEL.uri, "http://www.w3.org/2001/XMLSchema#string");
            this.registerSupportedDesignatorType(1);
            this.setInstantiatedOk(true);
        }
        catch (URISyntaxException e1) {
            this.setInstantiatedOk(false);
        }
    }

    public static final ResourceAttributeFinderModule getInstance() {
        return singleton;
    }

    public void setDOManager(DOManager doManager) {
        if (this.doManager == null) {
            this.doManager = doManager;
        }
    }

    public void setLegacyConfiguration(ModuleConfiguration authorizationConfiguration) {
        Map<String, String> moduleParameters = authorizationConfiguration.getParameters();
        if (moduleParameters.containsKey(OWNER_ID_SEPARATOR_CONFIG_KEY)) {
            this.setOwnerIdSeparator(moduleParameters.get(OWNER_ID_SEPARATOR_CONFIG_KEY));
        }
    }

    public void setOwnerIdSeparator(String ownerIdSeparator) {
        this.ownerIdSeparator = ownerIdSeparator;
        logger.debug("resourceAttributeFinder just set ownerIdSeparator ==[{}]", (Object)this.ownerIdSeparator);
    }

    private final String getDatastreamId(EvaluationCtx context) {
        URI datastreamIdUri = null;
        try {
            datastreamIdUri = new URI(Constants.DATASTREAM.ID.uri);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        EvaluationResult attribute = context.getResourceAttribute(this.STRING_ATTRIBUTE_URI, datastreamIdUri, null);
        Object element = this.getAttributeFromEvaluationResult(attribute);
        if (element == null) {
            logger.debug("getDatastreamId:  exit on can't get resource-id on request callback");
            return null;
        }
        if (!(element instanceof StringAttribute)) {
            logger.debug("getDatastreamId:  exit on couldn't get resource-id from xacml request non-string returned");
            return null;
        }
        String datastreamId = ((StringAttribute)element).getValue();
        if (datastreamId == null) {
            logger.debug("getDatastreamId:  exit on null resource-id");
            return null;
        }
        if (!this.validDatastreamId(datastreamId)) {
            logger.debug("invalid resource-id: datastreamId is not valid");
            return null;
        }
        return datastreamId;
    }

    private final boolean validDatastreamId(String datastreamId) {
        if (datastreamId == null) {
            return false;
        }
        return !" ".equals(datastreamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Object getAttributeLocally(int designatorType, String attributeId, URI resourceCategory, EvaluationCtx context) {
        long getAttributeStartTime = System.currentTimeMillis();
        try {
            String pid = PolicyFinderModule.getPid(context);
            if ("".equals(pid)) {
                logger.debug("no pid");
                Object var8_7 = null;
                return var8_7;
            }
            logger.debug("getResourceAttribute {}, pid={}", (Object)attributeId, (Object)pid);
            DOReader reader = null;
            try {
                logger.debug("pid={}", (Object)pid);
                reader = this.doManager.getReader(false, ReadOnlyContext.EMPTY, pid);
            }
            catch (ServerException e) {
                logger.debug("couldn't get object reader");
                Object var10_12 = null;
                long dur = System.currentTimeMillis() - getAttributeStartTime;
                logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur + "ms.");
                return var10_12;
            }
            String[] values = null;
            if (Constants.OBJECT.STATE.uri.equals(attributeId)) {
                try {
                    values = new String[]{reader.GetObjectState()};
                    logger.debug("got " + Constants.OBJECT.STATE.uri + "=" + values[0]);
                }
                catch (ServerException e) {
                    logger.debug("failed getting " + Constants.OBJECT.STATE.uri, (Throwable)e);
                    Object dur = null;
                    long dur2 = System.currentTimeMillis() - getAttributeStartTime;
                    logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur2 + "ms.");
                    return dur;
                }
            }
            if (Constants.OBJECT.OWNER.uri.equals(attributeId)) {
                try {
                    logger.debug("ResourceAttributeFinder.getAttributeLocally using ownerIdSeparator==[" + this.ownerIdSeparator + "]");
                    String ownerId = reader.getOwnerId();
                    values = ownerId == null ? new String[]{} : reader.getOwnerId().split(this.ownerIdSeparator);
                    String temp = "got " + Constants.OBJECT.OWNER.uri + "=";
                    for (int i = 0; i < values.length; ++i) {
                        temp = temp + " [" + values[i] + "]";
                    }
                    logger.debug(temp);
                }
                catch (ServerException e) {
                    logger.debug("failed getting " + Constants.OBJECT.OWNER.uri, (Throwable)e);
                    Object temp = null;
                    long dur = System.currentTimeMillis() - getAttributeStartTime;
                    logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur + "ms.");
                    return temp;
                }
            }
            if (Constants.MODEL.HAS_MODEL.uri.equals(attributeId)) {
                HashSet<String> models = new HashSet<String>();
                try {
                    models.addAll(reader.getContentModels());
                }
                catch (ServerException e2) {
                    logger.debug("failed getting " + Constants.MODEL.HAS_MODEL.uri, (Throwable)e2);
                    Object dur = null;
                    long dur3 = System.currentTimeMillis() - getAttributeStartTime;
                    logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur3 + "ms.");
                    return dur;
                }
                values = models.toArray(new String[0]);
            } else {
                if (Constants.OBJECT.CREATED_DATETIME.uri.equals(attributeId)) {
                    try {
                        values = new String[]{DateUtility.convertDateToString((Date)reader.getCreateDate())};
                        logger.debug("got " + Constants.OBJECT.CREATED_DATETIME.uri + "=" + values[0]);
                    }
                    catch (ServerException e) {
                        logger.debug("failed getting " + Constants.OBJECT.CREATED_DATETIME.uri);
                        Object e2 = null;
                        long dur = System.currentTimeMillis() - getAttributeStartTime;
                        logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur + "ms.");
                        return e2;
                    }
                }
                if (Constants.OBJECT.LAST_MODIFIED_DATETIME.uri.equals(attributeId)) {
                    try {
                        values = new String[]{DateUtility.convertDateToString((Date)reader.getLastModDate())};
                        logger.debug("got " + Constants.OBJECT.LAST_MODIFIED_DATETIME.uri + "=" + values[0]);
                    }
                    catch (ServerException e) {
                        logger.debug("failed getting " + Constants.OBJECT.LAST_MODIFIED_DATETIME.uri);
                        Object e2 = null;
                        long dur = System.currentTimeMillis() - getAttributeStartTime;
                        logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur + "ms.");
                        return e2;
                    }
                }
                if (Constants.DATASTREAM.STATE.uri.equals(attributeId) || Constants.DATASTREAM.CONTROL_GROUP.uri.equals(attributeId) || Constants.DATASTREAM.FORMAT_URI.uri.equals(attributeId) || Constants.DATASTREAM.CREATED_DATETIME.uri.equals(attributeId) || Constants.DATASTREAM.INFO_TYPE.uri.equals(attributeId) || Constants.DATASTREAM.LOCATION.uri.equals(attributeId) || Constants.DATASTREAM.LOCATION_TYPE.uri.equals(attributeId) || Constants.DATASTREAM.MIME_TYPE.uri.equals(attributeId) || Constants.DATASTREAM.CONTENT_LENGTH.uri.equals(attributeId)) {
                    Datastream datastream;
                    String datastreamId = this.getDatastreamId(context);
                    if ("".equals(datastreamId)) {
                        logger.debug("no datastreamId");
                        Object e2 = null;
                        return e2;
                    }
                    logger.debug("datastreamId=" + datastreamId);
                    try {
                        datastream = reader.GetDatastream(datastreamId, new Date());
                    }
                    catch (ServerException e) {
                        logger.debug("couldn't get datastream");
                        Object dur3 = null;
                        long dur = System.currentTimeMillis() - getAttributeStartTime;
                        logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur + "ms.");
                        return dur3;
                    }
                    if (datastream == null) {
                        logger.debug("got null datastream");
                        Object var12_35 = null;
                        return var12_35;
                    }
                    if (Constants.DATASTREAM.STATE.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSState};
                    } else if (Constants.DATASTREAM.CONTROL_GROUP.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSControlGrp};
                    } else if (Constants.DATASTREAM.FORMAT_URI.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSFormatURI};
                    } else if (Constants.DATASTREAM.CREATED_DATETIME.uri.equals(attributeId)) {
                        values = new String[]{DateUtility.convertDateToString((Date)datastream.DSCreateDT)};
                    } else if (Constants.DATASTREAM.INFO_TYPE.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSInfoType};
                    } else if (Constants.DATASTREAM.LOCATION.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSLocation};
                    } else if (Constants.DATASTREAM.LOCATION_TYPE.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSLocationType};
                    } else if (Constants.DATASTREAM.MIME_TYPE.uri.equals(attributeId)) {
                        values = new String[]{datastream.DSMIME};
                    } else if (Constants.DATASTREAM.CONTENT_LENGTH.uri.equals(attributeId)) {
                        values = new String[]{Long.toString(datastream.DSSize)};
                    } else {
                        logger.debug("looking for unknown resource attribute=" + attributeId);
                    }
                } else {
                    logger.debug("looking for unknown resource attribute=" + attributeId);
                }
            }
            String[] stringArray = values;
            return stringArray;
        }
        finally {
            long dur = System.currentTimeMillis() - getAttributeStartTime;
            logger.debug("Locally getting the '" + attributeId + "' attribute for this resource took " + dur + "ms.");
        }
    }
}

