/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.util.Hashtable;
import java.util.Map;
import org.fcrepo.server.security.servletfilters.CacheElement;
import org.fcrepo.server.security.servletfilters.CacheElementPopulator;
import org.fcrepo.server.security.servletfilters.FilterSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache {
    private static final Logger logger = LoggerFactory.getLogger(Cache.class);
    static boolean firstCall = true;
    private final String cacheId;
    private final String cacheAbbrev;
    private final String CACHE_KEY_SEPARATOR;
    private final String AUTH_SUCCESS_TIMEOUT_UNIT;
    private final int AUTH_SUCCESS_TIMEOUT_DURATION;
    private final String AUTH_FAILURE_TIMEOUT_UNIT;
    private final int AUTH_FAILURE_TIMEOUT_DURATION;
    private final String AUTH_EXCEPTION_TIMEOUT_UNIT;
    private final int AUTH_EXCEPTION_TIMEOUT_DURATION;
    private final CacheElementPopulator cacheElementPopulator;
    private final Map cache = new Hashtable();

    public final String getCacheId() {
        return this.cacheId;
    }

    public final String getCacheAbbrev() {
        return this.cacheAbbrev;
    }

    public final String getCacheKeySeparator() {
        return this.CACHE_KEY_SEPARATOR;
    }

    public final String getAuthSuccessTimeoutUnit() {
        return this.AUTH_SUCCESS_TIMEOUT_UNIT;
    }

    public final int getAuthSuccessTimeoutDuration() {
        return this.AUTH_SUCCESS_TIMEOUT_DURATION;
    }

    public final String getAuthFailureTimeoutUnit() {
        return this.AUTH_FAILURE_TIMEOUT_UNIT;
    }

    public final int getAuthFailureTimeoutDuration() {
        return this.AUTH_FAILURE_TIMEOUT_DURATION;
    }

    public final String getAuthExceptionTimeoutUnit() {
        return this.AUTH_EXCEPTION_TIMEOUT_UNIT;
    }

    public final int getAuthExceptionTimeoutDuration() {
        return this.AUTH_EXCEPTION_TIMEOUT_DURATION;
    }

    public final CacheElementPopulator getCacheElementPopulator() {
        return this.cacheElementPopulator;
    }

    public Cache(String cacheId, String CACHE_KEY_SEPARATOR, String AUTH_SUCCESS_TIMEOUT_UNIT, int AUTH_SUCCESS_TIMEOUT_DURATION, String AUTH_FAILURE_TIMEOUT_UNIT, int AUTH_FAILURE_TIMEOUT_DURATION, String AUTH_EXCEPTION_TIMEOUT_UNIT, int AUTH_EXCEPTION_TIMEOUT_DURATION, CacheElementPopulator cacheElementPopulator) {
        this.cacheId = cacheId;
        this.CACHE_KEY_SEPARATOR = CACHE_KEY_SEPARATOR;
        this.AUTH_SUCCESS_TIMEOUT_UNIT = AUTH_SUCCESS_TIMEOUT_UNIT;
        this.AUTH_SUCCESS_TIMEOUT_DURATION = AUTH_SUCCESS_TIMEOUT_DURATION;
        this.AUTH_FAILURE_TIMEOUT_UNIT = AUTH_FAILURE_TIMEOUT_UNIT;
        this.AUTH_FAILURE_TIMEOUT_DURATION = AUTH_FAILURE_TIMEOUT_DURATION;
        this.AUTH_EXCEPTION_TIMEOUT_UNIT = AUTH_EXCEPTION_TIMEOUT_UNIT;
        this.AUTH_EXCEPTION_TIMEOUT_DURATION = AUTH_EXCEPTION_TIMEOUT_DURATION;
        this.cacheElementPopulator = cacheElementPopulator;
        this.cacheAbbrev = FilterSetup.getFilterNameAbbrev(this.getCacheId());
    }

    public final void audit(String userid) {
        String m = this.getCacheAbbrev() + " audit() ";
        String key = Cache.getKey(userid);
        CacheElement cacheElement = this.getCacheElement(userid);
        if (cacheElement == null) {
            logger.debug(m + "cache element is null for " + userid);
        } else {
            cacheElement.audit();
        }
    }

    private static final String getKey(String userid) {
        return userid;
    }

    private final synchronized CacheElement getCacheElement(String userid) {
        String m = this.getCacheAbbrev() + " getCacheElement() ";
        CacheElement cacheElement = null;
        String keytemp = Cache.getKey(userid);
        Integer key = new Integer(keytemp.hashCode());
        logger.debug(m + "keytemp==" + keytemp);
        logger.debug(m + "key==" + key);
        if (this.cache.containsKey(key)) {
            logger.debug(m + "cache already has element");
        } else {
            logger.debug(m + "cache does not have element; create and put");
            CacheElement itemtemp = new CacheElement(userid, this.getCacheId(), this.getCacheAbbrev());
            this.cache.put(key, itemtemp);
        }
        cacheElement = (CacheElement)this.cache.get(key);
        if (cacheElement == null) {
            logger.error(m + "cache does not contain element");
        } else {
            logger.debug(m + "element retrieved from cache successfully");
        }
        return cacheElement;
    }

    public static final void testAssert() {
        try {
            assert (false);
            logger.debug("asserts are not turned on");
        }
        catch (Throwable t) {
            logger.debug("asserts are turned on");
        }
    }

    public final Boolean authenticate(CacheElementPopulator authenticator, String userid, String password) throws Throwable {
        if (firstCall) {
            Cache.testAssert();
            firstCall = false;
        }
        String m = this.getCacheAbbrev() + " authenticate() ";
        if (logger.isDebugEnabled()) {
            logger.debug(m + "----------------------------------------------");
            logger.debug(m + "> " + this.getCacheId() + " [" + userid + "] [" + password + "]");
        } else {
            logger.info("Authenticating user [" + userid + "]");
        }
        CacheElement cacheElement = this.getCacheElement(userid);
        logger.debug(m + "cacheElement==" + cacheElement.getInstanceId());
        Boolean authenticated = null;
        try {
            authenticated = cacheElement.authenticate(this, password);
        }
        catch (Throwable t) {
            logger.error("Error authenticating", t);
            throw t;
        }
        logger.debug(m + "< " + authenticated);
        return authenticated;
    }

    public final Map getNamedValues(CacheElementPopulator authenticator, String userid, String password) throws Throwable {
        if (firstCall) {
            Cache.testAssert();
            firstCall = false;
        }
        String m = this.getCacheAbbrev() + " getNamedValues() ";
        if (logger.isDebugEnabled()) {
            logger.debug(m + "----------------------------------------------");
            logger.debug(m + "> " + this.getCacheId() + " [" + userid + "] [" + password + "]");
        }
        CacheElement cacheElement = this.getCacheElement(userid);
        logger.debug(m + "cacheElement==" + cacheElement.getInstanceId());
        Map namedValues = null;
        try {
            namedValues = cacheElement.getNamedValues(this, password);
        }
        catch (Throwable t) {
            logger.error("Error getting named values", t);
            throw t;
        }
        logger.debug(m + "< " + namedValues);
        return namedValues;
    }
}

