/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters.pubcookie;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;

public class ConnectPubcookie {
    private static final Logger logger = LoggerFactory.getLogger(ConnectPubcookie.class);
    private boolean completedFully = false;
    private Node responseDocument = null;
    private Cookie[] responseCookies = null;
    Header[] responseCookies2 = null;

    public final boolean completedFully() {
        return this.completedFully;
    }

    public final Node getResponseDocument() {
        return this.responseDocument;
    }

    public final Cookie[] getResponseCookies() {
        logger.debug(this.getClass().getName() + ".getResponseCookies() " + "cookies are:");
        for (Cookie element : this.responseCookies) {
            logger.debug(this.getClass().getName() + ".getResponseCookies() " + "cookie==" + element);
        }
        return this.responseCookies;
    }

    private static final HttpMethodBase setup(HttpClient client, URL url, Map requestParameters, Cookie[] requestCookies) {
        logger.debug("Entered setup()");
        GetMethod method = null;
        if (requestParameters == null) {
            logger.debug("Using GetMethod; requestParameters == null");
            method = new GetMethod(url.toExternalForm());
        } else {
            logger.debug("Using PostMethod; requestParameters specified");
            method = new PostMethod(url.toExternalForm());
            Part[] parts = new Part[requestParameters.size()];
            Iterator iterator = requestParameters.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                String fieldValue = (String)requestParameters.get(fieldName);
                StringPart stringPart = new StringPart(fieldName, fieldValue);
                parts[i] = stringPart;
                logger.debug("Adding Post parameter {} = {}", (Object)fieldName, (Object)fieldValue);
                ((PostMethod)method).addParameter(fieldName, fieldValue);
                ++i;
            }
        }
        HttpState state = client.getState();
        for (Cookie cookie : requestCookies) {
            state.addCookie(cookie);
        }
        return method;
    }

    public final void connect(String urlString, Map requestParameters, Cookie[] requestCookies, String truststoreLocation, String truststorePassword) {
        String redirectString;
        Header redirectHeader;
        if (logger.isDebugEnabled()) {
            logger.debug("Entered .connect()  url==" + urlString + " requestParameters==" + requestParameters + " requestCookies==" + requestCookies);
        }
        this.responseCookies2 = null;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException mue) {
            logger.error("Malformed url: " + urlString, (Throwable)mue);
        }
        if (urlString.startsWith("https:") && null != truststoreLocation && !"".equals(truststoreLocation) && null != truststorePassword && !"".equals(truststorePassword)) {
            logger.debug("setting javax.net.ssl.trustStore to " + truststoreLocation);
            System.setProperty("javax.net.ssl.trustStore", truststoreLocation);
            logger.debug("setting javax.net.ssl.trustStorePassword to " + truststorePassword);
            System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);
            logger.debug("setting javax.net.ssl.keyStore to " + truststoreLocation);
            System.setProperty("javax.net.ssl.keyStore", truststoreLocation);
            logger.debug("setting javax.net.ssl.keyStorePassword to " + truststorePassword);
            System.setProperty("javax.net.ssl.keyStorePassword", truststorePassword);
            System.setProperty("javax.net.debug", "ssl,handshake,data,trustmanager");
        } else {
            logger.debug("DIAGNOSTIC urlString==" + urlString);
            logger.debug("didn't set javax.net.ssl.trustStore to " + truststoreLocation);
            logger.debug("didn't set javax.net.ssl.trustStorePassword to " + truststorePassword);
        }
        HttpClient client = new HttpClient();
        logger.debug(".connect() requestCookies==" + requestCookies);
        HttpMethodBase method = ConnectPubcookie.setup(client, url, requestParameters, requestCookies);
        int statusCode = 0;
        try {
            client.executeMethod((HttpMethod)method);
            statusCode = method.getStatusCode();
        }
        catch (Exception e) {
            logger.error("failed original connect, url==" + urlString, (Throwable)e);
        }
        logger.debug("status code==" + statusCode);
        if (302 == statusCode && (redirectHeader = method.getResponseHeader("Location")) != null && (redirectString = redirectHeader.getValue()) != null) {
            URL redirectURL = null;
            try {
                redirectURL = new URL(redirectString);
                method = ConnectPubcookie.setup(client, redirectURL, requestParameters, requestCookies);
            }
            catch (MalformedURLException mue) {
                logger.error(".connect() malformed redirect url: " + urlString);
            }
            statusCode = 0;
            try {
                client.executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
                logger.debug(".connect() (on redirect) statusCode==" + statusCode);
            }
            catch (Exception e) {
                logger.error(".connect() failed redirect connect");
            }
        }
        if (statusCode == 200) {
            block22: {
                String content = null;
                try {
                    content = method.getResponseBodyAsString();
                }
                catch (IOException e) {
                    logger.error("Error getting content", (Throwable)e);
                    return;
                }
                if (content == null) {
                    logger.error("Content is null");
                    return;
                }
                Tidy tidy = null;
                try {
                    tidy = new Tidy();
                }
                catch (Throwable t) {
                    logger.error("Error creating Tidy instance?!", t);
                }
                byte[] inputBytes = content.getBytes();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBytes);
                this.responseDocument = tidy.parseDOM((InputStream)inputStream, null);
                HttpState state = client.getState();
                try {
                    this.responseCookies2 = method.getRequestHeaders();
                    if (logger.isDebugEnabled()) {
                        for (Header element : this.responseCookies2) {
                            logger.debug("Header: {}={}", (Object)element.getName(), (Object)element.getValue());
                        }
                    }
                    this.responseCookies = state.getCookies();
                    logger.debug(this.getClass().getName() + ".connect() responseCookies==" + this.responseCookies);
                }
                catch (Throwable t) {
                    logger.error(this.getClass().getName() + ".connect() exception==" + t.getMessage());
                    if (t.getCause() == null) break block22;
                    logger.error(this.getClass().getName() + ".connect() cause==" + t.getCause().getMessage());
                }
            }
            this.completedFully = true;
            logger.debug(this.getClass().getName() + ".connect() completedFully==" + this.completedFully);
        }
    }
}

