/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters.xmluserfile;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.fcrepo.common.Constants;
import org.fcrepo.server.security.servletfilters.xmluserfile.Role;
import org.fcrepo.server.security.servletfilters.xmluserfile.User;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FedoraUsers
implements Serializable,
Constants {
    private static final long serialVersionUID = 1L;
    private static final String BETWIXT_MAPPING = "/org/fcrepo/server/security/servletfilters/xmluserfile/fedorausers-mapping.xml";
    private final List<Role> roles = new ArrayList<Role>();
    private final List<User> users = new ArrayList<User>();
    public static File fedoraUsersXML = FedoraUsers.getFedoraUsersXML();

    private static File getFedoraUsersXML() {
        String homeConfig = FEDORA_HOME + File.separator + "server" + File.separator + "config" + File.separator + "fedora-users.xml";
        String testConfig = "src/main/resources/fcfg/server/fedora-users.xml";
        fedoraUsersXML = new File(homeConfig);
        if (!fedoraUsersXML.exists()) {
            fedoraUsersXML = new File(testConfig);
        }
        return fedoraUsersXML;
    }

    public static FedoraUsers getInstance() {
        return FedoraUsers.getInstance(fedoraUsersXML.toURI());
    }

    public static FedoraUsers getInstance(URI fedoraUsersXML) {
        FedoraUsers fu = null;
        BeanReader reader = new BeanReader();
        reader.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        reader.getBindingConfiguration().setMapIDs(false);
        try {
            reader.registerMultiMapping(FedoraUsers.getBetwixtMapping());
            fu = (FedoraUsers)reader.parse(fedoraUsersXML.toString());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return fu;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void addRole(Role role) {
        this.roles.add(role);
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void write(Writer outputWriter) throws IOException {
        outputWriter.write("<?xml version='1.0' ?>\n");
        BeanWriter beanWriter = new BeanWriter(outputWriter);
        beanWriter.getBindingConfiguration().setMapIDs(false);
        beanWriter.setWriteEmptyElements(false);
        beanWriter.enablePrettyPrint();
        try {
            beanWriter.getXMLIntrospector().register(FedoraUsers.getBetwixtMapping());
            beanWriter.write("users", (Object)this);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        beanWriter.flush();
        beanWriter.close();
    }

    private static InputSource getBetwixtMapping() {
        return new InputSource(FedoraUsers.class.getResourceAsStream(BETWIXT_MAPPING));
    }
}

