/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.fcrepo.server.utilities.DDLConverter;
import org.fcrepo.server.utilities.TableCreatingConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private DDLConverter ddlConverter;
    private BasicDataSource dataSource;
    private boolean supportsReadOnly = true;

    public ConnectionPool(String driver, String url, String username, String password, int maxActive, int maxIdle, long maxWait, int minIdle, long minEvictableIdleTimeMillis, int numTestsPerEvictionRun, long timeBetweenEvictionRunsMillis, String validationQuery, boolean testOnBorrow, boolean testOnReturn, boolean testWhileIdle, byte whenExhaustedAction) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("JDBC class not found: " + driver + "; make sure " + "the JDBC driver is in the classpath");
        }
        Properties props = new Properties();
        props.setProperty("url", url);
        props.setProperty("username", username);
        props.setProperty("password", password);
        props.setProperty("maxActive", "" + maxActive);
        props.setProperty("maxIdle", "" + maxIdle);
        props.setProperty("maxWait", "" + maxWait);
        props.setProperty("minIdle", "" + minIdle);
        props.setProperty("minEvictableIdleTimeMillis", "" + minEvictableIdleTimeMillis);
        props.setProperty("numTestsPerEvictionRun", "" + numTestsPerEvictionRun);
        props.setProperty("timeBetweenEvictionRunsMillis", "" + timeBetweenEvictionRunsMillis);
        if (validationQuery != null && validationQuery.length() > 0) {
            props.setProperty("validationQuery", validationQuery);
        }
        props.setProperty("testOnBorrow", "" + testOnBorrow);
        props.setProperty("testOnReturn", "" + testOnReturn);
        props.setProperty("testWhileIdle", "" + testWhileIdle);
        if (whenExhaustedAction == 0) {
            props.setProperty("maxWait", "0");
        } else if (whenExhaustedAction == 1) {
            props.setProperty("maxWait", "-1");
        } else if (whenExhaustedAction == 2) {
            props.setProperty("maxActive", "-1");
        }
        try {
            this.dataSource = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)props);
            this.dataSource.setDriverClassName(driver);
        }
        catch (Exception e) {
            throw new SQLException("Error initializing connection pool", e);
        }
    }

    protected void setConnectionProperties(Map<String, String> props) {
        for (String name : props.keySet()) {
            this.dataSource.addConnectionProperty(name, props.get(name));
        }
    }

    public ConnectionPool(String driver, String url, String username, String password, DDLConverter ddlConverter, int maxActive, int maxIdle, long maxWait, int minIdle, long minEvictableIdleTimeMillis, int numTestsPerEvictionRun, long timeBetweenEvictionRunsMillis, String validationQuery, boolean testOnBorrow, boolean testOnReturn, boolean testWhileIdle, byte whenExhaustedAction) throws SQLException {
        this(driver, url, username, password, maxActive, maxIdle, maxWait, minIdle, minEvictableIdleTimeMillis, numTestsPerEvictionRun, timeBetweenEvictionRunsMillis, validationQuery, testOnBorrow, testOnReturn, testWhileIdle, whenExhaustedAction);
        this.ddlConverter = ddlConverter;
    }

    public TableCreatingConnection getTableCreatingConnection() throws SQLException {
        if (this.ddlConverter == null) {
            return null;
        }
        Connection c = this.getReadWriteConnection();
        return new TableCreatingConnection(c, this.ddlConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getReadOnlyConnection() throws SQLException {
        try {
            Connection conn = this.dataSource.getConnection();
            this.setConnectionReadOnly(conn, true);
            Connection connection = conn;
            return connection;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Got connection from pool (" + this.toString() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getReadWriteConnection() throws SQLException {
        try {
            Connection conn = this.dataSource.getConnection();
            this.setConnectionReadOnly(conn, false);
            Connection connection = conn;
            return connection;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Got connection from pool (" + this.toString() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Connection connection) {
        try {
            this.setConnectionReadOnly(connection, true);
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sqle) {
            logger.warn("Unable to close connection", (Throwable)sqle);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Returned connection to pool (" + this.toString() + ")");
            }
        }
    }

    public String toString() {
        return this.dataSource.getUsername() + "@" + this.dataSource.getUrl() + ", numIdle=" + this.dataSource.getNumIdle() + ", numActive=" + this.dataSource.getNumActive() + ", maxActive=" + this.dataSource.getMaxActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            String username = this.dataSource.getUsername();
            String password = this.dataSource.getPassword();
            this.dataSource.close();
            if (this.isEmbeddedDB()) {
                this.shutdownEmbeddedDB(username, password);
            }
        }
        catch (SQLException sqle) {
            logger.warn("Unable to close pool", (Throwable)sqle);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Closed pool (" + this.toString() + ")");
            }
        }
    }

    private void setConnectionReadOnly(Connection connection, boolean readOnly) {
        if (this.supportsReadOnly) {
            try {
                connection.setReadOnly(readOnly);
            }
            catch (Throwable th) {
                logger.info("Read-only connections not supported (" + th.getMessage() + ")");
                this.supportsReadOnly = false;
            }
        }
    }

    private boolean isEmbeddedDB() {
        return this.dataSource.getDriverClassName().equals(EmbeddedDriver.class.getName());
    }

    private void shutdownEmbeddedDB(String username, String password) {
        block2: {
            logger.info("Shutting down embedded derby database.");
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true", username, password);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("XJ015")) break block2;
                logger.error("Embedded Derby DB did not shut down normally.");
            }
        }
    }
}

