/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.fcrepo.server.DatastoreConfig;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ConnectionPoolNotFoundException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.fcrepo.server.utilities.DDLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolManagerImpl
extends Module
implements ConnectionPoolManager {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolManagerImpl.class);
    private static Hashtable<String, ConnectionPool> h_ConnectionPools = new Hashtable();
    private static String defaultPoolName = null;
    private String jdbcDriverClass = null;
    private String dbUsername = null;
    private String dbPassword = null;
    private String jdbcURL = null;
    private int maxActive = 0;
    private int maxIdle = 0;
    private long maxWait = 0L;
    private long minEvictableIdleTimeMillis = 0L;
    private int minIdle = 0;
    private int numTestsPerEvictionRun = 0;
    private String validationQuery;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    private long timeBetweenEvictionRunsMillis = 0L;
    private byte whenExhaustedAction = 0;

    public ConnectionPoolManagerImpl(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        try {
            Server s_server = this.getServer();
            defaultPoolName = this.getParameter("defaultPoolName");
            if (defaultPoolName == null || defaultPoolName.equalsIgnoreCase("")) {
                throw new ModuleInitializationException("Default Connection Pool Name Not Specified", this.getRole());
            }
            logger.debug("DefaultPoolName: " + defaultPoolName);
            String poolList = this.getParameter("poolNames");
            String[] poolNames = poolList.split(",");
            for (int i = 0; i < poolNames.length; ++i) {
                DatastoreConfig config = s_server.getDatastoreConfig(poolNames[i]);
                this.jdbcDriverClass = config.getParameter("jdbcDriverClass");
                this.dbUsername = config.getParameter("dbUsername");
                this.dbPassword = config.getParameter("dbPassword");
                this.jdbcURL = config.getParameter("jdbcURL");
                this.maxActive = new Integer(config.getParameter("maxActive"));
                this.maxIdle = new Integer(config.getParameter("maxIdle"));
                this.maxWait = new Integer(config.getParameter("maxWait")).intValue();
                this.minIdle = new Integer(config.getParameter("minIdle"));
                this.numTestsPerEvictionRun = new Integer(config.getParameter("numTestsPerEvictionRun"));
                this.minEvictableIdleTimeMillis = new Long(config.getParameter("minEvictableIdleTimeMillis"));
                this.timeBetweenEvictionRunsMillis = new Long(config.getParameter("timeBetweenEvictionRunsMillis"));
                this.validationQuery = config.getParameter("validationQuery");
                this.testOnBorrow = new Boolean(config.getParameter("testOnBorrow"));
                this.testOnReturn = new Boolean(config.getParameter("testOnReturn"));
                this.testWhileIdle = new Boolean(config.getParameter("testWhileIdle"));
                this.whenExhaustedAction = new Byte(config.getParameter("whenExhaustedAction"));
                if (this.whenExhaustedAction != 0 && this.whenExhaustedAction != 1 && this.whenExhaustedAction != 2) {
                    logger.debug("Valid values for whenExhaustedAction are: 0 - (fail), 1 - (block), or 2 - (grow)");
                    throw new ModuleInitializationException("A connection pool could not be instantiated. The underlying error was an invalid value for the whenExhaustedAction parameter.Valid values are 0 - (fail), 1 - (block), or 2 - (grow). Value specifiedwas \"" + this.whenExhaustedAction + "\".", this.getRole());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("poolName[" + i + "] = " + poolNames[i]);
                    logger.debug("JDBC driver: " + this.jdbcDriverClass);
                    logger.debug("Database username: " + this.dbUsername);
                    logger.debug("Database password: " + this.dbPassword);
                    logger.debug("JDBC connection URL: " + this.jdbcURL);
                    logger.debug("Maximum active connections: " + this.maxActive);
                    logger.debug("Maximum idle connections: " + this.maxIdle);
                    logger.debug("Maximum wait time: " + this.maxWait);
                    logger.debug("Minimum idle time: " + this.minIdle);
                    logger.debug("Number of tests per eviction run: " + this.numTestsPerEvictionRun);
                    logger.debug("Minimum Evictable Idle time: " + this.minEvictableIdleTimeMillis);
                    logger.debug("Minimum Evictable Idle time: " + this.timeBetweenEvictionRunsMillis);
                    logger.debug("Validation query: " + this.validationQuery);
                    logger.debug("Test on borrow: " + this.testOnBorrow);
                    logger.debug("Test on return: " + this.testOnReturn);
                    logger.debug("Test while idle: " + this.testWhileIdle);
                    logger.debug("whenExhaustedAction: " + this.whenExhaustedAction);
                }
                HashMap<String, String> cProps = new HashMap<String, String>();
                for (String name : config.getParameters().keySet()) {
                    if (!name.startsWith("connection.")) continue;
                    String realName = name.substring(11);
                    logger.debug("Connection property " + realName + " = " + config.getParameter(name));
                    cProps.put(realName, config.getParameter(name));
                }
                DDLConverter ddlConverter = null;
                String ddlConverterClassName = this.getServer().getDatastoreConfig(poolNames[i]).getParameter("ddlConverter");
                if (ddlConverterClassName != null) {
                    try {
                        ddlConverter = (DDLConverter)Class.forName(ddlConverterClassName).newInstance();
                    }
                    catch (Throwable th) {
                        throw new ModuleInitializationException("A DDLConverter was specified for the pool \"" + poolNames[i] + "\", but it couldn't be instantiated.", this.getRole(), th);
                    }
                }
                try {
                    ConnectionPool connectionPool = new ConnectionPool(this.jdbcDriverClass, this.jdbcURL, this.dbUsername, this.dbPassword, ddlConverter, this.maxActive, this.maxIdle, this.maxWait, this.minIdle, this.minEvictableIdleTimeMillis, this.numTestsPerEvictionRun, this.timeBetweenEvictionRunsMillis, this.validationQuery, this.testOnBorrow, this.testOnReturn, this.testWhileIdle, this.whenExhaustedAction);
                    connectionPool.setConnectionProperties(cProps);
                    logger.debug("Initialized Pool: " + connectionPool);
                    h_ConnectionPools.put(poolNames[i], connectionPool);
                    logger.debug("putPoolInHash: " + h_ConnectionPools.size());
                    continue;
                }
                catch (SQLException sqle) {
                    logger.error("Unable to initialize connection pool: " + poolNames[i] + ": " + sqle.getMessage());
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new ModuleInitializationException("A connection pool could not be instantiated. The underlying error was a " + th.getClass().getName() + "The message was \"" + th.getMessage() + "\".", this.getRole());
        }
    }

    @Override
    public ConnectionPool getPool(String poolName) throws ConnectionPoolNotFoundException {
        ConnectionPool connectionPool = null;
        try {
            if (!h_ConnectionPools.containsKey(poolName)) {
                throw new ConnectionPoolNotFoundException("Connection pool not found: " + poolName);
            }
            connectionPool = h_ConnectionPools.get(poolName);
        }
        catch (Throwable th) {
            throw new ConnectionPoolNotFoundException("The specified connection pool \"" + poolName + "\" could not be found. The underlying " + "error was a " + th.getClass().getName() + "The message was \"" + th.getMessage() + "\".");
        }
        return connectionPool;
    }

    @Override
    public ConnectionPool getPool() throws ConnectionPoolNotFoundException {
        ConnectionPool connectionPool = null;
        try {
            if (!h_ConnectionPools.containsKey(defaultPoolName)) {
                throw new ConnectionPoolNotFoundException("Default connection pool not found: " + defaultPoolName);
            }
            connectionPool = h_ConnectionPools.get(defaultPoolName);
        }
        catch (Throwable th) {
            throw new ConnectionPoolNotFoundException("The default connection pool \"" + defaultPoolName + "\" could not be found. The " + "underlying error was a " + th.getClass().getName() + "The message was \"" + th.getMessage() + "\".");
        }
        return connectionPool;
    }

    @Override
    public void shutdownModule() throws ModuleShutdownException {
        super.shutdownModule();
        for (Map.Entry<String, ConnectionPool> e : h_ConnectionPools.entrySet()) {
            e.getValue().close();
        }
    }
}

