/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fcrepo.server.storage.DOReader;

public class DOReaderCache
extends Thread {
    private final int m_maxReaders;
    private final int m_maxCachedSeconds;
    private final Map m_readers;
    private final List m_pidList;
    private boolean m_stopRequested;

    public DOReaderCache(int maxReaders, int maxCachedSeconds) {
        this.m_maxReaders = maxReaders;
        this.m_maxCachedSeconds = maxCachedSeconds;
        this.m_readers = new HashMap();
        this.m_pidList = new ArrayList();
        this.m_stopRequested = false;
        this.start();
    }

    @Override
    public void run() {
        while (!this.m_stopRequested) {
            this.removeExpired();
            if (this.m_stopRequested) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpired() {
        long cutoffTime = System.currentTimeMillis() - (long)(1000 * this.m_maxCachedSeconds);
        Map map = this.m_readers;
        synchronized (map) {
            if (this.m_pidList.size() > 0) {
                boolean done = false;
                ArrayList<String> expiredList = new ArrayList<String>();
                Iterator pids = this.m_pidList.iterator();
                while (pids.hasNext() && !done) {
                    String pid = (String)pids.next();
                    List l = (List)this.m_readers.get(pid);
                    long cachedTime = (Long)l.get(1);
                    if (cachedTime < cutoffTime) {
                        expiredList.add(pid);
                        continue;
                    }
                    done = true;
                }
                pids = expiredList.iterator();
                while (pids.hasNext()) {
                    this.remove((String)pids.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String pid) {
        Map map = this.m_readers;
        synchronized (map) {
            if (this.m_readers.remove(pid) != null) {
                this.m_pidList.remove(pid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(DOReader reader) {
        String pid = null;
        try {
            pid = reader.GetObjectPID();
        }
        catch (Exception e) {
            // empty catch block
        }
        Long time = new Long(System.currentTimeMillis());
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(reader);
        l.add(time);
        Map map = this.m_readers;
        synchronized (map) {
            this.m_readers.put(pid, l);
            if (this.m_pidList.contains(pid)) {
                this.m_pidList.remove(pid);
            }
            this.m_pidList.add(pid);
            if (this.m_readers.size() > this.m_maxReaders) {
                Object overflowPid = this.m_pidList.remove(0);
                this.m_readers.remove(overflowPid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOReader get(String pid) {
        DOReader reader = null;
        Map map = this.m_readers;
        synchronized (map) {
            List l = (List)this.m_readers.get(pid);
            if (l != null) {
                reader = (DOReader)l.get(0);
                l.remove(1);
                l.add(new Long(System.currentTimeMillis()));
                this.m_pidList.remove(pid);
                this.m_pidList.add(pid);
            }
        }
        return reader;
    }

    public void close() {
        this.m_stopRequested = true;
    }
}

