/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.httpclient.Header;
import org.fcrepo.common.http.HttpInputStream;
import org.fcrepo.common.http.WebClient;
import org.fcrepo.common.http.WebClientConfiguration;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.HttpServiceNotFoundException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.security.BackendSecurity;
import org.fcrepo.server.security.BackendSecuritySpec;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.server.utilities.ServerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExternalContentManager
extends Module
implements ExternalContentManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExternalContentManager.class);
    private static final String DEFAULT_MIMETYPE = "text/plain";
    private String m_userAgent;
    private String fedoraServerHost;
    private String fedoraServerPort;
    private String fedoraServerRedirectPort;
    private WebClientConfiguration m_httpconfig;
    private WebClient m_http;

    public DefaultExternalContentManager(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        try {
            Server s_server = this.getServer();
            this.m_userAgent = this.getParameter("userAgent");
            if (this.m_userAgent == null) {
                this.m_userAgent = "Fedora";
            }
            this.fedoraServerPort = s_server.getParameter("fedoraServerPort");
            this.fedoraServerHost = s_server.getParameter("fedoraServerHost");
            this.fedoraServerRedirectPort = s_server.getParameter("fedoraRedirectPort");
            this.m_httpconfig = s_server.getWebClientConfig();
            if (this.m_httpconfig.getUserAgent() == null) {
                this.m_httpconfig.setUserAgent(this.m_userAgent);
            }
            this.m_http = new WebClient(this.m_httpconfig);
        }
        catch (Throwable th) {
            throw new ModuleInitializationException("[DefaultExternalContentManager] An external content manager could not be instantiated. The underlying error was a " + th.getClass().getName() + "The message was \"" + th.getMessage() + "\".", this.getRole());
        }
    }

    @Override
    public MIMETypedStream getExternalContent(ContentManagerParams params) throws GeneralException, HttpServiceNotFoundException {
        logger.debug("in getExternalContent(), url=" + params.getUrl());
        try {
            if (params.getProtocol().equals("file")) {
                return this.getFromFilesystem(params);
            }
            if (params.getProtocol().equals("http") || params.getProtocol().equals("https")) {
                return this.getFromWeb(params);
            }
            throw new GeneralException("protocol for retrieval of external content not supported. URL: " + params.getUrl());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new HttpServiceNotFoundException("[" + this.getClass().getSimpleName() + "] " + "returned an error.  The underlying error was a " + ex.getClass().getName() + "  The message " + "was  \"" + ex.getMessage() + "\"  .  ", ex);
        }
    }

    private MIMETypedStream get(String url, String user, String pass, String knownMimeType) throws GeneralException {
        logger.debug("DefaultExternalContentManager.get(" + url + ")");
        try {
            HttpInputStream response = this.m_http.get(url, true, user, pass);
            String mimeType = response.getResponseHeaderValue("Content-Type", knownMimeType);
            long length = Long.parseLong(response.getResponseHeaderValue("Content-Length", "-1"));
            Property[] headerArray = DefaultExternalContentManager.toPropertyArray(response.getResponseHeaders());
            if (mimeType == null || mimeType.equals("")) {
                mimeType = DEFAULT_MIMETYPE;
            }
            return new MIMETypedStream(mimeType, (InputStream)response, headerArray, length);
        }
        catch (Exception e) {
            throw new GeneralException("Error getting " + url, e);
        }
    }

    private static Property[] toPropertyArray(Header[] headers) {
        Property[] props = new Property[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            props[i] = new Property();
            props[i].name = headers[i].getName();
            props[i].value = headers[i].getValue();
        }
        return props;
    }

    private MIMETypedStream getFromFilesystem(ContentManagerParams params) throws HttpServiceNotFoundException, GeneralException {
        logger.debug("in getFile(), url=" + params.getUrl());
        try {
            URL fileUrl = new URL(params.getUrl());
            File cFile = new File(fileUrl.toURI()).getCanonicalFile();
            URI cURI = cFile.toURI();
            logger.info("Checking resolution security on " + cURI);
            Authorization authModule = this.getServer().getBean("org.fcrepo.server.security.Authorization", Authorization.class);
            if (authModule == null) {
                throw new GeneralException("Missing required Authorization module");
            }
            authModule.enforceRetrieveFile(params.getContext(), cURI.toString());
            String mimeType = params.getMimeType();
            if (mimeType == null || mimeType.equalsIgnoreCase("")) {
                mimeType = this.determineMimeType(cFile);
            }
            return new MIMETypedStream(mimeType, fileUrl.openStream(), null, cFile.length());
        }
        catch (AuthzException ae) {
            logger.error(ae.getMessage(), (Throwable)ae);
            throw new HttpServiceNotFoundException("Policy blocked datastream resolution", ae);
        }
        catch (GeneralException me) {
            logger.error(me.getMessage(), (Throwable)me);
            throw me;
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
            logger.error(th.getMessage(), th);
            throw new HttpServiceNotFoundException("[FileExternalContentManager] returned an error.  The underlying error was a " + th.getClass().getName() + "  The message " + "was  \"" + th.getMessage() + "\"  .  ", th);
        }
    }

    private MIMETypedStream getFromWeb(ContentManagerParams params) throws ModuleInitializationException, GeneralException {
        String username = params.getUsername();
        String password = params.getPassword();
        boolean backendSSL = false;
        String url = params.getUrl();
        if (ServerUtility.isURLFedoraServer(url = DOTranslationUtility.makeAbsoluteURLs(url)) && !params.isBypassBackend()) {
            BackendSecuritySpec m_beSS;
            BackendSecurity m_beSecurity = (BackendSecurity)((Object)this.getServer().getModule("org.fcrepo.server.security.BackendSecurity"));
            try {
                m_beSS = m_beSecurity.getBackendSecuritySpec();
            }
            catch (Exception e) {
                throw new ModuleInitializationException("Can't intitialize BackendSecurity module (in default access) from Server.getModule", this.getRole());
            }
            Hashtable<String, String> beHash = m_beSS.getSecuritySpec("fedoraInternalCall-1");
            username = beHash.get("callUsername");
            password = beHash.get("callPassword");
            backendSSL = new Boolean(beHash.get("callSSL"));
            if (backendSSL) {
                if (params.getProtocol().equals("http")) {
                    url = url.replaceFirst("http:", "https:");
                }
                url = url.replaceFirst(":" + this.fedoraServerPort + "/", ":" + this.fedoraServerRedirectPort + "/");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("************************* backendUsername: " + username + "     backendPassword: " + password + "     backendSSL: " + backendSSL);
                logger.debug("************************* doAuthnGetURL: " + url);
            }
        }
        return this.get(url, username, password, params.getMimeType());
    }

    private String determineMimeType(File file) {
        String mimeType = new MimetypesFileTypeMap().getContentType(file);
        if (mimeType == null || mimeType.equalsIgnoreCase("")) {
            mimeType = DEFAULT_MIMETYPE;
        }
        return mimeType;
    }
}

