/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StorageDeviceException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.SimpleServiceDefinitionReader;
import org.fcrepo.server.storage.SimpleServiceDeploymentReader;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedRepositoryReader
implements RepositoryReader {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryBasedRepositoryReader.class);
    private final DOTranslator m_translator;
    private final String m_exportFormat;
    private final String m_storageFormat;
    private final String m_encoding;
    private final HashMap m_files = new HashMap();

    public DirectoryBasedRepositoryReader(File directory, DOTranslator translator, String exportFormat, String storageFormat, String encoding) throws StorageDeviceException, ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        this.m_translator = translator;
        this.m_exportFormat = exportFormat;
        this.m_storageFormat = storageFormat;
        this.m_encoding = encoding;
        File[] files = directory.listFiles();
        if (!directory.isDirectory()) {
            throw new StorageDeviceException("Repository storage directory not found.");
        }
        try {
            for (File thisFile : files) {
                try {
                    FileInputStream in = new FileInputStream(thisFile);
                    SimpleDOReader reader = new SimpleDOReader(null, this, this.m_translator, this.m_exportFormat, this.m_storageFormat, this.m_encoding, in);
                    String pid = reader.GetObjectPID();
                    if (reader.GetObjectPID().length() == 0) {
                        logger.warn("File " + thisFile + " has no pid...skipping");
                        continue;
                    }
                    this.m_files.put(pid, thisFile);
                }
                catch (NullPointerException npe) {
                    logger.warn("Error in " + thisFile.getName() + "...skipping");
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
    }

    private InputStream getStoredObjectInputStream(String pid) throws ObjectNotFoundException {
        try {
            return new FileInputStream((File)this.m_files.get(pid));
        }
        catch (Throwable th) {
            throw new ObjectNotFoundException("The object, " + pid + " was " + "not found in the repository.");
        }
    }

    @Override
    public DOReader getReader(boolean UseCachedObject, Context context, String pid) throws ObjectIntegrityException, ObjectNotFoundException, StreamIOException, UnsupportedTranslationException, ServerException {
        return new SimpleDOReader(null, this, this.m_translator, this.m_exportFormat, this.m_storageFormat, this.m_encoding, this.getStoredObjectInputStream(pid));
    }

    @Override
    public ServiceDeploymentReader getServiceDeploymentReader(boolean UseCachedObject, Context context, String pid) throws ObjectIntegrityException, ObjectNotFoundException, StreamIOException, UnsupportedTranslationException, ServerException {
        return new SimpleServiceDeploymentReader(null, this, this.m_translator, this.m_exportFormat, this.m_storageFormat, this.m_encoding, this.getStoredObjectInputStream(pid));
    }

    @Override
    public ServiceDefinitionReader getServiceDefinitionReader(boolean UseCachedObject, Context context, String pid) throws ObjectIntegrityException, ObjectNotFoundException, StreamIOException, UnsupportedTranslationException, ServerException {
        return new SimpleServiceDefinitionReader(null, this, this.m_translator, this.m_exportFormat, this.m_storageFormat, this.m_encoding, this.getStoredObjectInputStream(pid));
    }

    @Override
    public String[] listObjectPIDs(Context context) {
        String[] out = new String[this.m_files.keySet().size()];
        Iterator iter = this.m_files.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            out[i++] = (String)iter.next();
        }
        return out;
    }
}

