/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.fcrepo.common.http.HttpInputStream;
import org.fcrepo.common.http.WebClient;
import org.fcrepo.common.http.WebClientConfiguration;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DefaultDOManager;
import org.fcrepo.server.storage.types.DigitalObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSearchDOManager
extends DefaultDOManager {
    private static final Logger logger = LoggerFactory.getLogger(GSearchDOManager.class);
    public static final String GSEARCH_REST_URL = "gSearchRESTURL";
    public static final String GSEARCH_USERNAME = "gSearchUsername";
    public static final String GSEARCH_PASSWORD = "gSearchPassword";
    private String _gSearchRESTURL;
    private UsernamePasswordCredentials _gSearchCredentials;
    private WebClientConfiguration _webClientConfig;
    private WebClient _webClient;

    public GSearchDOManager(Map moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void postInitModule() throws ModuleInitializationException {
        super.postInitModule();
        this._gSearchRESTURL = this.getParameter(GSEARCH_REST_URL);
        if (this._gSearchRESTURL == null) {
            throw new ModuleInitializationException("Required parameter, gSearchRESTURL was not specified", this.getRole());
        }
        try {
            new URL(this._gSearchRESTURL);
            logger.debug("Configured GSearch REST URL: " + this._gSearchRESTURL);
        }
        catch (MalformedURLException e) {
            throw new ModuleInitializationException("Malformed URL given for gSearchRESTURL parameter: " + this._gSearchRESTURL, this.getRole());
        }
        String user = this.getParameter(GSEARCH_USERNAME);
        if (user != null) {
            logger.debug("Will authenticate to GSearch service as user: " + user);
            String pass = this.getParameter(GSEARCH_PASSWORD);
            if (pass == null) throw new ModuleInitializationException("gSearchPassword must be specified because gSearchUsername was specified", this.getRole());
            this._gSearchCredentials = new UsernamePasswordCredentials(user, pass);
        } else {
            logger.debug("gSearchUsername unspecified; will not attempt to authenticate to GSearch service");
        }
        this._webClientConfig = this.getServer().getWebClientConfig();
        this._webClient = new WebClient(this._webClientConfig);
    }

    @Override
    public void doCommit(boolean cachedObjectRequired, Context context, DigitalObject obj, String logMessage, boolean remove) throws ServerException {
        super.doCommit(cachedObjectRequired, context, obj, logMessage, remove);
        StringBuffer url = new StringBuffer();
        url.append(this._gSearchRESTURL + "?operation=updateIndex");
        String pid = obj.getPid();
        url.append("&value=" + GSearchDOManager.urlEncode(pid));
        if (remove) {
            logger.info("Signaling removal of " + pid + " to GSearch");
            url.append("&action=deletePid");
        } else {
            if (logger.isInfoEnabled()) {
                if (obj.isNew()) {
                    logger.info("Signaling add of " + pid + " to GSearch");
                } else {
                    logger.info("Signaling mod of " + pid + " to GSearch");
                }
            }
            url.append("&action=fromPid");
        }
        this.sendRESTMessage(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRESTMessage(String url) {
        HttpInputStream response = null;
        try {
            logger.debug("Getting " + url);
            response = this._webClient.get(url, false, this._gSearchCredentials);
            int code = response.getStatusCode();
            if (code != 200) {
                logger.warn("Error sending update to GSearch service (url=" + url + ").  HTTP response code was " + code + ". " + "Body of response from GSearch follows:\n" + GSearchDOManager.getString((InputStream)response));
            }
        }
        catch (Exception e) {
            logger.warn("Error sending update to GSearch service via URL: " + url, (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception e) {
                    logger.warn("Error closing GSearch response", (Throwable)e);
                }
            }
        }
    }

    private static String getString(InputStream in) {
        try {
            StringBuffer out = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                out.append(line + "\n");
                line = reader.readLine();
            }
            return out.toString();
        }
        catch (Exception e) {
            return "[Error reading response body: " + e.getClass().getName() + ": " + e.getMessage() + "]";
        }
    }

    private static final String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            logger.warn("Failed to encode '" + s + "'", (Throwable)e);
            return s;
        }
    }
}

