/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.Triple;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.io.TripleIteratorFactory;

public abstract class RDFRelationshipReader {
    public static Set<RelationshipTuple> readRelationships(Datastream ds) throws ServerException {
        if (ds == null) {
            return new HashSet<RelationshipTuple>();
        }
        try {
            return RDFRelationshipReader.readRelationships(ds.getContentStream());
        }
        catch (TrippiException e) {
            throw new GeneralException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<RelationshipTuple> readRelationships(InputStream dsContent) throws TrippiException {
        HashSet<RelationshipTuple> tuples = new HashSet<RelationshipTuple>();
        TripleIterator iter = null;
        try {
            iter = TripleIteratorFactory.defaultInstance().fromStream(dsContent, RDFFormat.RDF_XML);
            while (iter.hasNext()) {
                String object;
                Triple triple = iter.next();
                String subject = triple.getSubject().toString();
                String predicate = triple.getPredicate().toString();
                ObjectNode objectNode = triple.getObject();
                boolean isLiteral = objectNode instanceof Literal;
                String datatype = null;
                if (isLiteral) {
                    object = ((Literal)objectNode).getLexicalForm();
                    URI datatypeURI = ((Literal)objectNode).getDatatypeURI();
                    if (datatypeURI != null) {
                        datatype = datatypeURI.toString();
                    }
                } else {
                    object = triple.getObject().toString();
                }
                tuples.add(new RelationshipTuple(subject, predicate, object, isLiteral, datatype));
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        return tuples;
    }
}

